/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.wizards;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.wizards.AbstractJamaicaBuildFileBuilder;
import com.aicas.jamaica.eclipse.ant_editor.wizards.GeneralSettingsWizardPage;
import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.BoxiOptions;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.Path;

class SimpleJBFBuilder
extends AbstractJamaicaBuildFileBuilder {
    private String includeNativeClasses = "java.lang...  java.io... java.net... java.nio.MappedByteBuffer java.sql... java.util.zip... javax.realtime... com.aicas.jamaica.lang... sun.misc.GC sun.misc.Unsafe sun.nio.ch.IOUtil sun.nio.ch.ServerSocketChannelImpl sun.nio.ch.PipeDispatcher sun.nio.ch.DatagramChannelImpl sun.reflect.ConstantPool sun.rmi.server.MarshalInputStream";

    public SimpleJBFBuilder(GeneralSettingsWizardPage page) {
        this.page = page;
    }

    public String buildJamaicaBuildFileScript() {
        String guessedExecName;
        this.addHeader();
        this.startProject(this.page.getNoMainClass() ? this.page.getDestination() : this.page.getMainClass(), ".", SimpleJBFBuilder.builderTargetName(this.page.getNoMainClass() ? this.page.getDestination() : this.page.getMainClass()));
        this.increaseIndent();
        this.addCopyright(MessageFormat.format("Jamaica Buildfile for application ''{0}''", this.page.getMainClass()));
        if (AntEditorPlugin.getDefault().getAntEditorVersion() != null) {
            this.addPlainLine("<!-- JAMAICA_ANT_EDITOR_VERSION=" + AntEditorPlugin.getDefault().getAntEditorVersion() + " -->");
        }
        JamaicaVMDistribution dist = this.page.getDistribution();
        ToolType type = ToolType.JAMAICA;
        if (dist.getToolOptions(ToolType.JAMAICA) == null && dist.getToolOptions(ToolType.JAMAICA_INTERNAL) != null) {
            type = ToolType.JAMAICA_INTERNAL;
        }
        String builderTagname = type.tagname((AbstractJamaicaDistribution)dist);
        String jamaicahTagname = ToolType.JAMAICAH.tagname((AbstractJamaicaDistribution)dist);
        String jarAcceleratorTagname = ToolType.JARACCELERATOR.tagname((AbstractJamaicaDistribution)dist);
        IToolOptions builderToolOpts = dist.getToolOptions(type);
        if (builderToolOpts == null) {
            return String.valueOf(type.toolname()) + " not available.";
        }
        String builderClasspath = builderToolOpts.getToolClasspath();
        String jamaicahClasspath = dist.getToolOptions(ToolType.JAMAICAH).getToolClasspath();
        String jarAcceleratorClasspath = dist.getToolOptions(ToolType.JARACCELERATOR).getToolClasspath();
        builderClasspath = builderClasspath.replace(dist.getInstallDirectory(), "${jamaica}");
        jamaicahClasspath = jamaicahClasspath.replace(dist.getInstallDirectory(), "${jamaica}");
        jarAcceleratorClasspath = jarAcceleratorClasspath.replace(dist.getInstallDirectory(), "${jamaica}");
        AntEditorPlugin.StringClasspathDescriber scd = AntEditorPlugin.getClasspath(this.page.getProject());
        if (scd == null) {
            return "Could not retrieve the string classpath describer.";
        }
        if (!scd.variableLocations.isEmpty()) {
            this.addEmptyLine();
            this.addComment("Classpath variable defaults");
            for (String e : scd.variableLocations) {
                this.addProperty(scd.varName(e), scd.varValue(e));
            }
        }
        this.addEnvProperty("env");
        this.addJamaicaCondition("env");
        this.addJamaicaFail();
        this.addTaskdef(builderTagname, type.classname(), builderClasspath);
        this.addTaskdef(jamaicahTagname, ToolType.JAMAICAH.classname(), jamaicahClasspath);
        this.addTaskdef(jarAcceleratorTagname, ToolType.JARACCELERATOR.classname(), jarAcceleratorClasspath);
        this.addEmptyLine();
        LinkedHashMap<String, PossiblyEscapedString> options = new LinkedHashMap<String, PossiblyEscapedString>();
        options.put("target", PossiblyEscapedString.plain((String)this.page.getTarget()));
        if (this.page.getNoMainClass()) {
            options.put("XnoMain", PossiblyEscapedString.plain((String)"true"));
            options.put("destination", PossiblyEscapedString.plain((String)this.page.getDestination()));
            options.put("smart", PossiblyEscapedString.plain((String)"false"));
            options.put("includeClasses", PossiblyEscapedString.plain((String)this.includeNativeClasses));
        } else {
            options.put("main", PossiblyEscapedString.plain((String)this.page.getMainClass()));
        }
        PossiblyEscapedString tmpDefault = this.page.getDistribution().getToolOptions(ToolType.JAMAICA).getDefaultValue("tmpdir", this.page.getTarget());
        options.put("tmpdir", tmpDefault != null ? tmpDefault : PossiblyEscapedString.plain((String)"tmp"));
        options.put("interpret", PossiblyEscapedString.plain((String)"true"));
        if (this.page.getCreateThreadMonitorApp()) {
            if (this.page.getThreadMonitorBlockingMode()) {
                options.put("XdefineProperty", PossiblyEscapedString.plain((String)("jamaica.scheduler_events_port_blocking=" + this.page.getTracePort())));
            } else {
                options.put("XdefineProperty", PossiblyEscapedString.plain((String)("jamaica.scheduler_events_port=" + this.page.getTracePort())));
            }
        }
        ArrayList<PossiblyEscapedString> cpItems = new ArrayList<PossiblyEscapedString>();
        for (String s : scd.outputLocations) {
            cpItems.add(PossiblyEscapedString.plain((String)s));
        }
        for (String s : scd.libraryLocations) {
            cpItems.add(PossiblyEscapedString.plain((String)s));
        }
        if (!scd.variableLocations.isEmpty()) {
            for (String e : scd.variableLocations) {
                String modLoc = e.replaceFirst(scd.varName(e), "\\$\\{" + scd.varName(e) + "\\}");
                cpItems.add(PossiblyEscapedString.plain((String)modLoc));
            }
        }
        if (dist.getToolOptions(ToolType.JAMAICA) instanceof BoxiOptions) {
            options.put("classpath", builderToolOpts.join(cpItems, Arrays.asList(File.pathSeparator, " ")));
        } else {
            options.put("classpath", builderToolOpts.join(cpItems, Arrays.asList(File.pathSeparator)));
        }
        this.addEmptyLine();
        String version = dist.getVersion();
        if (this.page.getNoMainClass()) {
            guessedExecName = this.page.getDestination();
        } else {
            guessedExecName = this.page.getMainClass();
            if (dist.getVersionMajor() == 6 && dist.getVersionMinor() >= 3 || dist.getVersionMajor() > 6) {
                guessedExecName = AntEditorPlugin.getSimpleClassName(guessedExecName);
            }
        }
        if (!guessedExecName.endsWith(AntEditorPlugin.getExeExtension())) {
            guessedExecName = String.valueOf(guessedExecName) + AntEditorPlugin.getExeExtension();
        }
        this.addTool(type, SimpleJBFBuilder.builderTargetName(this.page.getNoMainClass() ? this.page.getDestination() : this.page.getMainClass()), null, this.page.getCreateExecLaunchTarget() ? "jamaica.executable_of_" + SimpleJBFBuilder.builderTargetName(this.page.getNoMainClass() ? this.page.getDestination() : this.page.getMainClass()) + "_available" : null, "${jamaica}", ToolType.isInternalType((ToolType)type) ? "version=\"" + version.substring(0, version.indexOf(45)) + "\" release=\"" + version.substring(version.indexOf(45) + 1) + '\"' : null, AntEditorPlugin.resolve(new Path(this.page.getProject()).append(guessedExecName)), dist.getHostTarget().equals(this.page.getTarget()), options);
        this.addEmptyLine();
        this.decreaseIndent();
        if (this.page.getCreateExecLaunchTarget()) {
            this.increaseIndent();
            this.addPlainLine("<target name=\"launch_" + (this.page.getNoMainClass() ? this.page.getDestination() : this.page.getMainClass()) + "\">");
            this.increaseIndent();
            this.addPlainLine("<available file=\"" + guessedExecName + "\" " + "property" + "=\"jamaica.executable_of_" + SimpleJBFBuilder.builderTargetName(this.page.getNoMainClass() ? this.page.getDestination() : this.page.getMainClass()) + "_available\"/>");
            this.addPlainLine("<antcall target=\"" + SimpleJBFBuilder.builderTargetName(this.page.getNoMainClass() ? this.page.getDestination() : this.page.getMainClass()) + "\"/>");
            this.addPlainLine("<exec executable=\"" + guessedExecName + "\" " + "resolveexecutable" + "=\"true\"/>");
            this.decreaseIndent();
            this.addPlainLine("</target>");
            this.addEmptyLine();
            this.decreaseIndent();
        }
        this.endProject();
        return null;
    }

    private static String builderTargetName(String mainClass) {
        return "build_" + mainClass;
    }
}

