/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.DOMUtils;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ToolEnv {
    private final ToolChunk toolChunk;
    public static final String ATTR_KEY = "key";
    public static final String ATTR_VALUE = "value";
    private Element optionElement;

    public ToolEnv(ToolChunk toolChunk, Element optElement) {
        this.toolChunk = toolChunk;
        this.optionElement = optElement;
    }

    public String getValue() {
        return this.optionElement.getAttribute(ATTR_VALUE);
    }

    public void setValue(String value) {
        this.optionElement.setAttribute(ATTR_VALUE, value);
    }

    public boolean isChildOfTree() {
        Node parent = this.optionElement.getParentNode();
        return this.toolChunk.getToolNode().isSameNode(parent);
    }

    public boolean addToTree() {
        boolean res = false;
        Node parent = this.optionElement.getParentNode();
        if (parent == null) {
            String envName;
            if (!this.optionElement.getOwnerDocument().equals(this.toolChunk.getToolNode().getOwnerDocument())) {
                this.optionElement = (Element)this.toolChunk.getToolNode().getOwnerDocument().adoptNode(this.optionElement);
            }
            if (this.toolChunk.envs.containsKey(envName = this.getKey())) {
                Element oldEnv = this.toolChunk.envs.get(envName).getElement();
                oldEnv.getParentNode().replaceChild(this.optionElement, oldEnv);
                res = true;
            } else {
                res = DOMUtils.appendNode(this.toolChunk.getToolNode(), this.optionElement);
            }
        }
        return res;
    }

    public boolean removeFromTree() {
        return DOMUtils.removeNode(this.optionElement);
    }

    public String getKey() {
        String optionName = "";
        if (this.getElement().getTagName().toLowerCase().equals("env")) {
            optionName = this.getElement().getAttribute(ATTR_KEY);
        }
        return optionName;
    }

    public Element getElement() {
        return this.optionElement;
    }

    public String toString() {
        return "Env:key=" + this.getKey() + ":value=" + this.getValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getKey() == null ? 0 : this.getKey().hashCode());
        result = 31 * result + (this.getValue() == null ? 0 : this.getValue().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolEnv)) {
            return false;
        }
        ToolEnv other = (ToolEnv)obj;
        if (!this.getKey().equals(other.getKey())) {
            return false;
        }
        if (!this.optionElement.getTagName().equals(other.optionElement.getTagName())) {
            return false;
        }
        return this.getValue().equals(other.getValue());
    }
}

