/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DOMUtils {
    public static final String NEWLINE = "\n";
    private static DocumentBuilderFactory docBuilderFactory = null;
    private static DocumentBuilder docBuilder = null;
    private static TransformerFactory transformerFactory = null;
    private static Transformer transformer = null;
    private static boolean isInitiated = false;

    DOMUtils() {
    }

    private static void init() throws ParserConfigurationException, TransformerConfigurationException {
        docBuilderFactory = DocumentBuilderFactory.newInstance();
        transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", new Integer(2));
        docBuilder = docBuilderFactory.newDocumentBuilder();
        transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        isInitiated = true;
    }

    public static Document getDocument(String xmlData) throws Exception {
        Document doc = null;
        if (!isInitiated) {
            DOMUtils.init();
        }
        doc = docBuilder.parse(new InputSource(new StringReader(xmlData)));
        return doc;
    }

    public static String serializeDocument(Document doc) throws Exception {
        StringWriter strWriter = new StringWriter();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(strWriter);
        if (!isInitiated) {
            DOMUtils.init();
        }
        transformer.transform(source, result);
        return strWriter.toString();
    }

    public static boolean appendNode(Node parentNode, Node newNode) {
        boolean retval = false;
        if (newNode.getParentNode() == null) {
            Node last;
            if (!newNode.getOwnerDocument().equals(parentNode.getOwnerDocument())) {
                newNode = parentNode.getOwnerDocument().adoptNode(newNode);
            }
            for (last = parentNode.getLastChild(); last != null; last = last.getPreviousSibling()) {
                if (last.getNodeType() == 8 || last.getNodeType() == 3) {
                    if (last.getPreviousSibling() == null) break;
                    continue;
                }
                last = last.getNextSibling();
                break;
            }
            parentNode.insertBefore(newNode, last);
            retval = true;
        }
        return retval;
    }

    public static boolean removeNode(Node node) {
        boolean res = false;
        Node parent = node.getParentNode();
        if (parent != null) {
            Node prevSib = node.getPreviousSibling();
            if (prevSib != null && prevSib.getNodeType() == 3) {
                parent.removeChild(prevSib);
            }
            node = parent.removeChild(node);
            res = true;
        }
        return res;
    }

    public static List<Node> findNodes(Node n, short type) {
        ArrayList<Node> result = null;
        if (n != null) {
            result = new ArrayList<Node>();
            if (n.getNodeType() == type) {
                result.add(n);
            }
            int i = 0;
            while (i < n.getChildNodes().getLength()) {
                result.addAll(DOMUtils.findNodes(n.getChildNodes().item(i), type));
                ++i;
            }
        }
        return result;
    }

    public static int nodeDepth(Node n) {
        int result = -1;
        while (n != null) {
            n = n.getParentNode();
            ++result;
        }
        return result;
    }

    public static int maxChildDepth(Node n) {
        int curMax = -1;
        int hasChild = 0;
        if (n != null) {
            curMax = 0;
            if (n.hasChildNodes()) {
                hasChild = 1;
                int i = 0;
                while (i < n.getChildNodes().getLength()) {
                    curMax = Math.max(curMax, hasChild + DOMUtils.maxChildDepth(n.getChildNodes().item(i)));
                    ++i;
                }
            }
        }
        return curMax;
    }

    public static String multiChar(char c, int n) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < n) {
            res.append(c);
            ++i;
        }
        return res.toString();
    }
}

