/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.editors.JamaicaAntEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.Messages;
import com.aicas.jamaica.eclipse.ant_editor.editors.OverviewPageBody;
import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.ui.AboutEditorHandler;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class OverviewPage
extends FormPage
implements IModelPartChangedListener,
IPropertyListener {
    public static final String OVERVIEW_PAGE_ID = "com.aicas.jamaica.eclipse.ant_editor.editors.OverviewPage";
    private JamaicaAntEditor editor;
    private ProjectFile model;
    private FormToolkit toolkit;
    private ScrolledForm overviewForm;
    private String cachedError;
    private OverviewPageBody overviewBody;

    public OverviewPage(JamaicaAntEditor parent) {
        super((FormEditor)parent, OVERVIEW_PAGE_ID, Messages.OverviewPage_page_title);
        this.editor = parent;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.overviewForm = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        Composite body = this.overviewForm.getBody();
        this.toolkit.decorateFormHeading(this.overviewForm.getForm());
        this.overviewForm.setText(Messages.OverviewPage_page_title);
        this.overviewForm.setImage(JamaicaAntEditor.getResourceManager().createImage(JamaicaAntEditor.PluginImage.IMG_OVERVIEW_PAGE_HEADER.getImgDesc()));
        ToolBarManager tbman = (ToolBarManager)this.overviewForm.getToolBarManager();
        Action aboutAction = new Action("aboutJAE"){

            public void run() {
                try {
                    new AboutEditorHandler().execute(null);
                }
                catch (ExecutionException e) {
                    AntEditorPlugin.log(e);
                }
            }
        };
        aboutAction.setToolTipText("Show version");
        aboutAction.setImageDescriptor(JamaicaAntEditor.PluginImage.IMG_JAMAICA_VM_LOGO.getImgDesc());
        tbman.add((IAction)aboutAction);
        tbman.update(true);
        GridLayout bodyLayout = new GridLayout(1, true);
        bodyLayout.marginWidth = 0;
        bodyLayout.marginHeight = 0;
        bodyLayout.horizontalSpacing = 0;
        bodyLayout.verticalSpacing = 0;
        body.setLayout((Layout)bodyLayout);
        this.overviewBody = new OverviewPageBody(body, 0, this.model, this.editor, this.toolkit);
        this.overviewForm.setMinSize(0, 0);
        if (this.cachedError != null) {
            this.displayError(this.cachedError);
        } else if (this.model != null) {
            this.updateUI();
        }
    }

    public void setProjectFile(ProjectFile projectFile) {
        this.model = projectFile;
        projectFile.addListener(this);
        if (this.overviewForm != null) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    OverviewPage.this.updateUI();
                }
            });
        }
    }

    public void setActive(boolean active) {
        if (active) {
            this.updateUI();
        }
        super.setActive(active);
    }

    public void modelPartChanged(ModelPartChangedEvent mpcEvent) {
        if (this.overviewForm != null && !this.overviewForm.isDisposed()) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    OverviewPage.this.updateUI();
                }
            });
        }
    }

    public void dispose() {
        if (this.model != null) {
            this.model.removeListener(this);
        }
        super.dispose();
    }

    private void updateUI() {
        if (this.model == null || this.overviewForm == null || this.overviewForm.isDisposed()) {
            return;
        }
        this.overviewForm.setRedraw(false);
        this.overviewBody.updateUI();
        this.overviewForm.reflow(true);
        this.overviewForm.setMinSize(0, 0);
        this.overviewForm.layout(true, true);
        this.overviewForm.setRedraw(true);
    }

    void displayError(String message) {
        if (this.overviewForm == null) {
            this.cachedError = message;
            return;
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (source.equals(this.editor)) {
            switch (propId) {
                case 258: {
                    this.setInput(this.editor.getEditorInput());
                    break;
                }
                case 1: {
                    break;
                }
                case 257: {
                    break;
                }
            }
        }
    }
}

