/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.ui;

import com.aicas.jamaica.eclipse.ant_editor.model.PropertiesManager;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunkManager;
import com.aicas.jamaica.eclipse.ant_editor.ui.AntPropertiesCellModifier;
import com.aicas.jamaica.eclipse.ant_editor.ui.AntPropertiesLabelProvider;
import com.aicas.jamaica.eclipse.ant_editor.ui.TaskdefsLabelProvider;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;

public class ViewerFactory {
    public static ComboViewer getDistributionViewer(Composite parent) {
        ComboViewer distriViewer = new ComboViewer(parent, 2060);
        distriViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        distriViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                JamaicaVMDistribution dist = (JamaicaVMDistribution)element;
                return MessageFormat.format("{0} [{1}]", dist.toString(), dist.getInstallDirectory());
            }
        });
        distriViewer.setInput(JamaicaVMDistribution.distributions.values());
        return distriViewer;
    }

    public static TableViewer getPropertiesViewer(Composite parent, PropertiesManager propertiesManager) {
        TableViewer propertiesViewer = new TableViewer(parent, 2818);
        propertiesViewer.setLabelProvider((IBaseLabelProvider)new AntPropertiesLabelProvider(propertiesManager));
        propertiesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        propertiesViewer.getTable().setHeaderVisible(true);
        propertiesViewer.getTable().setLinesVisible(true);
        TableColumn nameCol = new TableColumn(propertiesViewer.getTable(), 0);
        nameCol.setText("Name");
        TableColumn valueCol = new TableColumn(propertiesViewer.getTable(), 0);
        valueCol.setText("Value");
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)propertiesViewer.getTable()), new TextCellEditor((Composite)propertiesViewer.getTable())};
        propertiesViewer.setColumnProperties(AntPropertiesLabelProvider.COLUMNS_PROPS);
        propertiesViewer.setCellEditors(cellEditors);
        propertiesViewer.setCellModifier((ICellModifier)new AntPropertiesCellModifier(propertiesManager));
        return propertiesViewer;
    }

    public static TableViewer getTaskdefViewer(Composite parent, TaskdefManager taskdefManager) {
        TableViewer taskdefViewer = new TableViewer(parent, 2820);
        taskdefViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        taskdefViewer.setLabelProvider((IBaseLabelProvider)new TaskdefsLabelProvider(taskdefManager));
        taskdefViewer.getTable().setHeaderVisible(true);
        taskdefViewer.getTable().setLinesVisible(true);
        String[] stringArray = TaskdefsLabelProvider.COLUMN_PROPS;
        int n = TaskdefsLabelProvider.COLUMN_PROPS.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TableColumn xColumn = new TableColumn(taskdefViewer.getTable(), 0);
            xColumn.setText(columnName);
            ++n2;
        }
        taskdefViewer.setInput((Object)taskdefManager.getNames().toArray());
        stringArray = taskdefViewer.getTable().getColumns();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String tc = stringArray[n2];
            tc.pack();
            ++n2;
        }
        return taskdefViewer;
    }

    public static TableViewer getTaskdefViewer(Composite parent, TaskdefManager taskdefManager, ToolType ... restrictToType) {
        TableViewer taskdefViewer = new TableViewer(parent, 2820);
        taskdefViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        taskdefViewer.setLabelProvider((IBaseLabelProvider)new TaskdefsLabelProvider(taskdefManager));
        taskdefViewer.getTable().setHeaderVisible(true);
        taskdefViewer.getTable().setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(taskdefViewer.getTable(), 0);
        nameColumn.setText(TaskdefsLabelProvider.COLUMN_NAME);
        TableColumn distriColumn = new TableColumn(taskdefViewer.getTable(), 0);
        distriColumn.setText(TaskdefsLabelProvider.COLUMN_DIST);
        ArrayList<String> taskNames = new ArrayList<String>();
        List<ToolType> restrictList = Arrays.asList(restrictToType);
        for (String taskdefName : taskdefManager.getNames()) {
            if (!restrictList.contains(taskdefManager.getToolType(taskdefName))) continue;
            taskNames.add(taskdefName);
        }
        taskdefViewer.setInput(taskNames);
        TableColumn[] tableColumnArray = taskdefViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tc.pack();
            ++n2;
        }
        return taskdefViewer;
    }

    public static ComboViewer getToolTypeViewer(Composite parent) {
        ComboViewer toolTypeViewer = new ComboViewer(parent, 2060);
        toolTypeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ToolType)element).toolname();
            }
        });
        toolTypeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList<ToolType> types = new ArrayList<ToolType>();
        types.addAll(Arrays.asList(ToolType.values()));
        types.remove(ToolType.INVALID);
        toolTypeViewer.setInput(types);
        return toolTypeViewer;
    }

    public static ComboViewer getToolTargetsViewer(Composite parent, ToolChunkManager toolChunkManager, ToolType ... type) {
        ComboViewer toolTargetViewer = new ComboViewer(parent, 2060);
        toolTargetViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        toolTargetViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        ArrayList<String> toolTargets = new ArrayList<String>();
        List<ToolType> typeList = Arrays.asList(type);
        for (String toolTarget : toolChunkManager.getNames()) {
            if (!typeList.contains(toolChunkManager.getTag(toolTarget).getToolType())) continue;
            toolTargets.add(toolTarget);
        }
        toolTargetViewer.setInput(toolTargets);
        return toolTargetViewer;
    }
}

