/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ProblemManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.PropertiesManager;
import com.aicas.jamaica.eclipse.ant_editor.model.Tag;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefManager;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.NullOptions;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TaskdefTag
extends Tag
implements IModelPartChangedListener {
    private ToolType tool;
    private JamaicaVMDistribution distribution;
    private Set<ProblemManager.Problem> problemList = new LinkedHashSet<ProblemManager.Problem>();
    protected static int unboundTaskdefDialogSelection = -1;
    protected static boolean askUserOnUnboundTaskdef = true;
    private static final IToolOptions nullToolOptions = new NullOptions();

    public TaskdefTag(Node node, TaskdefManager manager) throws ModelException {
        super(node, null, manager);
        Element ele = (Element)node;
        String name = ele.getAttribute("name");
        if (name == null) {
            throw new ModelException(Messages.TaskdefTag_The___taskdef___tag_must_have_a___name___attribute);
        }
        this.distribution = null;
        String classname = ele.getAttribute("classname");
        String classpath = ele.getAttribute("classpath");
        if (classname == null || classpath == null) {
            throw new ModelException(Messages.TaskdefTag_Taskdef_tag_does_not_specify_the___classname___and___classpath___attributes);
        }
        this.setClassname(classname);
        this.getManager().addListener(this);
    }

    public void validateClasspath() {
        this.setClasspath(this.getClasspath());
    }

    public String getName() {
        return ((Element)this.getNode()).getAttribute("name");
    }

    public String getClassname() {
        return ((Element)this.getNode()).getAttribute("classname");
    }

    public void setClassname(String classname) {
        ((Element)this.getNode()).setAttribute("classname", classname);
        this.tool = ToolType.valueOfClassname((String)classname);
    }

    public String getClasspath() {
        return ((Element)this.getNode()).getAttribute("classpath");
    }

    public boolean isBound() {
        return this.distribution != null && this.distribution.getToolOptions(this.tool) != null;
    }

    public void setClasspath(String classpath) {
        if (classpath == null) {
            classpath = "";
        }
        ProjectFile project = this.getManager().getProjectFile();
        ProblemManager probMan = project.getProblemManager();
        if (!this.problemList.isEmpty()) {
            for (ProblemManager.Problem curProb : this.problemList) {
                probMan.problemSolved(curProb);
            }
            this.problemList.clear();
        }
        PropertiesManager propMan = project.getPropertiesManager();
        String taskdefDistroPath = null;
        JamaicaVMDistribution taskdefDistro = null;
        Set knownDistributions = JamaicaVMDistribution.distributions.keySet();
        if (!classpath.startsWith("${jamaica}")) {
            String resolvedClasspath;
            taskdefDistro = null;
            try {
                resolvedClasspath = propMan.resolveStringWithProperties(classpath);
            }
            catch (ModelException e) {
                resolvedClasspath = classpath;
            }
            int i = 1;
            while (i < 5 && taskdefDistro == null) {
                IPath path = new Path(resolvedClasspath).removeLastSegments(i);
                taskdefDistroPath = LauncherPlugin.normalize((String)path.toString());
                if (knownDistributions.contains(taskdefDistroPath)) {
                    taskdefDistro = JamaicaVMDistribution.findOrSetup((String)taskdefDistroPath);
                }
                ++i;
            }
            if (taskdefDistro == null) {
                if (askUserOnUnboundTaskdef) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialogWithToggle unboundTaskdefDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)AntEditorPlugin.getShell(), (String)Messages.TaskdefTag_jamaica_warning_conflict_found, (String)MessageFormat.format(Messages.TaskdefTag_classpath_does_not_seem_to_match_existing_distribution, TaskdefTag.this.getName()), (String)Messages.TaskdefTag_apply_to_all_unbound, (boolean)false, null, null);
                            int userSelection = unboundTaskdefDialog.getReturnCode();
                            boolean toggleState = unboundTaskdefDialog.getToggleState();
                            unboundTaskdefDialogSelection = userSelection;
                            askUserOnUnboundTaskdef = !toggleState;
                        }
                    });
                }
                if (unboundTaskdefDialogSelection == 2) {
                    classpath = "${jamaica}";
                } else {
                    this.problemList.add(probMan.reportProblem(Messages.TaskdefTag_Configured_Jamaica_tasks, MessageFormat.format(Messages.TaskdefTag_Cannot_find_matching_VM, this.getName()), 2, null));
                }
            }
        }
        if (classpath.startsWith("${jamaica}")) {
            if (project.hasJamaicaJRE()) {
                taskdefDistroPath = project.getProjectJRELocation();
                taskdefDistro = JamaicaVMDistribution.findOrSetup((String)taskdefDistroPath);
                String toolcp = taskdefDistro.getToolOptions(this.tool).getToolClasspath();
                classpath = toolcp.replace(taskdefDistroPath, "${jamaica}");
            } else {
                this.problemList.add(probMan.reportProblem(Messages.TaskdefTag_Configured_Jamaica_tasks, MessageFormat.format(Messages.TaskdefTag_ProjectJRE_is_no_Jamaica_VM, this.getName()), 2, null));
            }
        }
        boolean changed = this.distribution != null && this.distribution != taskdefDistro || !this.getClasspath().equals(classpath);
        this.distribution = taskdefDistro;
        if (changed) {
            ((Element)this.getNode()).setAttribute("classpath", classpath);
            this.getManager().fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TASKDEF, this.getName()));
        } else {
            this.getManager().fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.READ_COMPLETE, ModelPartChangedEvent.ModelPartType.TASKDEF, this.getName()));
        }
    }

    public IToolOptions getToolOptions() {
        if (this.isBound()) {
            return this.distribution.getToolOptions(this.tool);
        }
        return nullToolOptions;
    }

    public ToolType getToolType() {
        return this.tool;
    }

    public JamaicaVMDistribution getDistribution() {
        return this.distribution;
    }

    public void dispose() {
        if (!this.problemList.isEmpty()) {
            for (ProblemManager.Problem curProb : this.problemList) {
                this.getManager().getProjectFile().getProblemManager().problemSolved(curProb);
            }
            this.problemList.clear();
        }
        this.getManager().removeListener(this);
    }

    public void modelPartChanged(ModelPartChangedEvent event) {
        if (event.getPart() == ModelPartChangedEvent.ModelPartType.PROJECT && (event.getAction() == ModelPartChangedEvent.ActionType.READ_COMPLETE || event.getAction() == ModelPartChangedEvent.ActionType.CHANGED)) {
            this.validateClasspath();
        }
    }
}

