/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tag {
    private String name;
    private Node node;
    private ModelPartManager<?> manager;

    public Tag(Node node, String name, ModelPartManager<?> manager) throws ModelException {
        this.node = node;
        if (name == null || name.isEmpty()) {
            if (node instanceof Element) {
                this.name = ((Element)node).getAttribute("name");
            }
            if (this.name == null || this.name.isEmpty()) {
                this.name = node.getNodeName();
            }
        } else {
            this.name = name;
        }
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    protected Node getNode() {
        return this.node;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isChildOfTree() {
        Node n = this.node;
        while (n.getParentNode() != null) {
            n = n.getParentNode();
        }
        return n.isSameNode(this.getManager().getProjectFile().getDocument());
    }

    public ModelPartManager<?> getManager() {
        return this.manager;
    }

    public static String getWritableString(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public void dispose() {
    }
}

