/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors.se;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.AbstractSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class StringSettingEditor
extends AbstractSettingEditor {
    private Text inputField;
    private Button browseButton;
    private boolean isFile;
    private boolean isDirectory;
    private boolean absolutePaths;
    private boolean listenerActive = true;
    private Object listenerActiveLock = new Object();

    public StringSettingEditor(String optionName, ToolChunk chunk) {
        super(optionName, chunk);
    }

    protected void createInputArea(Composite parent, FormToolkit toolkit) {
        GridLayout gridLay = new GridLayout(2, false);
        gridLay.verticalSpacing = 0;
        gridLay.marginHeight = 0;
        gridLay.marginWidth = 10;
        parent.setLayout((Layout)gridLay);
        List args = this.model.getToolOptions().getOptionEditorArgs(this.associatedOption);
        this.isFile = args != null && args.contains("file");
        this.isDirectory = args != null && args.contains("directory");
        this.absolutePaths = args != null && args.contains("absolute_paths");
        this.inputField = toolkit.createText(parent, "", 2052);
        this.inputField.setBackground(this.textfieldColor);
        this.inputField.setFont(this.groupFont);
        this.inputField.addModifyListener(new ModifyListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modifyText(ModifyEvent me) {
                Object object = StringSettingEditor.this.listenerActiveLock;
                synchronized (object) {
                    if (StringSettingEditor.this.listenerActive) {
                        StringSettingEditor.this.setValue(StringSettingEditor.this.inputField.getText());
                    }
                }
            }
        });
        this.inputField.addKeyListener((KeyListener)new KeyAdapter(){
            private boolean flag = false;

            private void handleEnter() {
                StringSettingEditor.this.setValue(StringSettingEditor.this.inputField.getText());
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    this.flag = true;
                    this.handleEnter();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    if (!this.flag) {
                        this.handleEnter();
                    }
                    this.flag = false;
                }
            }
        });
        this.inputField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                StringSettingEditor.this.setValue(StringSettingEditor.this.inputField.getText());
            }
        });
        if (this.isFile || this.isDirectory) {
            GridData inputFieldData = new GridData(4, 4, true, false, 1, 1);
            this.inputField.setLayoutData((Object)inputFieldData);
            this.browseButton = new Button(parent, 0);
            this.browseButton.setText(Messages.StringSettingEditor_Browse______);
            this.browseButton.setBackground(this.buttonColor);
            this.browseButton.setFont(this.groupFont);
            GridData browseButtonData = new GridData(4, 4, false, false, 1, 1);
            this.browseButton.setLayoutData((Object)browseButtonData);
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    String chosenFileOrDirectoy = null;
                    if (StringSettingEditor.this.isFile) {
                        FileDialog fd = new FileDialog(AntEditorPlugin.getShell(), 8192);
                        fd.setFilterPath(StringSettingEditor.this.model.getManager().getProjectFile().getBasedirPath());
                        chosenFileOrDirectoy = fd.open();
                    } else if (StringSettingEditor.this.isDirectory) {
                        DirectoryDialog dd = new DirectoryDialog(AntEditorPlugin.getShell());
                        dd.setFilterPath(StringSettingEditor.this.model.getManager().getProjectFile().getBasedirPath());
                        chosenFileOrDirectoy = dd.open();
                    }
                    if (chosenFileOrDirectoy != null) {
                        StringSettingEditor.this.setValue(StringSettingEditor.this.absolutePaths ? LauncherPlugin.normalize(chosenFileOrDirectoy) : LauncherPlugin.normalize((String)chosenFileOrDirectoy, (String)StringSettingEditor.this.model.getManager().getProjectFile().getBasedirPath()));
                    }
                }
            });
            this.browseButton.setToolTipText(MessageFormat.format(Messages.StringSettingEditor_Opens_a_dialog_where_you_can_browse_to_select_a_1, this.isFile ? Messages.StringSettingEditor_file : Messages.StringSettingEditor_directory));
        } else {
            GridData inputFieldData = new GridData(4, 0x1000000, true, false, 2, 1);
            this.inputField.setLayoutData((Object)inputFieldData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUI() {
        super.updateUI();
        this.inputField.setEnabled(this.getState());
        if (this.browseButton != null) {
            this.browseButton.setEnabled(this.getState());
        }
        Object object = this.listenerActiveLock;
        synchronized (object) {
            this.listenerActive = false;
        }
        if (!this.getValue().equals(this.inputField.getText())) {
            this.inputField.setText(this.getValue());
        }
        object = this.listenerActiveLock;
        synchronized (object) {
            this.listenerActive = true;
        }
    }

    public void grabFocus() {
        super.grabFocus();
        this.inputField.setFocus();
        this.inputField.setSelection(0);
    }
}

