/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors.se;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.AbstractSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.ui.CheckboxLineWrapCellModifier;
import com.aicas.jamaica.eclipse.ant_editor.ui.CheckboxLineWrapContentProvider;
import com.aicas.jamaica.eclipse.ant_editor.ui.CheckboxLineWrapLabelProvider;
import com.aicas.jamaica.eclipse.ant_editor.ui.CheckboxLineWrapTableViewer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ListSelectionSettingEditor
extends AbstractSettingEditor {
    private StructuredViewer valueViewer;
    private List<String> selectableValues;
    private boolean isMulti;
    private String separators;

    public ListSelectionSettingEditor(String optionName, ToolChunk chunk) {
        super(optionName, chunk);
    }

    protected void createInputArea(Composite parent, FormToolkit toolkit) {
        GridLayout gridLay = new GridLayout(1, false);
        gridLay.verticalSpacing = 0;
        gridLay.marginHeight = 0;
        gridLay.marginWidth = 10;
        parent.setLayout((Layout)gridLay);
        GridData tableLayout = new GridData(4, 0x1000000, true, false, 1, 1);
        List args = this.model.getToolOptions().getOptionEditorArgs(this.associatedOption);
        this.isMulti = args.contains("multi");
        this.separators = this.model.getToolOptions().getSeparators(this.associatedOption);
        List list = this.selectableValues = this.isMulti ? args.subList(1, args.size()) : args;
        if (this.isMulti) {
            int numCols = 3;
            Table table = new Table(parent, 68352);
            table.setLinesVisible(true);
            table.setHeaderVisible(false);
            this.valueViewer = new CheckboxLineWrapTableViewer(table, this.selectableValues);
            this.valueViewer.getControl().setBackground(this.groupColor);
            tableLayout.heightHint = 60;
            final CheckboxLineWrapTableViewer tableViewer = (CheckboxLineWrapTableViewer)this.valueViewer;
            tableViewer.setCellModifier(new CheckboxLineWrapCellModifier(tableViewer));
            CheckboxLineWrapContentProvider cProv = new CheckboxLineWrapContentProvider(numCols);
            tableViewer.setContentProvider((IContentProvider)cProv);
            ArrayList<CheckboxCellEditor> cellEdits = new ArrayList<CheckboxCellEditor>();
            ArrayList<String> colProps = new ArrayList<String>();
            int i = 0;
            while (i < numCols) {
                TableViewerColumn colView = new TableViewerColumn((TableViewer)tableViewer, 0);
                cellEdits.add(new CheckboxCellEditor((Composite)table, 0));
                colProps.add(String.valueOf(i));
                colView.getColumn().setResizable(true);
                colView.getColumn().setWidth(150);
                colView.setLabelProvider((CellLabelProvider)new CheckboxLineWrapLabelProvider(i, tableViewer));
                ++i;
            }
            tableViewer.setColumnProperties(colProps.toArray(new String[0]));
            tableViewer.setCellEditors(cellEdits.toArray(new CellEditor[0]));
            tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    List<String> checkedItems = tableViewer.getCheckedElements();
                    if (checkedItems.isEmpty()) {
                        ListSelectionSettingEditor.this.setValue("none");
                    } else {
                        ListSelectionSettingEditor.this.setValue(AntEditorPlugin.join(checkedItems.toArray(), ListSelectionSettingEditor.this.separators));
                    }
                }
            });
        } else {
            this.valueViewer = new ComboViewer(parent, 12);
            this.valueViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.valueViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.valueViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    String newValue = (String)((IStructuredSelection)ListSelectionSettingEditor.this.valueViewer.getSelection()).getFirstElement();
                    if (newValue == null) {
                        newValue = ((ComboViewer)ListSelectionSettingEditor.this.valueViewer).getCombo().getText();
                    }
                    ListSelectionSettingEditor.this.setValue(newValue);
                    ((ComboViewer)ListSelectionSettingEditor.this.valueViewer).getCombo().getParent().forceFocus();
                }
            });
        }
        this.valueViewer.setInput(this.selectableValues);
        this.valueViewer.getControl().setLayoutData((Object)tableLayout);
        this.valueViewer.getControl().setFont(this.groupFont);
    }

    public void updateUI() {
        super.updateUI();
        List args = this.model.getToolOptions().getOptionEditorArgs(this.associatedOption);
        this.separators = this.model.getToolOptions().getSeparators(this.associatedOption);
        if (args != null) {
            this.isMulti = args.contains("multi");
            this.selectableValues = this.isMulti ? args.subList(1, args.size()) : args;
        } else {
            this.selectableValues = Collections.EMPTY_LIST;
        }
        this.valueViewer.setInput(this.selectableValues);
        this.valueViewer.getControl().setEnabled(this.getState());
        String optionValue = this.getValueResolved();
        if (this.isMulti) {
            CheckboxLineWrapTableViewer ctv = (CheckboxLineWrapTableViewer)this.valueViewer;
            if (optionValue.equals("all")) {
                ctv.setCheckedElements(this.selectableValues);
            } else if (optionValue.equals("none")) {
                ctv.setCheckedElements(Collections.EMPTY_LIST);
            } else {
                String[] tokens;
                LinkedHashSet<String> newInput = new LinkedHashSet<String>(this.selectableValues);
                LinkedHashSet<String> newCheckedElements = new LinkedHashSet<String>();
                String[] stringArray = tokens = optionValue.split(" ");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    if (newInput.contains(token)) {
                        newCheckedElements.add(token);
                    }
                    ++n2;
                }
                ctv.setInput(newInput);
                ctv.setCheckedElements(newCheckedElements);
            }
        } else {
            ComboViewer cv = (ComboViewer)this.valueViewer;
            if (this.selectableValues.contains(optionValue)) {
                cv.setSelection((ISelection)new StructuredSelection((Object)optionValue));
            }
        }
    }

    public void grabFocus() {
        super.grabFocus();
        this.valueViewer.getControl().setFocus();
    }
}

