/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors.se;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.InfoPopUp;
import com.aicas.jamaica.eclipse.ant_editor.editors.JamaicaAntEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.AgentlibSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.BooleanSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.ListSelectionSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.Messages;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.StringListSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.StringSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.model.PropertiesManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.ui.ViewerFactory;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractSettingEditor {
    private Composite parentComposite;
    private Group frame;
    private ToolBar toolbarLeft;
    private ToolBar toolbarRight;
    private ToolBar toolbarClose;
    private ToolItem enabledButton;
    private ToolItem appendButton;
    private ToolItem loadDefaultButton;
    private ToolItem showPropertiesButton;
    private ToolItem showDescriptionButton;
    private ToolItem removeButton;
    private ToolItem invalidButton;
    private Composite subclassControls;
    private FormToolkit theToolkit;
    private boolean controlsCreated;
    protected String associatedOption;
    protected ToolChunk model;
    protected PropertiesManager propertiesManager;
    public static final int CONTROL_WIDTH = 300;
    public static final int LIST_HEIGHT = 80;
    public static final int OFFSET_SMALL = 0;
    public static final int OFFSET_NORMAL = 1;
    public static final int OFFSET_BIG = 2;
    protected Color groupColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_GROUP);
    protected Color buttonColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_BUTTON);
    protected Color textfieldColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_TEXTFIELD);
    protected Font groupFont = JamaicaAntEditor.getResourceManager().createFont(JamaicaAntEditor.FONT_GROUP);
    private static String ISharedImages_IMG_TOOL_DELETE;
    private static String ISharedImages_IMG_LCL_LINKTO_HELP;
    private static String ISharedImages_IMG_ELCL_STOP;
    private static String ISharedImages_IMG_TOOL_FORWARD;
    private static String ISharedImages_IMG_OBJS_ERROR_TSK;

    protected AbstractSettingEditor(String optionName, ToolChunk chunk) {
        try {
            ISharedImages_IMG_TOOL_DELETE = (String)ISharedImages.class.getField("IMG_TOOL_DELETE").get(null);
            ISharedImages_IMG_LCL_LINKTO_HELP = (String)ISharedImages.class.getField("IMG_LCL_LINKTO_HELP").get(null);
            ISharedImages_IMG_ELCL_STOP = (String)ISharedImages.class.getField("IMG_ELCL_STOP").get(null);
            ISharedImages_IMG_TOOL_FORWARD = (String)ISharedImages.class.getField("IMG_TOOL_FORWARD").get(null);
            ISharedImages_IMG_OBJS_ERROR_TSK = (String)ISharedImages.class.getField("IMG_OBJS_ERROR_TSK").get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.associatedOption = optionName;
        this.model = chunk;
        this.propertiesManager = this.model.getManager().getProjectFile().getPropertiesManager();
    }

    public void createControls(Composite parent, FormToolkit toolkit) {
        this.parentComposite = parent;
        this.theToolkit = toolkit;
        this.frame = new Group(this.parentComposite, 0);
        this.frame.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout optionFrameGridLayout = new GridLayout(5, false);
        optionFrameGridLayout.verticalSpacing = 0;
        optionFrameGridLayout.marginHeight = 0;
        optionFrameGridLayout.marginWidth = 0;
        this.frame.setLayout((Layout)optionFrameGridLayout);
        this.theToolkit.adapt((Composite)this.frame);
        this.frame.setBackground(this.groupColor);
        this.toolbarLeft = new ToolBar((Composite)this.frame, 0x820000);
        toolkit.adapt((Composite)this.toolbarLeft);
        this.toolbarLeft.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.toolbarLeft.setBackground(this.groupColor);
        CLabel optionName = new CLabel((Composite)this.frame, 0);
        optionName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        optionName.setText(this.associatedOption);
        optionName.setFont(this.groupFont);
        optionName.setBackground(this.groupColor);
        this.subclassControls = this.theToolkit.createComposite((Composite)this.frame);
        this.subclassControls.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.subclassControls.setBackground(this.groupColor);
        this.createInputArea(this.subclassControls, this.theToolkit);
        this.toolbarRight = new ToolBar((Composite)this.frame, 0x820000);
        toolkit.adapt((Composite)this.toolbarRight);
        this.toolbarRight.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.toolbarRight.setBackground(this.groupColor);
        this.toolbarRight.setFont(this.groupFont);
        this.toolbarClose = new ToolBar((Composite)this.frame, 0x820000);
        toolkit.adapt((Composite)this.toolbarClose);
        this.toolbarClose.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.toolbarClose.setBackground(this.groupColor);
        this.enabledButton = new ToolItem(this.toolbarLeft, 8);
        boolean selected = this.getState();
        this.setEnabledButton(selected);
        this.enabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                boolean selected = !AbstractSettingEditor.this.getState();
                AbstractSettingEditor.this.setState(selected);
                AbstractSettingEditor.this.setEnabledButton(selected);
            }
        });
        this.enabledButton.setToolTipText(Messages.AbstractSettingEditor_use_button_tooltip);
        if (this.model.getToolOptions().getDefaultValue(this.associatedOption, this.model.getTargetValue()) != null) {
            if (this.model.getToolOptions().isAppendable(this.associatedOption) && this.model.getDistribution() != null && this.model.getDistribution().getVersionMajor() >= 6) {
                this.appendButton = new ToolItem(this.toolbarRight, 32);
                this.appendButton.setText("+=");
                this.appendButton.setToolTipText(Messages.AbstractSettingEditor_append_button_tooltip);
                this.appendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractSettingEditor.this.setAppendSyntax(AbstractSettingEditor.this.appendButton.getSelection());
                    }
                });
            }
            this.loadDefaultButton = new ToolItem(this.toolbarRight, 8);
            this.loadDefaultButton.setText("default");
            this.loadDefaultButton.setToolTipText(Messages.AbstractSettingEditor_default_button_tooltip);
            this.loadDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    AbstractSettingEditor.this.setValue(AbstractSettingEditor.this.model.getToolOptions().getDefaultValue(AbstractSettingEditor.this.associatedOption, AbstractSettingEditor.this.model.getTargetValue()));
                }
            });
        }
        this.showPropertiesButton = new ToolItem(this.toolbarRight, 8);
        this.showPropertiesButton.setText("${..}");
        this.showPropertiesButton.setEnabled(PropertiesManager.extractProperties(this.getValue()).size() > 0);
        this.showPropertiesButton.setToolTipText(Messages.AbstractSettingEditor_properties_button_tooltip);
        this.showPropertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSettingEditor.this.showPropertyEditor();
            }
        });
        this.showDescriptionButton = new ToolItem(this.toolbarRight, 8);
        if (ISharedImages_IMG_LCL_LINKTO_HELP != null) {
            this.showDescriptionButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages_IMG_LCL_LINKTO_HELP));
        } else {
            this.showDescriptionButton.setText("?");
        }
        this.showDescriptionButton.setToolTipText(Messages.AbstractSettingEditor_help_button_tooltip);
        this.showDescriptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractSettingEditor.this.model.isBound()) {
                    AbstractSettingEditor.this.showOptionHelp(AbstractSettingEditor.this.model.getToolOptions().getDescription(AbstractSettingEditor.this.associatedOption, AbstractSettingEditor.this.model.getTargetValue()));
                }
            }
        });
        this.removeButton = new ToolItem(this.toolbarClose, 8);
        if (ISharedImages_IMG_TOOL_DELETE != null) {
            this.removeButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages_IMG_TOOL_DELETE));
        } else {
            this.removeButton.setText("X");
        }
        this.removeButton.setToolTipText(Messages.AbstractSettingEditor_remove_button_tooltip);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)AntEditorPlugin.getShell(), (String)Messages.AbstractSettingEditor_Remove_option, (String)MessageFormat.format(Messages.AbstractSettingEditor_Do_you_want_to_remove_the_option___1____, AbstractSettingEditor.this.associatedOption))) {
                    try {
                        AbstractSettingEditor.this.model.removeOption(AbstractSettingEditor.this.associatedOption);
                    }
                    catch (Exception ex) {
                        AntEditorPlugin.log(ex);
                    }
                }
            }
        });
        this.toolbarLeft.pack();
        this.subclassControls.pack();
        this.toolbarRight.pack();
        this.toolbarClose.pack();
        this.controlsCreated = true;
        this.updateUI();
    }

    protected void setEnabledButton(boolean selected) {
        if (selected) {
            if (ISharedImages_IMG_TOOL_FORWARD != null) {
                this.enabledButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages_IMG_TOOL_FORWARD));
            } else {
                this.enabledButton.setText("On");
            }
        } else if (ISharedImages_IMG_ELCL_STOP != null) {
            this.enabledButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages_IMG_ELCL_STOP));
        } else {
            this.enabledButton.setText("Off");
        }
    }

    protected abstract void createInputArea(Composite var1, FormToolkit var2);

    protected void showPropertyEditor() {
        InfoPopUp pop = new InfoPopUp(this.frame.getShell(), " " + this.associatedOption + " properties", "Jamaica Builder");
        List<String> properties = PropertiesManager.extractProperties(this.getValue());
        Composite compo = this.theToolkit.createComposite((Composite)this.frame.getShell());
        compo.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        compo.setLayout((Layout)new GridLayout(1, false));
        final TableViewer propertiesViewer = ViewerFactory.getPropertiesViewer(compo, this.propertiesManager);
        propertiesViewer.getCellEditors()[1].addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                propertiesViewer.setInput(PropertiesManager.extractProperties(AbstractSettingEditor.this.getValue()));
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        });
        propertiesViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        if (properties.size() > 0) {
            propertiesViewer.setInput(properties);
            TableColumn[] tableColumnArray = propertiesViewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                col.pack();
                ++n2;
            }
        }
        pop.setContent((Control)compo);
        pop.open();
    }

    protected void showOptionHelp(String message) {
        InfoPopUp pop = new InfoPopUp(this.frame.getShell(), " " + this.associatedOption + " help", "Jamaica Builder");
        StyledText text = new StyledText((Composite)this.frame.getShell(), 586);
        text.setText(message);
        pop.setContent((Control)text);
        pop.open();
    }

    protected void setState(boolean newState) {
        this.model.setOption(this.associatedOption, this.model.getOptionValue(this.associatedOption), newState);
    }

    protected void setValue(String newValue) {
        this.model.setOption(this.associatedOption, newValue);
    }

    protected void setAppendSyntax(boolean newAppendSyntax) {
        this.model.setAppendSyntax(this.associatedOption, newAppendSyntax);
    }

    protected String getValue() {
        return this.model.getOptionValue(this.associatedOption);
    }

    protected String getValueResolved() {
        return this.model.getOptionValueResolved(this.associatedOption);
    }

    protected boolean getState() {
        return this.model.getOptionState(this.associatedOption);
    }

    protected boolean hasAppendSyntax() {
        return this.model.hasAppendSyntax(this.associatedOption);
    }

    protected boolean isValid() {
        return this.model.isValidOption(this.associatedOption);
    }

    protected String getLastError() {
        return this.model.getOptionLastError(this.associatedOption);
    }

    public void dispose() {
        if (!this.controlsCreated) {
            throw new IllegalStateException(Messages.AbstractSettingEditor_Controls_have_not_been_created_yet);
        }
        this.frame.dispose();
    }

    public void updateUI() {
        if (!this.controlsCreated) {
            throw new IllegalStateException(Messages.AbstractSettingEditor_Controls_have_not_been_created_yet);
        }
        boolean state = this.getState();
        this.enabledButton.setSelection(state);
        this.showPropertiesButton.setEnabled(PropertiesManager.extractProperties(this.getValue()).size() > 0);
        this.toolbarRight.setEnabled(state);
        if (!this.isValid()) {
            if (this.invalidButton == null) {
                this.invalidButton = new ToolItem(this.toolbarLeft, 8);
                this.invalidButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages_IMG_OBJS_ERROR_TSK));
            }
            if (this.getLastError() != null) {
                this.invalidButton.setToolTipText(this.getLastError());
            }
        } else if (this.invalidButton != null) {
            this.invalidButton.dispose();
            this.invalidButton = null;
        }
        boolean appendSyntax = this.hasAppendSyntax();
        if (this.appendButton != null) {
            this.appendButton.setSelection(appendSyntax);
        }
        this.frame.layout(true, true);
    }

    public void grabFocus() {
        if (!this.controlsCreated) {
            throw new IllegalStateException(Messages.AbstractSettingEditor_Controls_have_not_been_created_yet);
        }
        this.frame.setFocus();
        FormToolkit.ensureVisible((Control)this.frame);
    }

    public static AbstractSettingEditor newSettingEditor(String optionName, ToolChunk chunk, Composite parent, FormToolkit toolkit) {
        AbstractSettingEditor ase = null;
        try {
            IToolOptions.EditorType editorType = chunk.getToolOptions().getOptionEditorType(optionName);
            if (editorType == null) {
                editorType = IToolOptions.EditorType.STRING;
            }
            switch (editorType) {
                case AGENTLIB: {
                    ase = new AgentlibSettingEditor(optionName, chunk);
                    break;
                }
                case BOOLEAN: {
                    ase = new BooleanSettingEditor(optionName, chunk);
                    break;
                }
                case LIST_SELECTION: {
                    ase = new ListSelectionSettingEditor(optionName, chunk);
                    break;
                }
                case STRING_LIST: {
                    ase = new StringListSettingEditor(optionName, chunk);
                    break;
                }
                case STRING: {
                    ase = new StringSettingEditor(optionName, chunk);
                    break;
                }
                default: {
                    ase = new StringSettingEditor(optionName, chunk);
                    break;
                }
            }
        }
        catch (Exception e) {
            AntEditorPlugin.log(e);
        }
        ase.createControls(parent, toolkit);
        return ase;
    }
}

