/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import com.aicas.jamaica.eclipse.ant_editor.dialogs.AddBuilderTargetDialog;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.AddExecTargetDialog;
import com.aicas.jamaica.eclipse.ant_editor.editors.JamaicaAntEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.Messages;
import com.aicas.jamaica.eclipse.ant_editor.editors.OverviewBuildTargetGroup;
import com.aicas.jamaica.eclipse.ant_editor.editors.OverviewLaunchTargetGroup;
import com.aicas.jamaica.eclipse.ant_editor.editors.OverviewTargetGroup;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.ui.ViewerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.debug.ui.launcher.NameValuePairDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class OverviewPageBody
extends Composite {
    private ProjectFile projectData;
    private JamaicaAntEditor editor;
    private TableViewer propTable;
    private StyledText projectNameText;
    private StyledText defTargetText;
    private StyledText basedirText;
    private Map<String, OverviewTargetGroup> targets;
    private Composite targetContainer;
    private ScrolledComposite scrolledComposite;
    private Color formColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_FORM);
    private Color groupColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_GROUP);
    private Color buttonColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_BUTTON);
    private Color textfieldColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_TEXTFIELD);

    public OverviewPageBody(Composite parent, int style, ProjectFile project, JamaicaAntEditor editor, FormToolkit toolkit) {
        super(parent, 0);
        this.projectData = project;
        this.editor = editor;
        GridData gdata = GridDataFactory.fillDefaults().grab(true, true).hint(parent.getClientArea().width, parent.getClientArea().height).create();
        this.setLayoutData(gdata);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 15;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 15;
        this.setLayout((Layout)gridLayout);
        this.setBackground(this.formColor);
        Section projectSection = toolkit.createSection((Composite)this, 256);
        projectSection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        toolkit.paintBordersFor((Composite)projectSection);
        projectSection.setText("Project");
        projectSection.setBackground(this.formColor);
        Composite projectComposite = new Composite((Composite)projectSection, 0);
        toolkit.adapt(projectComposite);
        toolkit.paintBordersFor(projectComposite);
        projectComposite.setBackground(this.groupColor);
        projectSection.setClient((Control)projectComposite);
        FillLayout fl_projectComposite = new FillLayout(256);
        fl_projectComposite.spacing = 10;
        fl_projectComposite.marginWidth = 10;
        projectComposite.setLayout((Layout)fl_projectComposite);
        Group nameGroup = new Group(projectComposite, 0);
        nameGroup.setText("Name");
        toolkit.adapt((Composite)nameGroup);
        toolkit.paintBordersFor((Composite)nameGroup);
        nameGroup.setBackground(this.groupColor);
        GridLayout gl_nameGroup = new GridLayout(1, false);
        gl_nameGroup.marginHeight = 0;
        gl_nameGroup.marginBottom = 4;
        gl_nameGroup.marginTop = 6;
        gl_nameGroup.marginRight = 10;
        gl_nameGroup.marginLeft = 10;
        gl_nameGroup.marginWidth = 0;
        gl_nameGroup.verticalSpacing = 0;
        nameGroup.setLayout((Layout)gl_nameGroup);
        this.projectNameText = new StyledText((Composite)nameGroup, 2060);
        toolkit.adapt((Composite)this.projectNameText);
        toolkit.paintBordersFor((Composite)this.projectNameText);
        this.projectNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.projectNameText.setBackground(this.textfieldColor);
        this.projectNameText.setEditable(false);
        this.projectNameText.setEnabled(false);
        Group defTargetGroup = new Group(projectComposite, 0);
        defTargetGroup.setText("Default target");
        toolkit.adapt((Composite)defTargetGroup);
        toolkit.paintBordersFor((Composite)defTargetGroup);
        defTargetGroup.setBackground(this.groupColor);
        GridLayout gl_defTargetGroup = new GridLayout(2, false);
        gl_defTargetGroup.marginBottom = 4;
        gl_defTargetGroup.marginTop = 6;
        gl_defTargetGroup.marginRight = 5;
        gl_defTargetGroup.marginLeft = 10;
        gl_defTargetGroup.marginWidth = 0;
        gl_defTargetGroup.marginHeight = 0;
        gl_defTargetGroup.verticalSpacing = 0;
        defTargetGroup.setLayout((Layout)gl_defTargetGroup);
        this.defTargetText = new StyledText((Composite)defTargetGroup, 2060);
        toolkit.adapt((Composite)this.defTargetText);
        toolkit.paintBordersFor((Composite)this.defTargetText);
        this.defTargetText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.defTargetText.setBackground(this.textfieldColor);
        this.defTargetText.setEditable(false);
        this.defTargetText.setEnabled(false);
        Button defTargetButton = new Button((Composite)defTargetGroup, 0);
        GridData gd_defTargetButton = new GridData(16384, 128, false, false, 1, 1);
        gd_defTargetButton.widthHint = 35;
        defTargetButton.setLayoutData((Object)gd_defTargetButton);
        toolkit.adapt((Control)defTargetButton, true, true);
        defTargetButton.setText("...");
        defTargetButton.setBackground(this.buttonColor);
        defTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Object[] result;
                ElementListSelectionDialog elsd = new ElementListSelectionDialog(OverviewPageBody.this.getShell(), (ILabelProvider)new LabelProvider());
                elsd.setTitle(Messages.OverviewPage_Change_default_target);
                elsd.setMessage(Messages.OverviewPage_Select_new_default_target);
                ArrayList<String> allChunks = new ArrayList<String>();
                allChunks.addAll(OverviewPageBody.this.projectData.getToolChunkManager().getNames());
                allChunks.addAll(OverviewPageBody.this.projectData.getExecChunkManager().getNames());
                allChunks.addAll(OverviewPageBody.this.projectData.getPlainTargetChunkManager().getNames());
                elsd.setElements(allChunks.toArray());
                if (elsd.open() == 0 && (result = elsd.getResult()).length > 0) {
                    OverviewPageBody.this.projectData.setDefaultTarget((String)result[0]);
                }
            }
        });
        Group basedirGroup = new Group(projectComposite, 0);
        basedirGroup.setText("Basedir");
        toolkit.adapt((Composite)basedirGroup);
        toolkit.paintBordersFor((Composite)basedirGroup);
        basedirGroup.setBackground(this.groupColor);
        GridLayout gl_basedirGroup = new GridLayout(2, false);
        gl_basedirGroup.verticalSpacing = 0;
        gl_basedirGroup.marginWidth = 0;
        gl_basedirGroup.marginTop = 6;
        gl_basedirGroup.marginRight = 5;
        gl_basedirGroup.marginLeft = 10;
        gl_basedirGroup.marginHeight = 0;
        gl_basedirGroup.marginBottom = 4;
        basedirGroup.setLayout((Layout)gl_basedirGroup);
        this.basedirText = new StyledText((Composite)basedirGroup, 2060);
        toolkit.adapt((Composite)this.basedirText);
        toolkit.paintBordersFor((Composite)this.basedirText);
        this.basedirText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.basedirText.setBackground(this.textfieldColor);
        this.basedirText.setEditable(false);
        this.basedirText.setEnabled(false);
        Button basedirButton = new Button((Composite)basedirGroup, 0);
        GridData gd_basedirButton = new GridData(16384, 128, false, false, 1, 1);
        gd_basedirButton.widthHint = 35;
        basedirButton.setLayoutData((Object)gd_basedirButton);
        toolkit.adapt((Control)basedirButton, true, true);
        basedirButton.setText("...");
        basedirButton.setBackground(this.buttonColor);
        basedirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                InputDialog id = new InputDialog(OverviewPageBody.this.getShell(), Messages.OverviewPage_Change_base_directory, Messages.OverviewPage_Specify_new_base_directory, OverviewPageBody.this.projectData.getBasedir(), null);
                if (id.open() == 0) {
                    OverviewPageBody.this.projectData.setBasedir(id.getValue());
                }
            }
        });
        Composite bodyComposite = new Composite((Composite)this, 0);
        FormLayout fl_bodyComposite = new FormLayout();
        fl_bodyComposite.spacing = 10;
        bodyComposite.setLayout((Layout)fl_bodyComposite);
        bodyComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        toolkit.adapt(bodyComposite);
        bodyComposite.setBackground(this.formColor);
        toolkit.paintBordersFor(bodyComposite);
        Section targetSection = toolkit.createSection(bodyComposite, 256);
        targetSection.setBackground(this.formColor);
        FormData fd_targetSection = new FormData();
        fd_targetSection.right = new FormAttachment(66);
        fd_targetSection.top = new FormAttachment(0);
        fd_targetSection.left = new FormAttachment(0);
        fd_targetSection.bottom = new FormAttachment(100);
        targetSection.setLayoutData((Object)fd_targetSection);
        toolkit.paintBordersFor((Composite)targetSection);
        targetSection.setText("Targets");
        Composite targetComposite = toolkit.createComposite((Composite)targetSection, 0);
        targetComposite.setBackground(this.groupColor);
        toolkit.paintBordersFor(targetComposite);
        targetSection.setClient((Control)targetComposite);
        GridLayout gl_targetComposite = new GridLayout(2, true);
        gl_targetComposite.marginHeight = 0;
        gl_targetComposite.marginTop = 2;
        gl_targetComposite.marginWidth = 0;
        gl_targetComposite.verticalSpacing = 12;
        targetComposite.setLayout((Layout)gl_targetComposite);
        Button newBuildButton = new Button(targetComposite, 0);
        newBuildButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        toolkit.adapt((Control)newBuildButton, true, true);
        newBuildButton.setText("New Build Target");
        newBuildButton.setBackground(this.buttonColor);
        newBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                new AddBuilderTargetDialog(OverviewPageBody.this.getShell(), OverviewPageBody.this.projectData).open();
            }
        });
        Button newLaunchButton = new Button(targetComposite, 0);
        newLaunchButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        toolkit.adapt((Control)newLaunchButton, true, true);
        newLaunchButton.setText("New Launch Target");
        newLaunchButton.setBackground(this.buttonColor);
        newLaunchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                new AddExecTargetDialog(OverviewPageBody.this.getShell(), OverviewPageBody.this.projectData).open();
            }
        });
        this.scrolledComposite = new ScrolledComposite(targetComposite, 768);
        toolkit.adapt((Composite)this.scrolledComposite);
        this.scrolledComposite.setBackground(this.groupColor);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                OverviewPageBody.this.setTargetScrollerMinSize();
            }
        });
        this.targetContainer = new Composite((Composite)this.scrolledComposite, 0);
        toolkit.adapt(this.targetContainer);
        this.targetContainer.setBackground(this.groupColor);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.verticalSpacing = 10;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.horizontalSpacing = 0;
        this.targetContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.targetContainer.setLayout((Layout)gl_composite);
        this.scrolledComposite.setContent((Control)this.targetContainer);
        this.setTargetScrollerMinSize();
        Section propSection = toolkit.createSection(bodyComposite, 256);
        propSection.setBackground(this.formColor);
        FormData fd_propSection = new FormData();
        fd_propSection.bottom = new FormAttachment(100);
        fd_propSection.left = new FormAttachment((Control)targetSection);
        fd_propSection.top = new FormAttachment(0);
        fd_propSection.right = new FormAttachment(100);
        propSection.setLayoutData((Object)fd_propSection);
        toolkit.paintBordersFor((Composite)propSection);
        propSection.setText("Properties");
        Composite propComposite = toolkit.createComposite((Composite)propSection, 0);
        propComposite.setBackground(this.groupColor);
        toolkit.paintBordersFor(propComposite);
        propSection.setClient((Control)propComposite);
        GridLayout propCompoLayout = new GridLayout(2, true);
        propCompoLayout.marginWidth = 0;
        propCompoLayout.marginHeight = 0;
        propCompoLayout.marginTop = 5;
        propCompoLayout.verticalSpacing = 12;
        propComposite.setLayout((Layout)propCompoLayout);
        Button propAddButton = new Button(propComposite, 0);
        propAddButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        toolkit.adapt((Control)propAddButton, true, true);
        propAddButton.setText("+");
        propAddButton.setBackground(this.buttonColor);
        propAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                NameValuePairDialog id = new NameValuePairDialog(OverviewPageBody.this.getShell(), Messages.OverviewPage_New_property_dialog_title, new String[]{Messages.OverviewPage_New_property_dialog_name_label, Messages.OverviewPage_New_property_dialog_value_label}, new String[]{"", ""});
                if (id.open() == 0) {
                    String propName = id.getNameValuePair()[0];
                    String propValue = id.getNameValuePair()[1];
                    OverviewPageBody.this.projectData.getPropertiesManager().setPropertyValue(propName, propValue);
                }
            }
        });
        Button propRemoveButton = new Button(propComposite, 0);
        propRemoveButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        toolkit.adapt((Control)propRemoveButton, true, true);
        propRemoveButton.setText("--");
        propRemoveButton.setBackground(this.buttonColor);
        propRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                IStructuredSelection iss = (IStructuredSelection)OverviewPageBody.this.propTable.getSelection();
                for (Object propName : iss.toList()) {
                    OverviewPageBody.this.projectData.getPropertiesManager().removeProperty((String)propName);
                }
            }
        });
        this.propTable = ViewerFactory.getPropertiesViewer(propComposite, this.projectData.getPropertiesManager());
        toolkit.adapt((Composite)this.propTable.getTable());
        toolkit.paintBordersFor((Composite)this.propTable.getTable());
        GridData propTableLayoutData = new GridData(4, 4, true, true, 2, 1);
        this.propTable.getTable().setLayoutData((Object)propTableLayoutData);
        this.propTable.getTable().setBackground(this.groupColor);
        this.targets = new LinkedHashMap<String, OverviewTargetGroup>();
    }

    public void layout() {
        super.layout();
        this.scrolledComposite.layout(true, true);
    }

    protected void checkSubclass() {
    }

    protected void updateUI() {
        this.projectNameText.setText(this.projectData.getName() == null ? Messages.OverviewPage___not_set__ : this.projectData.getName());
        this.defTargetText.setText(this.projectData.getDefaultTarget() == null ? Messages.OverviewPage___not_specified__ : this.projectData.getDefaultTarget());
        this.basedirText.setText(this.projectData.getBasedir() == null ? Messages.OverviewPage___not_specified__ : this.projectData.getBasedir());
        for (OverviewTargetGroup curTargetGroup : this.targets.values()) {
            curTargetGroup.setVisible(false);
            curTargetGroup.dispose();
        }
        this.targets.clear();
        for (String curBuildTarget : this.projectData.getToolChunkManager().getNames()) {
            if (this.targets.containsKey(curBuildTarget)) {
                this.targets.get(curBuildTarget).updateUI();
                continue;
            }
            this.targets.put(curBuildTarget, new OverviewBuildTargetGroup(this.targetContainer, 0, this.projectData.getToolChunkManager().getTag(curBuildTarget), this.editor));
        }
        for (String curLaunchTarget : this.projectData.getExecChunkManager().getNames()) {
            if (this.targets.containsKey(curLaunchTarget)) {
                this.targets.get(curLaunchTarget).updateUI();
                continue;
            }
            this.targets.put(curLaunchTarget, new OverviewLaunchTargetGroup(this.targetContainer, 0, this.projectData.getExecChunkManager().getTag(curLaunchTarget), this.editor));
        }
        this.setTargetScrollerMinSize();
        this.layout();
        List<String> properties = this.projectData.getPropertiesManager().getNames();
        if (properties != null) {
            this.propTable.setInput(properties);
        }
        TableColumn[] tableColumnArray = this.propTable.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            ++n2;
        }
    }

    private void setTargetScrollerMinSize() {
        Point targetContainerSize = this.targetContainer.computeSize(-1, -1);
        this.targetContainer.setSize(targetContainerSize);
        this.scrolledComposite.setMinSize(targetContainerSize);
    }
}

