/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.editors.JamaicaAntEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.Messages;
import com.aicas.jamaica.eclipse.ant_editor.editors.OverviewTargetGroup;
import com.aicas.jamaica.eclipse.ant_editor.model.ExecChunk;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class OverviewLaunchTargetGroup
extends OverviewTargetGroup {
    public OverviewLaunchTargetGroup(Composite parent, int style, ExecChunk exeChunk, JamaicaAntEditor jae) {
        super(parent, style, exeChunk, jae);
        this.idLabel.setImage(JamaicaAntEditor.getResourceManager().createImage(JamaicaAntEditor.ICON_OVERVIEW_PAGE_LAUNCH_TARGET));
        this.cloneButton.setVisible(false);
        this.auxLabel.setText("Arguments:");
        this.auxButton.setText("...");
        this.auxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String antTargetName = OverviewLaunchTargetGroup.this.antTarget.getName();
                ExecChunk ec = OverviewLaunchTargetGroup.this.projData.getExecChunkManager().getTag(antTargetName);
                List<String> curArgs = ec.getArgs();
                String curArgsString = curArgs == null ? "" : AntEditorPlugin.join(curArgs.toArray(), " ");
                InputDialog id = new InputDialog(OverviewLaunchTargetGroup.this.getShell(), Messages.OverviewPage_Change_arguments, Messages.OverviewPage_Specify_runtime_arguments, curArgsString, null);
                if (id.open() == 0) {
                    String[] tokens;
                    String newArgsString = id.getValue();
                    ArrayList<String> newArgs = new ArrayList<String>();
                    String[] stringArray = tokens = newArgsString.split(" ");
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String token = stringArray[n2];
                        if (token != null && !token.isEmpty()) {
                            newArgs.add(token);
                        }
                        ++n2;
                    }
                    ec.setArgs(newArgs);
                }
            }
        });
        this.invokeButton.setText("Launch");
        this.updateUI();
    }

    public void updateUI() {
        ExecChunk launchTarget = (ExecChunk)this.antTarget;
        this.setText(launchTarget.getName());
        this.appNameText.setText(launchTarget.getExecutable() != null ? launchTarget.getExecutable() : "<undefined>");
        this.auxText.setText(AntEditorPlugin.join(launchTarget.getArgs().toArray(), " "));
    }
}

