/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.vm;

import com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMRunner;
import com.aicas.jamaica.eclipse.launcher.vm.LaunchingMessages;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamaicaVMDebugRunner
extends JamaicaVMRunner {
    public JamaicaVMDebugRunner(IVMInstall vmInstance) {
        super(vmInstance);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        attrmap = config.getVMSpecificAttributesMap();
        if (attrmap != null && (vmTypeString = (String)attrmap.get("com.aicas.jamaica.eclipse.launcher.vm.VM_TYPE")) != null && !vmTypeString.contains("DEBUG_INTERFACE")) {
            super.run(config, launch, monitor);
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.JamaicaVMDebugRunner_Launching_JamaicaVM_in_debug_mode, 4);
        subMonitor.subTask(LaunchingMessages.JamaicaVMDebugRunner_Finding_free_socket);
        port = SocketUtil.findFreePort();
        if (port == -1) {
            this.abort(LaunchingMessages.JamaicaVMDebugRunner_Could_not_find_a_free_socket_for_the_debugger, null, 118);
        }
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(LaunchingMessages.common_Constructing_command_line);
        program = this.constructProgramString(config, launch.getLaunchMode());
        arguments = new ArrayList<String>(12);
        arguments.add(program);
        allVMArgs = this.combineVmArgs(config, this.myVMInstallInstance);
        this.addArguments(allVMArgs, arguments);
        arguments.add("-agentlib:BuiltInAgent=transport=dt_socket,server=n,suspend=y,address=localhost:" + port);
        cp = config.getClassPath();
        if (cp.length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClasspath(cp));
        }
        arguments.add(config.getClassToLaunch());
        this.addArguments(config.getProgramArguments(), arguments);
        cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        envp = this.mergeEnvironment(config.getEnvironment(), launch.getLaunchConfiguration().getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true), this.myVMInstallInstance.getInstallLocation().toString());
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.common_Starting_JamaicaVM);
        connector = this.getConnector();
        if (connector == null) {
            this.abort(LaunchingMessages.JamaicaVMDebugRunner_Could_not_find_an_appropriate_debug_connector, null, 119);
        }
        map = connector.defaultArguments();
        this.specifyArguments(map, port);
        p = null;
        try {
            try {
                if (monitor.isCanceled()) {
                    return;
                }
                connector.startListening(map);
                workingDir = this.getWorkingDir(config);
                p = this.exec(cmdLine, workingDir, envp);
                if (p == null) {
                    return;
                }
                if (monitor.isCanceled()) {
                    p.destroy();
                    return;
                }
                process = this.newProcess(launch, p, this.renderProcessLabel(cmdLine), this.getDefaultProcessMap());
                process.setAttribute(IProcess.ATTR_CMDLINE, this.join(cmdLine, ' '));
                subMonitor.worked(1);
                subMonitor.subTask(LaunchingMessages.JamaicaVMDebugRunner_Establishing_debug_connection);
                retry = false;
                while (true) {
                    try {
                        runnable = new ConnectRunnable(connector, map);
                        connectThread = new Thread((Runnable)runnable, LaunchingMessages.JamaicaVMDebugRunner_Listening_Connector);
                        connectThread.setDaemon(true);
                        connectThread.start();
                        while (connectThread.isAlive()) {
                            if (!monitor.isCanceled()) ** break block37
                            connector.stopListening(map);
                            p.destroy();
                            return;
                        }
                    }
                    catch (InterruptedIOException e) {
                        this.checkErrorMessage(process);
                        status = new Status(4, "com.aicas.jamaica.eclipse.launcher", 117, "", (Throwable)e);
                        handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                        retry = false;
                        if (handler == null) {
                            throw new CoreException((IStatus)status);
                        }
                        result = handler.handleStatus((IStatus)status, (Object)this);
                        if (!(result instanceof Boolean)) continue;
                        retry = (Boolean)result;
                        if (retry) continue;
                        break;
                    }
                    {
                        try {
                            p.exitValue();
                            try {
                                connector.stopListening(map);
                            }
                            catch (IOException var21_25) {
                                // empty catch block
                            }
                            this.checkErrorMessage(process);
                        }
                        catch (IllegalThreadStateException var21_26) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException var21_27) {
                            // empty catch block
                        }
                        continue;
                    }
                    ex = runnable.getException();
                    if (ex instanceof IllegalConnectorArgumentsException) {
                        throw (IllegalConnectorArgumentsException)ex;
                    }
                    if (ex instanceof InterruptedIOException) {
                        throw (InterruptedIOException)ex;
                    }
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    vm = runnable.getVirtualMachine();
                    if (vm != null) {
                        JDIDebugModel.newDebugTarget((ILaunch)launch, (VirtualMachine)vm, (String)(String.valueOf(config.getClassToLaunch()) + LaunchingMessages.JamaicaVMDebugRunner__at_ + port), (IProcess)process, (boolean)true, (boolean)false, (boolean)config.isResumeOnStartup());
                        subMonitor.worked(1);
                        subMonitor.done();
                    }
                    return;
                }
            }
            finally {
                connector.stopListening(map);
            }
        }
        catch (IOException e) {
            this.abort(LaunchingMessages.JamaicaVMDebugRunner_Could_not_connect_to_VM, e, 120);
        }
        catch (IllegalConnectorArgumentsException e) {
            this.abort(LaunchingMessages.JamaicaVMDebugRunner_Could_not_connect_to_VM, e, 120);
        }
        if (p != null) {
            p.destroy();
        }
    }

    protected void checkErrorMessage(IProcess process) throws CoreException {
        IStreamsProxy streamsProxy = process.getStreamsProxy();
        if (streamsProxy != null) {
            String errorMessage = streamsProxy.getErrorStreamMonitor().getContents();
            if (errorMessage.length() == 0) {
                errorMessage = streamsProxy.getOutputStreamMonitor().getContents();
            }
            if (errorMessage.length() != 0) {
                this.abort(errorMessage, null, 116);
            }
        }
    }

    protected void specifyArguments(Map<?, ?> map, int portNumber) {
        Connector.IntegerArgument port = (Connector.IntegerArgument)map.get("port");
        port.setValue(portNumber);
        Connector.IntegerArgument timeoutArg = (Connector.IntegerArgument)map.get("timeout");
        if (timeoutArg != null) {
            int timeout = JavaRuntime.getPreferences().getInt(JavaRuntime.PREF_CONNECT_TIMEOUT);
            timeoutArg.setValue(timeout);
        }
    }

    protected ListeningConnector getConnector() {
        List<ListeningConnector> connectors = Bootstrap.virtualMachineManager().listeningConnectors();
        int i = 0;
        while (i < connectors.size()) {
            ListeningConnector c = connectors.get(i);
            if ("com.sun.jdi.SocketListen".equals(c.name())) {
                return c;
            }
            ++i;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConnectRunnable
    implements Runnable {
        private VirtualMachine fVirtualMachine = null;
        private ListeningConnector fConnector = null;
        private Map<String, ? extends Connector.Argument> fConnectionMap = null;
        private Exception fException = null;

        public ConnectRunnable(ListeningConnector connector, Map<String, ? extends Connector.Argument> map) {
            this.fConnector = connector;
            this.fConnectionMap = map;
        }

        @Override
        public void run() {
            try {
                this.fVirtualMachine = this.fConnector.accept(this.fConnectionMap);
            }
            catch (IOException e) {
                this.fException = e;
            }
            catch (IllegalConnectorArgumentsException e) {
                this.fException = e;
            }
        }

        public VirtualMachine getVirtualMachine() {
            return this.fVirtualMachine;
        }

        public Exception getException() {
            return this.fException;
        }
    }
}

