/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher;

import com.aicas.jamaica.Option;
import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.Messages;
import com.aicas.jamaica.range.BooleanRange;
import com.aicas.jamaica.range.ListRange;
import com.aicas.jamaica.range.Range;
import com.aicas.jamaica.range.StringRangeDirectory;
import com.aicas.jamaica.range.StringRangeFile;
import com.aicas.jamaica.range.StringRangeFromList;
import com.aicas.jamaica.range.StringRangeSomeFromList;
import com.aicas.jamaica.tools.xml.BoxiParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxiOptions
implements IToolOptions {
    public static final String DESC_DEFAULT_TAG = "@DEFAULT@";
    public static final int DESC_DEFAULT_TAG_LENGTH = "@DEFAULT@".length();
    public static final String DESC_DEFAULT_IMMEDIATE_TAG = "@DEFAULT:";
    public static final int DESC_DEFAULT_IMMEDIATE_TAG_LENGTH = "@DEFAULT:".length();
    private JamaicaVMDistribution distribution;
    private String toolClasspath;
    private String toolPath;
    private Map<String, Option> options;
    private List<String> groups;
    private Map<String, Properties> defaultValues;

    public String getDefaultValue(String optionName, String targetName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        if (optionName.equals("target")) {
            return this.distribution.getHostTarget();
        }
        String t = targetName == null ? this.distribution.getHostTarget() : targetName;
        String optDefVal = this.defaultValues.containsKey(t) ? this.defaultValues.get(t).getProperty(optionName) : null;
        Option opt = this.options.get(optionName);
        if (opt.getRange().getClass().equals(Range.BOOLEAN_VALUE.getClass()) && (optDefVal == null || optDefVal.isEmpty())) {
            optDefVal = Boolean.toString(Boolean.parseBoolean(optDefVal));
        }
        return optDefVal;
    }

    public List<String> getAvailableGroups() {
        return this.groups;
    }

    public String getGroup(String optionName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        return this.options.get(optionName).getGroup();
    }

    public String getType(String optionName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        return this.options.get(optionName).getType();
    }

    public String getDescription(String optionName, String targetName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        StringBuffer desc = new StringBuffer(this.options.get(optionName).getDescription());
        int dtPos = desc.indexOf(DESC_DEFAULT_TAG);
        if (dtPos >= 0) {
            String defaultValue = this.getDefaultValue(optionName, targetName);
            desc.replace(dtPos, dtPos + DESC_DEFAULT_TAG_LENGTH, defaultValue == null ? "" : String.valueOf('\n') + MessageFormat.format(Messages.BoxiOptions_Default___1, defaultValue));
        } else {
            int dtiStartPos = desc.indexOf(DESC_DEFAULT_IMMEDIATE_TAG);
            if (dtiStartPos >= 0) {
                int dtiEndPos = desc.indexOf("@", dtiStartPos + DESC_DEFAULT_IMMEDIATE_TAG_LENGTH);
                if (dtiEndPos < 0) {
                    dtiEndPos = desc.length();
                }
                String defaultValue = desc.substring(dtiStartPos + DESC_DEFAULT_IMMEDIATE_TAG_LENGTH, dtiEndPos);
                desc.replace(dtiStartPos, dtiEndPos + 1, String.valueOf('\n') + MessageFormat.format(Messages.BoxiOptions_Default___1, defaultValue));
            }
        }
        return desc.toString();
    }

    public String getArgument(String optionName) {
        return null;
    }

    public List<String> getAvailableOptions() {
        if (this.options == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.options.keySet());
    }

    public String getSeparators(String optionName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        Option option = this.options.get(optionName);
        Range range = option.getRange();
        if (optionName.equals("resource")) {
            return " ";
        }
        if (range instanceof ListRange) {
            return String.valueOf(((ListRange)range).getSeparators()) + " ";
        }
        if (range instanceof StringRangeFromList) {
            return " ";
        }
        return null;
    }

    public IToolOptions.EditorType getOptionEditorType(String optionName) {
        if (this.options.containsKey(optionName)) {
            Option option = this.options.get(optionName);
            Range range = option.getRange();
            if (optionName.equals("agentlib")) {
                return IToolOptions.EditorType.AGENTLIB;
            }
            if (optionName.equals("target")) {
                return IToolOptions.EditorType.LIST_SELECTION;
            }
            if (range instanceof BooleanRange) {
                return IToolOptions.EditorType.BOOLEAN;
            }
            if (range instanceof ListRange) {
                return IToolOptions.EditorType.STRING_LIST;
            }
            if (range instanceof StringRangeFromList) {
                return IToolOptions.EditorType.LIST_SELECTION;
            }
        }
        return IToolOptions.EditorType.STRING;
    }

    public List<String> getOptionEditorArgs(String optionName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        Option option = this.options.get(optionName);
        Range range = option.getRange();
        if (optionName.equals("resource")) {
            return null;
        }
        if (optionName.equals("useProfile")) {
            return Arrays.asList("file", "absolute_paths");
        }
        if (optionName.equals("target")) {
            return this.distribution.getAvailableTargets();
        }
        if (range instanceof StringRangeFile) {
            return Arrays.asList("file");
        }
        if (range instanceof StringRangeDirectory) {
            return Arrays.asList("directory");
        }
        if (range instanceof ListRange) {
            boolean isFile = false;
            boolean isDirectory = false;
            for (Range subRange : range) {
                if (subRange instanceof StringRangeFile) {
                    isFile = true;
                    continue;
                }
                if (!(subRange instanceof StringRangeDirectory)) continue;
                isDirectory = true;
            }
            ArrayList<String> listRangeArgs = new ArrayList<String>();
            if (isFile) {
                listRangeArgs.add("file");
            }
            if (isDirectory) {
                listRangeArgs.add("directory");
            }
            return listRangeArgs;
        }
        if (range instanceof StringRangeFromList) {
            ArrayList<String> listSelectionRangeArgs = new ArrayList<String>();
            if (range instanceof StringRangeSomeFromList) {
                listSelectionRangeArgs.add("multi");
            }
            listSelectionRangeArgs.addAll(((StringRangeFromList)range).getAcceptableValues());
            return listSelectionRangeArgs;
        }
        return null;
    }

    public void init(AbstractJamaicaDistribution jamaicaDist, ToolType tool) {
        this.init((JamaicaVMDistribution)jamaicaDist, tool);
    }

    public void init(JamaicaVMDistribution dist, ToolType tool) {
        if (!(ToolType.JAMAICA.equals((Object)tool) || ToolType.JAMAICAH.equals((Object)tool) || ToolType.THREADMONITOR.equals((Object)tool))) {
            throw new IllegalArgumentException(String.valueOf(Messages.BoxiOptions_Unsupported_tool_type) + ": " + tool);
        }
        this.distribution = dist;
        String mainBin = String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "bin" + File.separator;
        String targetClasses = String.valueOf(this.distribution.getClassesDirectory(this.distribution.getHostTarget())) + File.separator;
        switch (tool) {
            case JAMAICA: {
                this.toolPath = String.valueOf(mainBin) + "jamaica_bin";
                break;
            }
            case JAMAICAH: {
                this.toolPath = String.valueOf(mainBin) + "jamaicah_bin";
                break;
            }
            case THREADMONITOR: {
                this.toolPath = String.valueOf(targetClasses) + "ThreadMonitor.jar";
            }
        }
        String string = this.toolPath = new File(this.toolPath).isFile() ? this.toolPath : null;
        if (ToolType.JAMAICA.equals((Object)tool) || ToolType.JAMAICAH.equals((Object)tool)) {
            this.toolClasspath = LauncherPlugin.normalize(String.valueOf(targetClasses) + "JamaicaTask.jar");
        } else if (ToolType.THREADMONITOR.equals((Object)tool)) {
            this.toolClasspath = this.toolPath;
        }
        String toolXml = null;
        if (tool == ToolType.JAMAICA) {
            toolXml = "jamaicaoptions.xml";
        } else if (tool == ToolType.JAMAICAH) {
            toolXml = "jamaicahoptions.xml";
        }
        if (toolXml != null) {
            File f = new File(String.valueOf(dist.getInstallDirectory()) + File.separator + "etc" + File.separator + toolXml);
            BoxiParser bp = new BoxiParser(f);
            try {
                this.options = bp.getOptions();
            }
            catch (Exception e) {
                LauncherPlugin.log(e);
            }
        }
        if (this.options != null) {
            this.groups = new ArrayList<String>();
            for (Option curOption : this.options.values()) {
                String group = curOption.getGroup();
                if (this.groups.contains(group)) continue;
                this.groups.add(group);
            }
            this.defaultValues = new LinkedHashMap<String, Properties>();
            if (tool == ToolType.JAMAICA) {
                for (String curTarget : dist.getAvailableTargets()) {
                    Properties curTargetProperties = new Properties();
                    try {
                        FileInputStream fis = new FileInputStream(String.valueOf(dist.getInstallDirectory()) + File.separator + "target" + File.separator + curTarget + File.separator + "etc" + File.separator + "jamaica.conf");
                        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                        String line = null;
                        do {
                            if ((line = br.readLine()) == null || line.startsWith("#")) continue;
                            int dot = line.indexOf(46);
                            int equal = line.indexOf(61) + 1;
                            if (dot <= 0 || equal <= 0 || dot >= equal) continue;
                            curTargetProperties.put(line.substring(0, dot).trim(), line.substring(equal).trim());
                        } while (line != null);
                    }
                    catch (Exception e) {
                        LauncherPlugin.log(e);
                    }
                    this.defaultValues.put(curTarget, curTargetProperties);
                }
            } else if (tool == ToolType.JAMAICAH) {
                Properties jamaicahProperties = new Properties();
                try {
                    jamaicahProperties.load(new FileInputStream(String.valueOf(dist.getInstallDirectory()) + File.separator + "etc" + File.separator + "jamaicah.conf"));
                }
                catch (Exception e) {
                    LauncherPlugin.log(e);
                }
                this.defaultValues.put(dist.getHostTarget(), jamaicahProperties);
            }
        }
    }

    public String validate(String optionName, String value) {
        if (!this.options.containsKey(optionName)) {
            return Messages.BoxiOptions_Unknown_option;
        }
        String result = null;
        if ("target".equals(optionName)) {
            if (!this.distribution.getAvailableTargets().contains(value)) {
                result = "Platform '" + value + "' is not supported by this Jamaica distribution!";
            }
        } else {
            result = this.options.get(optionName).getRange().acceptsError(value);
        }
        return result;
    }

    public String getToolClasspath() {
        return this.toolClasspath;
    }

    public boolean isAppendable(String optionName) {
        return false;
    }

    public String getToolPath() {
        return this.toolPath;
    }
}

