/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.wizards;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.wizards.GeneralSettingsWizardPage;
import com.aicas.jamaica.eclipse.ant_editor.wizards.Messages;
import com.aicas.jamaica.eclipse.ant_editor.wizards.SimpleJBFBuilder;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewJamaicaBuildFileWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private GeneralSettingsWizardPage generalPage;
    private IFile targetFile;

    public NewJamaicaBuildFileWizard() {
        this.setWindowTitle(Messages.NewJamaicaBuildFileWizard_window_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.generalPage = new GeneralSettingsWizardPage(this.selection);
        this.addPage((IWizardPage)this.generalPage);
    }

    public boolean performFinish() {
        try {
            this.targetFile = AntEditorPlugin.getJavaProjectByName(this.generalPage.getProject()).getProject().getFile((IPath)new Path(this.generalPage.getFileName()));
        }
        catch (Exception e) {
            return false;
        }
        final boolean targetFileExists = this.targetFile.exists();
        if (targetFileExists) {
            MessageDialog md = new MessageDialog(this.getShell(), Messages.NewJamaicaBuildFileWizard_File_exists___overwrite__, null, MessageFormat.format(Messages.NewJamaicaBuildFileWizard_The_file___1___already_exists___Do_you_want_to_overwrite_it__, this.targetFile.getFullPath().toString()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
            md.setBlockOnOpen(true);
            if (md.open() != 0) {
                return false;
            }
        }
        final SimpleJBFBuilder builder = new SimpleJBFBuilder(this.generalPage);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                block6: {
                    monitor.beginTask(String.valueOf(Messages.NewJamaicaBuildFileWizard_Creating__) + NewJamaicaBuildFileWizard.this.targetFile.getName(), 2);
                    try {
                        String errMsg = builder.buildJamaicaBuildFileScript();
                        if (errMsg == null) {
                            if (targetFileExists) {
                                NewJamaicaBuildFileWizard.this.targetFile.setContents(builder.getResult(), true, true, monitor);
                            } else {
                                NewJamaicaBuildFileWizard.this.targetFile.create(builder.getResult(), true, monitor);
                            }
                            break block6;
                        }
                        if (errMsg.isEmpty()) {
                            errMsg = Messages.NewJamaicaBuildFileWizard_Could_not_generate_Jamaica_Buildfile_contents;
                        }
                        throw new CoreException((IStatus)new Status(4, "com.aicas.jamaica.eclipse.ant_editor", -1, errMsg, null));
                    }
                    catch (CoreException e) {
                        monitor.done();
                        throw new InvocationTargetException(e);
                    }
                }
                monitor.worked(1);
                monitor.setTaskName(Messages.NewJamaicaBuildFileWizard_Opening_file_for_editing______);
                NewJamaicaBuildFileWizard.this.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IViewPart view = activePage.findView("org.eclipse.jdt.ui.PackageExplorer");
                        if (view != null) {
                            ((ISetSelectionTarget)view).selectReveal((ISelection)new StructuredSelection((Object)NewJamaicaBuildFileWizard.this.targetFile));
                            try {
                                IDE.openEditor((IWorkbenchPage)activePage, (IFile)NewJamaicaBuildFileWizard.this.targetFile, (boolean)true);
                            }
                            catch (PartInitException e) {
                                AntEditorPlugin.log(e);
                            }
                        }
                    }
                });
                monitor.worked(1);
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            AntEditorPlugin.log(realException);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewJamaicaBuildFileWizard_Creating_new_Jamaica_Buildfile_failed, (String)Messages.NewJamaicaBuildFileWizard_Error_while_creating_new_Jamaica_Buildfile___see_log_for_details);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public GeneralSettingsWizardPage getGeneralPage() {
        return this.generalPage;
    }
}

