/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.wizards;

import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.wizards.GeneralSettingsWizardPage;
import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractJamaicaBuildFileBuilder {
    private int indentLevel;
    private StringBuilder buffer = new StringBuilder();
    protected GeneralSettingsWizardPage page;

    protected AbstractJamaicaBuildFileBuilder() {
    }

    public abstract String buildJamaicaBuildFileScript();

    protected void increaseIndent() {
        ++this.indentLevel;
    }

    protected void decreaseIndent() {
        this.indentLevel = Math.max(0, this.indentLevel - 1);
    }

    protected void addHeader() {
        this.add("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
    }

    protected void addCopyright(String description) {
        this.add("<!-- aicas GmbH, Karlsruhe -->");
        this.add("<!-- " + description + " -->");
    }

    protected void addComment(String comment) {
        this.add("<!-- " + comment + " -->");
    }

    protected void startProject(String name, String basedir, String defaultTarget) {
        this.add("<project" + (basedir == null ? "" : " basedir=\"" + basedir + "\"") + (defaultTarget == null ? "" : " default=\"" + defaultTarget + "\"") + " " + "name" + "=\"" + name + "\">");
    }

    protected void addTaskdef(String taskName, String className, String classpath) {
        this.add(MessageFormat.format("<taskdef classname=\"{1}\" classpath=\"{2}\" name=\"{0}\"/>", taskName, className, classpath));
    }

    protected void addTaskdef(ToolType tool) {
        IToolOptions toolOpts;
        JamaicaVMDistribution dist = this.page.getDistribution();
        if (dist != null && (toolOpts = dist.getToolOptions(tool)) != null) {
            String toolTagname = tool.tagname((AbstractJamaicaDistribution)dist);
            String toolClasspath = toolOpts.getToolClasspath();
            toolClasspath = toolClasspath.replace(dist.getInstallDirectory(), "${jamaica}");
            this.addTaskdef(toolTagname, tool.classname(), toolClasspath);
        }
    }

    protected void addProperty(String name, String value) {
        this.add(MessageFormat.format("<property name=\"{0}\" value=\"{1}\"/>", name, value));
    }

    protected void addEnvProperty(String envPrefix) {
        this.add(MessageFormat.format("<property environment=\"{0}\"/>", envPrefix));
    }

    protected void addJamaicaCondition(String envPrefix) {
        this.add(MessageFormat.format("<condition property=\"jamaica\" value=\"$'{'{0}.JAMAICA'}'\">", envPrefix));
        this.increaseIndent();
        this.add(MessageFormat.format("<isset property=\"{0}.JAMAICA\"/>", envPrefix));
        this.decreaseIndent();
        this.add("</condition>");
    }

    protected void addJamaicaFail() {
        this.add("<fail message=\"Please set the JAMAICA environment variable to a Jamaica installation!\" unless=\"jamaica\"/>");
    }

    protected void addTool(ToolType toolType, String antTargetName, String depends, String unless, String jamaica, String additionalAttribs, String executable, boolean isHostTarget, Map<String, PossiblyEscapedString> options) {
        this.add("<target" + (depends == null ? "" : " depends=\"" + depends + "\"") + " " + "name" + "=\"" + antTargetName + "\"" + (unless == null ? "" : " unless=\"" + unless + "\"") + ">");
        this.increaseIndent();
        JamaicaVMDistribution distro = this.page.getDistribution();
        String toolName = toolType.tagname((AbstractJamaicaDistribution)distro);
        this.add(MessageFormat.format("<{0} jamaica=\"{1}\"{2}>", toolName, jamaica, additionalAttribs == null ? "" : String.valueOf(' ') + additionalAttribs));
        this.increaseIndent();
        int verMaj = distro.getVersionMajor();
        int verMin = distro.getVersionMinor();
        String optline = "";
        optline = verMaj == 8 && verMin >= 5 || verMaj > 8 ? this.formatTag("option", "append", "{1}", "enabled", "true", "escape", "{2}", "name", "{0}", "value", "{3}") : (verMaj == 6 && verMin >= 4 || verMaj > 6 ? this.formatTag("option", "append", "{1}", "enabled", "true", "name", "{0}", "value", "{2}") : (verMaj == 6 && verMin >= 0 ? this.formatTag("{0}", "append", "{1}", "enabled", "true", "value", "{2}") : this.formatTag("{0}", "enabled", "true", "value", "{1}")));
        for (String optname : options.keySet()) {
            String optval = options.get(optname).getString().replaceAll("\"", "&quot;");
            if (verMaj < 6) {
                this.add(MessageFormat.format(optline, optname, optval));
                continue;
            }
            boolean append = distro.getToolOptions(toolType).isAppendable(optname);
            if (verMaj < 8 || verMaj == 8 && verMin < 5) {
                this.add(MessageFormat.format(optline, optname, append, optval));
                continue;
            }
            boolean escape = options.get(optname).isEscaped();
            this.add(MessageFormat.format(optline, optname, append, escape, optval));
        }
        this.decreaseIndent();
        this.add(MessageFormat.format("</{0}>", toolName));
        if (executable != null) {
            this.addPlainLine("<echo>");
            this.increaseIndent();
            this.addPlainLine(Messages.ToolChunk_The_executable_has_been_created_successfully__);
            this.increaseIndent();
            this.addPlainLine(ToolChunk.getWritableString(executable));
            this.decreaseIndent();
            if (isHostTarget) {
                this.addPlainLine(Messages.ToolChunk_You_can_launch_it_using_the___Overview___page_in_this_editor__);
            } else {
                this.addPlainLine(Messages.ToolChunk_Please_transfer_it_to_your_target_device_manually__);
            }
            this.decreaseIndent();
            this.addPlainLine("</echo>");
        }
        this.decreaseIndent();
        this.add("</target>");
    }

    protected String formatTag(String ... elx) {
        String xmlTag = null;
        if (elx.length > 0) {
            xmlTag = "<";
            int i = 0;
            while (i < elx.length) {
                xmlTag = String.valueOf(xmlTag) + elx[i];
                if (i % 2 == 0) {
                    if (i > 0) {
                        xmlTag = String.valueOf(xmlTag) + "\"";
                    }
                    if (i < elx.length - 1) {
                        xmlTag = String.valueOf(xmlTag) + " ";
                    }
                } else if (i < elx.length - 1) {
                    xmlTag = String.valueOf(xmlTag) + "=\"";
                }
                ++i;
            }
            xmlTag = String.valueOf(xmlTag) + "/>";
        }
        return xmlTag;
    }

    protected void addEmptyLine() {
        this.add("");
    }

    protected void addPlainLine(String plainLine) {
        this.add(plainLine);
    }

    protected void endProject() {
        this.add("</project>");
    }

    public InputStream getResult() {
        return new ByteArrayInputStream(this.buffer.toString().getBytes());
    }

    private void add(String line) {
        String indent = "";
        int i = 0;
        while (i < this.indentLevel) {
            indent = String.valueOf(indent) + "  ";
            ++i;
        }
        this.buffer.append(String.valueOf(indent) + line.trim() + "\n");
    }
}

