/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.DOMUtils;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ToolArgFile {
    private final ToolChunk toolChunk;
    private Element optionElement;
    public static final String ATTR_FILE = "file";

    public ToolArgFile(ToolChunk toolChunk, Element optElement) {
        this.toolChunk = toolChunk;
        this.optionElement = optElement;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolArgFile)) {
            return false;
        }
        ToolArgFile other = (ToolArgFile)obj;
        if (!this.getFile().equals(other.getFile())) {
            return false;
        }
        return this.optionElement.getTagName().equals(other.optionElement.getTagName());
    }

    public boolean addToTree() {
        boolean res = false;
        Node parent = this.optionElement.getParentNode();
        if (parent == null) {
            String fileName;
            if (!this.optionElement.getOwnerDocument().equals(this.toolChunk.getToolNode().getOwnerDocument())) {
                this.optionElement = (Element)this.toolChunk.getToolNode().getOwnerDocument().adoptNode(this.optionElement);
            }
            if (!this.toolChunk.argfiles.containsKey(fileName = this.getFile())) {
                res = DOMUtils.appendNode(this.toolChunk.getToolNode(), this.optionElement);
            }
        }
        return res;
    }

    public boolean isChildOfTree() {
        Node parent = this.optionElement.getParentNode();
        return this.toolChunk.getToolNode().isSameNode(parent);
    }

    public boolean removeFromTree() {
        return DOMUtils.removeNode(this.optionElement);
    }

    public Element getElement() {
        return this.optionElement;
    }

    public String getFile() {
        return this.optionElement.getAttribute(ATTR_FILE);
    }

    public String toString() {
        return "ArgumentFile:file=" + this.getFile();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getFile() == null ? 0 : this.getFile().hashCode());
        return result;
    }
}

