/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors.se;

import com.aicas.jamaica.eclipse.ant_editor.editors.se.AbstractSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.ui.CheckboxListViewer;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ListSelectionSettingEditor
extends AbstractSettingEditor {
    private StructuredViewer valueViewer;
    private List<String> selectableValues;
    private boolean isMulti;
    private List<String> separators;
    private Boolean isUpdatingUI = false;

    public ListSelectionSettingEditor(String optionName, ToolChunk chunk) {
        super(optionName, chunk);
    }

    protected void createInputArea(Composite parent, FormToolkit toolkit) {
        GridLayout gridLay = new GridLayout(1, false);
        gridLay.verticalSpacing = 10;
        gridLay.marginHeight = 10;
        gridLay.marginWidth = 10;
        parent.setLayout((Layout)gridLay);
        GridData boxGridData = GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(450, -1).create();
        final IToolOptions toolOpts = this.model.getToolOptions();
        List args = toolOpts.getOptionEditorArgs(this.associatedOption);
        this.isMulti = args.contains("multi");
        this.separators = toolOpts.getTupleSeparators(this.associatedOption);
        this.selectableValues = new ArrayList<String>(this.isMulti ? args.subList(1, args.size()) : args);
        Collections.sort(this.selectableValues);
        if (this.isMulti) {
            while (this.selectableValues.remove("all")) {
            }
            while (this.selectableValues.remove("none")) {
            }
            boxGridData.heightHint = 140;
            this.valueViewer = new CheckboxListViewer(parent);
            this.valueViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void selectionChanged(SelectionChangedEvent event) {
                    Boolean bl = ListSelectionSettingEditor.this.isUpdatingUI;
                    synchronized (bl) {
                        if (ListSelectionSettingEditor.this.isUpdatingUI.booleanValue()) {
                            return;
                        }
                    }
                    StructuredSelection selectedItems = (StructuredSelection)ListSelectionSettingEditor.this.valueViewer.getSelection();
                    if (selectedItems.isEmpty()) {
                        ListSelectionSettingEditor.this.setValue(new PossiblyEscapedString("none", ListSelectionSettingEditor.this.getEscape()));
                    } else if (selectedItems.size() == ListSelectionSettingEditor.this.selectableValues.size()) {
                        ListSelectionSettingEditor.this.setValue(new PossiblyEscapedString("all", ListSelectionSettingEditor.this.getEscape()));
                    } else {
                        List selectedList = selectedItems.toList();
                        ArrayList<PossiblyEscapedString> pesList = new ArrayList<PossiblyEscapedString>();
                        for (String selec : selectedList) {
                            pesList.add(new PossiblyEscapedString(selec, ListSelectionSettingEditor.this.getEscape()));
                        }
                        PossiblyEscapedString pes = toolOpts.join(pesList, ListSelectionSettingEditor.this.separators);
                        ListSelectionSettingEditor.this.setValue(pes);
                    }
                }
            });
            Label buttonSeparator = new Label(parent, 258);
            buttonSeparator.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
            Composite buttonContainer = new Composite(parent, 0);
            buttonContainer.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create());
            buttonContainer.setLayout((Layout)new FillLayout());
            Button buttonSelAll = new Button(buttonContainer, 8);
            buttonSelAll.setText("Select all");
            buttonSelAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ListSelectionSettingEditor.this.valueViewer.setSelection((ISelection)new StructuredSelection(ListSelectionSettingEditor.this.selectableValues));
                }
            });
            Button buttonSelNone = new Button(buttonContainer, 8);
            buttonSelNone.setText("Select none");
            buttonSelNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ListSelectionSettingEditor.this.valueViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            });
        } else {
            boxGridData.verticalAlignment = 128;
            this.valueViewer = new ComboViewer(parent, 12);
            this.valueViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void selectionChanged(SelectionChangedEvent event) {
                    Boolean bl = ListSelectionSettingEditor.this.isUpdatingUI;
                    synchronized (bl) {
                        if (ListSelectionSettingEditor.this.isUpdatingUI.booleanValue()) {
                            return;
                        }
                    }
                    String newValue = (String)((IStructuredSelection)ListSelectionSettingEditor.this.valueViewer.getSelection()).getFirstElement();
                    if (newValue == null) {
                        newValue = ((ComboViewer)ListSelectionSettingEditor.this.valueViewer).getCombo().getText();
                    }
                    ListSelectionSettingEditor.this.setValue(new PossiblyEscapedString(newValue, ListSelectionSettingEditor.this.getEscape()));
                }
            });
        }
        this.valueViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.valueViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.valueViewer.setInput(this.selectableValues);
        this.valueViewer.getControl().setLayoutData((Object)boxGridData);
        this.valueViewer.getControl().setFont(this.groupFont);
        this.invalidDecorator = new ControlDecoration(this.valueViewer.getControl(), 0x1004000, (Composite)this.optionControls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUI() {
        Boolean bl = this.isUpdatingUI;
        synchronized (bl) {
            this.isUpdatingUI = true;
        }
        super.updateUI();
        IToolOptions toolOpts = this.model.getToolOptions();
        List args = toolOpts.getOptionEditorArgs(this.associatedOption);
        this.separators = toolOpts.getTupleSeparators(this.associatedOption);
        List<String> oldSelectableValues = this.selectableValues;
        if (args != null) {
            this.isMulti = args.contains("multi");
            this.selectableValues = new ArrayList<String>(this.isMulti ? args.subList(1, args.size()) : args);
            Collections.sort(this.selectableValues);
            if (this.isMulti) {
                while (this.selectableValues.remove("all")) {
                }
                while (this.selectableValues.remove("none")) {
                }
            }
        } else {
            this.selectableValues = Collections.emptyList();
        }
        if (!oldSelectableValues.equals(this.selectableValues)) {
            Control focusControl = this.valueViewer.getControl().getDisplay().getFocusControl();
            this.valueViewer.setInput(this.selectableValues);
            focusControl.forceFocus();
        }
        this.valueViewer.getControl().setEnabled(this.getState());
        PossiblyEscapedString optionValue = this.getValueResolved();
        if (this.isMulti) {
            if (optionValue.getString().equals("all")) {
                this.valueViewer.setSelection((ISelection)new StructuredSelection(this.selectableValues));
            } else if (optionValue.getString().equals("none")) {
                this.valueViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                ArrayList<String> checkedElements = new ArrayList<String>();
                List tokens = toolOpts.split(optionValue, this.separators);
                for (PossiblyEscapedString token : tokens) {
                    if (!this.selectableValues.contains(token.getString())) continue;
                    checkedElements.add(token.getString());
                }
                this.valueViewer.setSelection((ISelection)new StructuredSelection(checkedElements));
            }
        } else if (this.selectableValues.contains(optionValue.getString())) {
            this.valueViewer.setSelection((ISelection)new StructuredSelection((Object)optionValue.getString()));
        } else {
            this.valueViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        Boolean bl2 = this.isUpdatingUI;
        synchronized (bl2) {
            this.isUpdatingUI = false;
        }
    }

    public void grabFocus() {
        super.grabFocus();
        this.valueViewer.getControl().setFocus();
    }
}

