/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.dialogs;

import com.aicas.jamaica.eclipse.ant_editor.dialogs.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.ui.ViewerFactory;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class ToolArgFileDialog
extends TitleAreaDialog {
    private ToolChunk toolchunk;
    private TableViewer argFileTableViewer;

    public ToolArgFileDialog(Shell parentShell, ToolChunk chunk) {
        super(parentShell);
        this.toolchunk = chunk;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ToolArgFileDialog_window_title);
        newShell.setSize(700, 500);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.ToolEnvironmentDialog_OK_button, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea2 = new Composite(parent, 0);
        this.setTitle(Messages.ToolArgFileDialog_title);
        this.setMessage(Messages.bind((String)Messages.ToolArgFileDialog_message, (Object)this.toolchunk.getName()));
        dialogArea2.setLayout((Layout)new GridLayout(1, false));
        dialogArea2.setLayoutData((Object)new GridData(4, 4, true, true));
        Group argFileGroup = new Group(dialogArea2, 0);
        argFileGroup.setLayout((Layout)new GridLayout(2, true));
        argFileGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        argFileGroup.setText(Messages.ToolArgFileDialog_argfile_group_text);
        this.argFileTableViewer = ViewerFactory.getToolArgFileViewer((Composite)argFileGroup, this.toolchunk);
        this.argFileTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.argFileTableViewer.getTable().setToolTipText(MessageFormat.format(Messages.ToolArgFileDialog_set_argument_files_for___0___, this.toolchunk.getToolType().toolname()));
        this.refreshArgFileTable();
        Button addArgFileButton = new Button((Composite)argFileGroup, 8);
        addArgFileButton.setText(Messages.ToolArgFileDialog_add);
        addArgFileButton.setToolTipText(Messages.ToolArgFileDialog_add_new_argument_file);
        addArgFileButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        addArgFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String basedir = ToolArgFileDialog.this.toolchunk.getManager().getProjectFile().getBasedirPath();
                FileDialog fd = new FileDialog(ToolArgFileDialog.this.getShell(), 4100);
                fd.setText(Messages.ToolArgFileDialog_please_select_argument_file);
                fd.setFilterPath(basedir);
                String file = fd.open();
                if (file != null) {
                    file = LauncherPlugin.normalize((String)file, (String)basedir);
                    ToolArgFileDialog.this.toolchunk.setArgumentFile(file);
                    ToolArgFileDialog.this.refreshArgFileTable();
                }
            }
        });
        Button removeArgFileButton = new Button((Composite)argFileGroup, 8);
        removeArgFileButton.setText(Messages.ToolArgFileDialog_remove);
        removeArgFileButton.setToolTipText(Messages.ToolArgFileDialog_remove_selected_argument_file);
        removeArgFileButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        removeArgFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                IStructuredSelection iss = (IStructuredSelection)ToolArgFileDialog.this.argFileTableViewer.getSelection();
                for (Object propName : iss.toList()) {
                    ToolArgFileDialog.this.toolchunk.removeArgumentFile((String)propName);
                    ToolArgFileDialog.this.refreshArgFileTable();
                }
            }
        });
        return dialogArea2;
    }

    private void refreshArgFileTable() {
        this.argFileTableViewer.setInput(this.toolchunk.getConfiguredArgumentFiles());
        TableColumn[] tableColumnArray = this.argFileTableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            ++n2;
        }
    }

    protected void okPressed() {
        super.okPressed();
    }
}

