/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.dialogs;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.AbstractAddTargetDialog;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefTag;
import com.aicas.jamaica.eclipse.ant_editor.ui.ViewerFactory;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class AddProfileAnalyzerTargetDialog
extends AbstractAddTargetDialog {
    private TableViewer jamaicaTasksViewer;
    private Spinner percSpinner;
    private Text fileText;

    public AddProfileAnalyzerTargetDialog(Shell parentShell, ProjectFile model) {
        super(parentShell, model);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AddProfileAnalyzerTargetDialog_window_title);
    }

    protected void createTargetSpecificArea(Composite parent) {
        IToolOptions to;
        PossiblyEscapedString pes;
        this.setTitle(Messages.AddProfileAnalyzerTargetDialog_title);
        this.setMessage(Messages.AddProfileAnalyzerTargetDialog_message);
        Group toolTargetGroup = new Group(parent, 0);
        toolTargetGroup.setText(Messages.AddProfileAnalyzerTargetDialog_tool_group_text);
        toolTargetGroup.setLayout((Layout)new GridLayout(3, false));
        toolTargetGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Label taskLabel = new Label((Composite)toolTargetGroup, 0);
        taskLabel.setText(String.valueOf(Messages.AddAcceleratorTargetDialog_Task) + ':');
        this.jamaicaTasksViewer = ViewerFactory.getTaskdefViewer((Composite)toolTargetGroup, this.model.getTaskdefManager(), ToolType.PROFILE_ANALYZER);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 50;
        this.jamaicaTasksViewer.getTable().setLayoutData((Object)gd);
        this.jamaicaTasksViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddProfileAnalyzerTargetDialog.this.handleTaskViewerSelection();
            }
        });
        new Label((Composite)toolTargetGroup, 0);
        int percDefVal = 30;
        JamaicaVMDistribution dist = JamaicaVMDistribution.findOrSetup((String)this.model.getProjectJRELocation());
        if (dist != null && (pes = (to = dist.getToolOptions(ToolType.PROFILE_ANALYZER)).getDefaultValue("percentageCompiled", dist.getHostTarget())) != null) {
            try {
                percDefVal = Integer.parseInt(to.unescape(pes));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Label percLabel = new Label((Composite)toolTargetGroup, 0);
        percLabel.setText(Messages.AddProfileAnalyzerTargetDialog_percentageCompiled_label_text);
        percLabel.setToolTipText(Messages.bind((String)Messages.AddProfileAnalyzerTargetDialog_percentageCompiled_label_tooltip, (Object)percDefVal));
        this.percSpinner = new Spinner((Composite)toolTargetGroup, 2048);
        this.percSpinner.setMinimum(0);
        this.percSpinner.setMaximum(100);
        this.percSpinner.setSelection(percDefVal);
        this.percSpinner.setIncrement(1);
        this.percSpinner.setPageIncrement(10);
        this.percSpinner.setDigits(0);
        this.percSpinner.setTextLimit(3);
        new Label((Composite)toolTargetGroup, 0);
        Label fileLabel = new Label((Composite)toolTargetGroup, 0);
        fileLabel.setText(Messages.AddProfileAnalyzerTargetDialog_file_label_text);
        fileLabel.setToolTipText(Messages.AddProfileAnalyzerTargetDialog_file_label_tooltip);
        this.fileText = new Text((Composite)toolTargetGroup, 2048);
        this.fileText.setLayoutData((Object)new GridData(4, -1, true, false));
        Button fileBrowseButton = new Button((Composite)toolTargetGroup, 8);
        fileBrowseButton.setText(Messages.AddAcceleratorTargetDialog_Browse______);
        fileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddProfileAnalyzerTargetDialog.this.handleFileBrowse();
            }
        });
        this.jamaicaTasksViewer.getTable().select(0);
        this.handleTaskViewerSelection();
    }

    private void handleTaskViewerSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.jamaicaTasksViewer.getSelection();
        if (!selection.isEmpty()) {
            String taskdefName = (String)selection.getFirstElement();
            JamaicaVMDistribution jamaicaVMDistribution = this.model.getTaskdefManager().getDistribution(taskdefName);
        }
    }

    protected void okPressed() {
        File f;
        String antTargetName = this.nameText.getText().trim();
        if ("".equals(antTargetName)) {
            this.setErrorMessage(Messages.AddAcceleratorTargetDialog_target_name_missing);
            return;
        }
        if (this.targetNameUsed(antTargetName)) {
            this.setErrorMessage(Messages.AddAcceleratorTargetDialog_target_name_already_used);
            return;
        }
        String antTargetDepends = this.dependsText.getText().trim();
        if ("".equals(antTargetDepends)) {
            antTargetDepends = null;
        } else {
            String[] tdeps;
            String[] stringArray = tdeps = antTargetDepends.split(",");
            int n = tdeps.length;
            int n2 = 0;
            while (n2 < n) {
                String tdep = stringArray[n2];
                if (tdep.equals(antTargetName)) {
                    this.setErrorMessage(Messages.bind((String)Messages.AddAcceleratorTargetDialog_target_selfdependency, (Object)tdep));
                    return;
                }
                if (!this.targetNameUsed(tdep)) {
                    this.setErrorMessage(Messages.bind((String)Messages.AddAcceleratorTargetDialog_target_dependency_must_exist, (Object)tdep));
                    return;
                }
                ++n2;
            }
        }
        String taskdefName = null;
        IStructuredSelection jamaicaTaskSelection = (IStructuredSelection)this.jamaicaTasksViewer.getSelection();
        if (!jamaicaTaskSelection.isEmpty()) {
            taskdefName = (String)jamaicaTaskSelection.getFirstElement();
            TaskdefTag task = (TaskdefTag)this.model.getTaskdefManager().getTag(taskdefName);
            if (!task.isBound()) {
                this.setErrorMessage(Messages.AddAcceleratorTargetDialog_Select_task_that_is_bound_to_VM);
                return;
            }
        } else {
            this.setErrorMessage(Messages.AddAcceleratorTargetDialog_please_create_new_jamaica_task);
            return;
        }
        int percComp = this.percSpinner.getSelection();
        if (percComp < 0 || percComp > 100) {
            this.setErrorMessage(Messages.AddProfileAnalyzerTargetDialog_percentage_compiled_value_out_of_range);
            return;
        }
        String profFile = this.fileText.getText().trim();
        String profFilePath = null;
        if ("".equals(profFile)) {
            this.setErrorMessage(Messages.AddProfileAnalyzerTargetDialog_missing_filename);
            return;
        }
        Object profPath = new Path(profFile);
        if (!profPath.isAbsolute()) {
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            IResource res = wsroot.findMember((IPath)profPath);
            profPath = res != null ? res.getLocation() : Path.EMPTY;
        }
        if ((f = profPath.toFile()) != null && f.exists()) {
            if (!f.canRead()) {
                this.setErrorMessage(Messages.AddProfileAnalyzerTargetDialog_file_not_readable);
                return;
            }
            if (!f.getName().endsWith(".prof")) {
                this.setErrorMessage(Messages.AddProfileAnalyzerTargetDialog_file_has_wrong_extension);
                return;
            }
        } else {
            this.setErrorMessage(Messages.AddProfileAnalyzerTargetDialog_file_must_exist);
            return;
        }
        profFilePath = f.getAbsolutePath();
        LinkedHashMap<String, PossiblyEscapedString> options = new LinkedHashMap<String, PossiblyEscapedString>();
        options.put("useProfile", PossiblyEscapedString.plain((String)profFilePath));
        options.put("percentageCompiled", PossiblyEscapedString.plain((String)this.percSpinner.getText()));
        try {
            this.model.getToolChunkManager().addToolChunk(antTargetName, antTargetDepends, taskdefName, options);
        }
        catch (ModelException me) {
            AntEditorPlugin.log(me);
            this.setErrorMessage(MessageFormat.format(Messages.AddAcceleratorTargetDialog_Could_not_add_new_Ant_target___1_____2, antTargetName, me.getMessage()));
            return;
        }
        super.okPressed();
    }

    private void handleFileBrowse() {
        File searchFolder = null;
        IWorkspaceRoot wspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject jProj = AntEditorPlugin.getJavaProjectByName(this.model.getFile().getProject().getName());
        searchFolder = jProj == null || !jProj.exists() ? wspaceRoot.getLocation().toFile() : jProj.getProject().getLocation().toFile();
        Set<File> profs = AntEditorPlugin.findFile(searchFolder, Pattern.compile(".*[.]prof"));
        HashSet<IFile> wsProfs = new HashSet<IFile>();
        for (File prof : profs) {
            wsProfs.add(wspaceRoot.getFileForLocation((IPath)new Path(prof.getAbsolutePath())));
        }
        ElementListSelectionDialog elsd = new ElementListSelectionDialog(AntEditorPlugin.getShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String retval = null;
                if (element instanceof IFile) {
                    IFile f = (IFile)element;
                    retval = MessageFormat.format(Messages.AddProfileAnalyzerTargetDialog_file_list_format, f.getName(), f.getFullPath());
                }
                return retval;
            }
        });
        elsd.setTitle(Messages.AddProfileAnalyzerTargetDialog_file_list_title);
        elsd.setMessage(String.valueOf(Messages.AddProfileAnalyzerTargetDialog_file_list_message) + ':');
        elsd.setElements((Object[])wsProfs.toArray(new IFile[0]));
        if (elsd.open() == 1) {
            return;
        }
        Object[] results = elsd.getResult();
        IFile file = (IFile)results[0];
        if (file != null) {
            String s = file.getFullPath().toOSString();
            if (s.startsWith(File.separator)) {
                s = s.substring(1, s.length());
            }
            this.fileText.setText(s);
        }
    }
}

