/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.dialogs;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.AbstractAddTargetDialog;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefTag;
import com.aicas.jamaica.eclipse.ant_editor.ui.ViewerFactory;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class AddAcceleratorTargetDialog
extends AbstractAddTargetDialog {
    private TableViewer jamaicaTasksViewer;
    private ComboViewer targetViewer;
    private Text jarFileText;

    public AddAcceleratorTargetDialog(Shell parentShell, ProjectFile model) {
        super(parentShell, model);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AddAcceleratorTargetDialog_window_title);
    }

    protected void createTargetSpecificArea(Composite parent) {
        this.setTitle(Messages.AddAcceleratorTargetDialog_title);
        this.setMessage(Messages.AddAcceleratorTargetDialog_message);
        Group builderTargetGroup = new Group(parent, 0);
        builderTargetGroup.setText(Messages.AddAcceleratorTargetDialog_Jamaica_settings);
        builderTargetGroup.setLayout((Layout)new GridLayout(3, false));
        builderTargetGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Label taskLabel = new Label((Composite)builderTargetGroup, 0);
        taskLabel.setText(String.valueOf(Messages.AddAcceleratorTargetDialog_Task) + ':');
        this.jamaicaTasksViewer = ViewerFactory.getTaskdefViewer((Composite)builderTargetGroup, this.model.getTaskdefManager(), ToolType.JARACCELERATOR);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 50;
        this.jamaicaTasksViewer.getTable().setLayoutData((Object)gd);
        this.jamaicaTasksViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddAcceleratorTargetDialog.this.handleTaskViewerSelection();
            }
        });
        new Label((Composite)builderTargetGroup, 0);
        Label targetLabel = new Label((Composite)builderTargetGroup, 0);
        targetLabel.setText(String.valueOf(Messages.AddAcceleratorTargetDialog_Target_platform) + ':');
        this.targetViewer = new ComboViewer((Composite)builderTargetGroup, 2060);
        this.targetViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.targetViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.targetViewer.getCombo().setLayoutData((Object)new GridData(4, -1, true, false));
        new Label((Composite)builderTargetGroup, 0);
        Label mainLabel = new Label((Composite)builderTargetGroup, 0);
        mainLabel.setText(String.valueOf(Messages.AddAcceleratorTargetDialog_Jar_file) + ':');
        mainLabel.setToolTipText("Enter absolute or relative paths here.\nRelative paths are resolved against the Eclipse Workspace directory.");
        this.jarFileText = new Text((Composite)builderTargetGroup, 2048);
        this.jarFileText.setLayoutData((Object)new GridData(4, -1, true, false));
        Button jarFileBrowseButton = new Button((Composite)builderTargetGroup, 8);
        jarFileBrowseButton.setText(Messages.AddAcceleratorTargetDialog_Browse______);
        jarFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddAcceleratorTargetDialog.this.handleJarFileBrowse();
            }
        });
        this.jamaicaTasksViewer.getTable().select(0);
        this.handleTaskViewerSelection();
    }

    private void handleTaskViewerSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.jamaicaTasksViewer.getSelection();
        if (!selection.isEmpty()) {
            String taskdefName = (String)selection.getFirstElement();
            JamaicaVMDistribution dist = this.model.getTaskdefManager().getDistribution(taskdefName);
            if (dist != null) {
                this.targetViewer.setInput((Object)dist.getAvailableTargets());
                this.targetViewer.setSelection((ISelection)new StructuredSelection((Object)dist.getHostTarget()));
            }
        }
    }

    protected void okPressed() {
        File f;
        String targetName = this.nameText.getText().trim();
        if ("".equals(targetName)) {
            this.setErrorMessage(Messages.AddAcceleratorTargetDialog_target_name_missing);
            return;
        }
        if (this.targetNameUsed(targetName)) {
            this.setErrorMessage("Target name is already used. Please change.");
            return;
        }
        String targetDepends = this.dependsText.getText().trim();
        if ("".equals(targetDepends)) {
            targetDepends = null;
        } else {
            String[] tdeps;
            String[] stringArray = tdeps = targetDepends.split(",");
            int n = tdeps.length;
            int n2 = 0;
            while (n2 < n) {
                String tdep = stringArray[n2];
                if (tdep.equals(targetName)) {
                    this.setErrorMessage("Target must not depend on itself: " + tdep);
                    return;
                }
                if (!this.targetNameUsed(tdep)) {
                    this.setErrorMessage("Target dependency must be an existing ant target: " + tdep);
                    return;
                }
                ++n2;
            }
        }
        String taskdefName = null;
        IStructuredSelection jamaicaTaskSelection = (IStructuredSelection)this.jamaicaTasksViewer.getSelection();
        if (!jamaicaTaskSelection.isEmpty()) {
            taskdefName = (String)jamaicaTaskSelection.getFirstElement();
            TaskdefTag task = (TaskdefTag)this.model.getTaskdefManager().getTag(taskdefName);
            if (!task.isBound()) {
                this.setErrorMessage(Messages.AddAcceleratorTargetDialog_Select_task_that_is_bound_to_VM);
                return;
            }
        } else {
            this.setErrorMessage(Messages.AddAcceleratorTargetDialog_please_create_new_jamaica_task);
            return;
        }
        String targetPlatform = null;
        IStructuredSelection targetSelection = (IStructuredSelection)this.targetViewer.getSelection();
        if (targetSelection.isEmpty()) {
            this.setErrorMessage("Please select a target platform.");
            return;
        }
        targetPlatform = (String)targetSelection.getFirstElement();
        String jarFile = this.jarFileText.getText().trim();
        String jarFilePath = null;
        if ("".equals(jarFile)) {
            this.setErrorMessage(Messages.AddAcceleratorTargetDialog_Please_specify_a_jar_file_name__);
            return;
        }
        Object jarPath = new Path(jarFile);
        if (!jarPath.isAbsolute()) {
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            IResource res = wsroot.findMember((IPath)jarPath);
            jarPath = res != null ? res.getLocation() : Path.EMPTY;
        }
        if ((f = jarPath.toFile()) != null && f.exists()) {
            if (!f.canRead()) {
                this.setErrorMessage("JAR file must be readable.");
                return;
            }
            if (!f.getName().endsWith(".jar")) {
                this.setErrorMessage("JAR filename must have '.jar' extension.");
                return;
            }
        } else {
            this.setErrorMessage("JAR file must exist.");
            return;
        }
        jarFilePath = f.getAbsolutePath();
        LinkedHashMap<String, PossiblyEscapedString> options = new LinkedHashMap<String, PossiblyEscapedString>();
        options.put("target", PossiblyEscapedString.plain((String)targetPlatform));
        options.put("source", PossiblyEscapedString.plain((String)jarFilePath));
        AntEditorPlugin.StringClasspathDescriber scd = AntEditorPlugin.getClasspath(this.model.getFile().getProject().getName());
        ArrayList<PossiblyEscapedString> cpItems = new ArrayList<PossiblyEscapedString>();
        for (String s : scd.outputLocations) {
            cpItems.add(PossiblyEscapedString.plain((String)s));
        }
        for (String s : scd.libraryLocations) {
            cpItems.add(PossiblyEscapedString.plain((String)s));
        }
        if (!scd.variableLocations.isEmpty()) {
            for (String e : scd.variableLocations) {
                this.model.getPropertiesManager().setPropertyValue(scd.varName(e), scd.varValue(e));
                String modLoc = e.replaceFirst(scd.varName(e), "\\$\\{" + scd.varName(e) + "\\}");
                cpItems.add(PossiblyEscapedString.plain((String)modLoc));
            }
        }
        IToolOptions toolOpts = this.model.getTaskdefManager().getToolOptions(taskdefName);
        List cpSeps = toolOpts.getTupleSeparators("classpath");
        options.put("classpath", toolOpts.join(cpItems, cpSeps));
        PossiblyEscapedString tmpDefault = toolOpts.getDefaultValue("tmpdir", targetPlatform);
        options.put("tmpdir", tmpDefault != null ? tmpDefault : PossiblyEscapedString.plain((String)"tmp"));
        try {
            this.model.getToolChunkManager().addToolChunk(targetName, targetDepends, taskdefName, options);
        }
        catch (ModelException me) {
            AntEditorPlugin.log(me);
            this.setErrorMessage(MessageFormat.format(Messages.AddAcceleratorTargetDialog_Could_not_add_new_Ant_target___1_____2, targetName, me.getMessage()));
            return;
        }
        super.okPressed();
    }

    private void handleJarFileBrowse() {
        File searchFolder = null;
        IWorkspaceRoot wspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject jProj = AntEditorPlugin.getJavaProjectByName(this.model.getFile().getProject().getName());
        searchFolder = jProj == null || !jProj.exists() ? wspaceRoot.getLocation().toFile() : jProj.getProject().getLocation().toFile();
        Set<File> jars = AntEditorPlugin.findFile(searchFolder, Pattern.compile(".*[.]jar"));
        HashSet<IFile> wsJars = new HashSet<IFile>();
        for (File jar : jars) {
            wsJars.add(wspaceRoot.getFileForLocation((IPath)new Path(jar.getAbsolutePath())));
        }
        ElementListSelectionDialog elsd = new ElementListSelectionDialog(AntEditorPlugin.getShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String retval = null;
                if (element instanceof IFile) {
                    IFile f = (IFile)element;
                    retval = MessageFormat.format(Messages.AddAcceleratorTargetDialog_jar_list_format, f.getName(), f.getFullPath());
                }
                return retval;
            }
        });
        elsd.setTitle(Messages.AddAcceleratorTargetDialog_jar_list_title);
        elsd.setMessage(String.valueOf(Messages.AddAcceleratorTargetDialog_jar_list_message) + ':');
        elsd.setElements((Object[])wsJars.toArray(new IFile[0]));
        if (elsd.open() == 1) {
            return;
        }
        Object[] results = elsd.getResult();
        IFile file = (IFile)results[0];
        if (file != null) {
            String s = file.getFullPath().toOSString();
            if (s.startsWith(File.separator)) {
                s = s.substring(1, s.length());
            }
            this.jarFileText.setText(s);
        }
    }
}

