/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor;

import com.aicas.jamaica.eclipse.ant_editor.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntEditorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aicas.jamaica.eclipse.ant_editor";
    private static AntEditorPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ProjectFile.initCache();
    }

    public void stop(BundleContext context) throws Exception {
        ProjectFile.shutdownCache();
        plugin = null;
        super.stop(context);
    }

    public static AntEditorPlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable t) {
        Status s = new Status(4, PLUGIN_ID, -1, Messages.AntEditorPlugin_generic_error_message, t);
        AntEditorPlugin.getDefault().getLog().log((IStatus)s);
    }

    public static void log(String message) {
        Status s = new Status(4, PLUGIN_ID, -1, message, null);
        AntEditorPlugin.getDefault().getLog().log((IStatus)s);
    }

    public static Shell getShell() {
        if (AntEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow() != null) {
            return AntEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public Version getAntEditorVersion() {
        Version antEditorVersion = null;
        try {
            Dictionary bundleHeaders = this.getBundle().getHeaders();
            String bVer = (String)bundleHeaders.get("Bundle-Version");
            if (bVer != null) {
                antEditorVersion = new Version(bVer);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return antEditorVersion;
    }

    public static String join(Object[] items, List<String> separators) {
        StringBuffer joinedString = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            joinedString.append(AntEditorPlugin.wrapWithQuotes(items[i].toString(), separators));
            if (i != items.length - 1) {
                joinedString.append(separators.get(0));
            }
            ++i;
        }
        return joinedString.toString();
    }

    public static String wrapWithQuotes(String item, List<String> forbiddenChars) {
        StringBuffer wrappedItem = new StringBuffer();
        boolean mustBeWrapped = false;
        int i = 0;
        while (i < forbiddenChars.size()) {
            mustBeWrapped |= item.contains(forbiddenChars.get(i));
            ++i;
        }
        if (mustBeWrapped && !item.startsWith("\"")) {
            wrappedItem.append("\"");
        }
        wrappedItem.append(item);
        if (mustBeWrapped && !item.endsWith("\"")) {
            wrappedItem.append("\"");
        }
        return wrappedItem.toString();
    }

    public static Set<File> findFile(File folder, final Pattern regex) {
        HashSet<File> retval = null;
        if (folder != null && folder.isDirectory()) {
            retval = new HashSet<File>();
            FileFilter ff = new FileFilter(){

                public boolean accept(File pathname) {
                    return regex.matcher(pathname.getName()).matches() || pathname.isDirectory();
                }
            };
            File[] files = folder.listFiles(ff);
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isFile()) {
                        retval.add(f);
                    } else {
                        retval.addAll(AntEditorPlugin.findFile(f, regex));
                    }
                    ++n2;
                }
            }
        }
        return retval;
    }

    public static IJavaProject getJavaProjectByName(String name) {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException e) {
            return null;
        }
        int i = 0;
        while (i < javaProjects.length) {
            IJavaProject javaProject = javaProjects[i];
            if (name.equals(javaProject.getProject().getName())) {
                return javaProject;
            }
            ++i;
        }
        return null;
    }

    public static String resolve(IPath file) {
        return AntEditorPlugin.resolve(file, null);
    }

    public static String resolve(IPath file, String relativeBase) {
        if (file == null) {
            return null;
        }
        try {
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(file);
            IPath p = f.getLocation();
            return LauncherPlugin.normalize((String)(p != null ? p.toString() : file.toString()), (String)relativeBase);
        }
        catch (IllegalArgumentException e) {
            String projectName = file.toString().startsWith("/") ? file.toString().substring(1) : file.toString();
            IJavaProject project = AntEditorPlugin.getJavaProjectByName(projectName);
            return LauncherPlugin.normalize((String)project.getResource().getLocation().toString(), (String)relativeBase);
        }
    }

    public static String getExeExtension() {
        return "win32".equals(Platform.getOS()) ? ".exe" : "";
    }

    public static String getSimpleClassName(String fullyQualifiedClassName) {
        String result = fullyQualifiedClassName;
        boolean openProperty = false;
        int lastPackageSeparatorIndex = -1;
        int lastClassSeparatorIndex = -1;
        char nextChar = '\u0000';
        int i = 0;
        while (i < result.length()) {
            nextChar = i + 1 < result.length() ? result.charAt(i + 1) : (char)'\u0000';
            switch (result.charAt(i)) {
                case '$': {
                    if (nextChar == '{') {
                        openProperty = true;
                        break;
                    }
                    if (openProperty) break;
                    lastClassSeparatorIndex = i;
                    break;
                }
                case '}': {
                    if (!openProperty) break;
                    openProperty = false;
                    break;
                }
                case '.': {
                    if (openProperty) break;
                    lastPackageSeparatorIndex = i;
                }
            }
            ++i;
        }
        result = result.substring(Math.max(lastPackageSeparatorIndex, lastClassSeparatorIndex) + 1);
        return result;
    }

    private static StringClasspathDescriber getClasspath(StringClasspathDescriber cpDesc, IJavaProject jproj, boolean isTargetProject, IClasspathEntry ... cpEntries) throws JavaModelException {
        String pdol = AntEditorPlugin.resolve(jproj.getOutputLocation());
        if (!cpDesc.outputLocations.contains(pdol)) {
            cpDesc.outputLocations.add(pdol);
        }
        IClasspathEntry[] iClasspathEntryArray = cpEntries;
        int n = cpEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry ice = iClasspathEntryArray[n2];
            if (ice.getEntryKind() == 3) {
                String outloc;
                if (isTargetProject || ice.isExported()) {
                    cpDesc.sourceLocations.add(AntEditorPlugin.resolve(ice.getPath()));
                }
                if ((outloc = AntEditorPlugin.resolve(ice.getOutputLocation())) != null) {
                    cpDesc.outputLocations.add(outloc);
                }
            } else if (ice.getEntryKind() == 1) {
                if (isTargetProject || ice.isExported()) {
                    cpDesc.libraryLocations.add(AntEditorPlugin.resolve(ice.getPath()));
                }
            } else if (ice.getEntryKind() == 4 && (isTargetProject || ice.isExported())) {
                cpDesc.variableLocations.add(ice.getPath().toString());
                String varName = cpDesc.varName(ice.getPath().toString());
                String string = cpDesc.varValue(varName);
            }
            ++n2;
        }
        return cpDesc;
    }

    public static StringClasspathDescriber getClasspath(String projectName) {
        IJavaProject project = AntEditorPlugin.getJavaProjectByName(projectName);
        if (project == null || !project.exists()) {
            return null;
        }
        String projectLocation = AntEditorPlugin.resolve(project.getProject().getLocation());
        StringClasspathDescriber scd = new StringClasspathDescriber();
        try {
            AntEditorPlugin.getClasspath(scd, project, true, project.getRawClasspath());
        }
        catch (JavaModelException jme) {
            AntEditorPlugin.log(jme);
        }
        if (scd.outputLocations.isEmpty()) {
            scd.outputLocations.add(".");
        }
        int i = 0;
        while (i < scd.outputLocations.size()) {
            scd.outputLocations.set(i, LauncherPlugin.normalize((String)scd.outputLocations.get(i), (String)projectLocation));
            ++i;
        }
        i = 0;
        while (i < scd.sourceLocations.size()) {
            scd.sourceLocations.set(i, LauncherPlugin.normalize((String)scd.sourceLocations.get(i), (String)projectLocation));
            ++i;
        }
        i = 0;
        while (i < scd.libraryLocations.size()) {
            scd.libraryLocations.set(i, LauncherPlugin.normalize((String)scd.libraryLocations.get(i), (String)projectLocation));
            ++i;
        }
        return scd;
    }

    public static class StringClasspathDescriber {
        public ArrayList<String> outputLocations = new ArrayList();
        public ArrayList<String> sourceLocations = new ArrayList();
        public ArrayList<String> libraryLocations = new ArrayList();
        public ArrayList<String> variableLocations = new ArrayList();

        public String varName(String varLoc) {
            String retval = null;
            if (varLoc != null) {
                retval = varLoc.indexOf(47) > -1 ? varLoc.substring(0, varLoc.indexOf(47)) : varLoc;
            }
            return retval;
        }

        public String varValue(String varLoc) {
            String varName;
            IPath p;
            String retval = null;
            if (varLoc != null && (p = JavaCore.getClasspathVariable((String)(varName = this.varName(varLoc)))) != null) {
                retval = p.toString();
            }
            return retval;
        }
    }
}

