/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.core;

import java.util.Objects;

public class PossiblyEscapedString {
    private final boolean escaped_;
    private final String string_;

    public PossiblyEscapedString(String string, boolean escaped) {
        this.escaped_ = escaped;
        this.string_ = Objects.requireNonNull(string, "string");
    }

    public String getString() {
        return this.string_;
    }

    public boolean isEscaped() {
        return this.escaped_;
    }

    public static PossiblyEscapedString plain(String string) {
        return new PossiblyEscapedString(string, false);
    }

    public static PossiblyEscapedString escaped(String string) {
        return new PossiblyEscapedString(string, true);
    }

    public int hashCode() {
        return Objects.hash(this.escaped_, this.string_);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PossiblyEscapedString)) {
            return false;
        }
        PossiblyEscapedString other = (PossiblyEscapedString)obj;
        return this.escaped_ == other.escaped_ && Objects.equals(this.string_, other.string_);
    }

    public String toString() {
        String name = this.isEscaped() ? "Escaped" : "Plain";
        return String.format("%s[%s]", name, this.getString());
    }
}

