/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.ant_launching;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.ant_launching.AntLaunchConfigurator;
import com.aicas.jamaica.eclipse.ant_editor.ant_launching.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;

public class AntLaunchUtils {
    public static void runAntTarget(IFile buildFile, String antTargetName) throws CoreException {
        ILaunchConfiguration[] configs;
        AntLaunchConfigurator configurator = AntLaunchConfigurator.getInstance();
        ILaunchConfigurationWorkingCopy theAntLaunch = null;
        String buildFileLocation = AntEditorPlugin.resolve(buildFile.getLocation());
        ILaunchConfiguration[] iLaunchConfigurationArray = configs = configurator.getAntLaunchConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launch = iLaunchConfigurationArray[n2];
            if (configurator.getLocation(launch) != null && configurator.getLocation(launch).equals(buildFileLocation) && Arrays.asList(antTargetName).equals(configurator.getAntTargets(launch)) && configurator.isAntEditorLaunch(launch)) {
                theAntLaunch = launch.getWorkingCopy();
                break;
            }
            ++n2;
        }
        if (theAntLaunch == null) {
            theAntLaunch = configurator.newAntLaunchConfiguration(MessageFormat.format(Messages.AntLaunchUtils_new_jamaica_build_file_name_format, antTargetName, buildFile.getName()));
        }
        configurator.setAntEditorProperty(theAntLaunch, true);
        HashMap<String, String> presetProps = new HashMap<String, String>();
        presetProps.put("jamaica", ProjectFile.getInstance(buildFile).getProjectJRELocation());
        presetProps.put("eclipse.running", "true");
        configurator.setAntProperties(theAntLaunch, presetProps);
        configurator.setLocation(theAntLaunch, buildFileLocation);
        configurator.setWorkingDirectory(theAntLaunch, AntEditorPlugin.resolve(buildFile.getLocation().removeLastSegments(1)));
        configurator.setLaunchInBackground(theAntLaunch, true);
        configurator.setDefaultVMInstall(theAntLaunch, false);
        configurator.setAntClasspathProvider(theAntLaunch);
        configurator.setRefreshScope(theAntLaunch, "${project}");
        configurator.setBuildScope(theAntLaunch, "${project}");
        ArrayList<String> targets = new ArrayList<String>();
        targets.add(antTargetName);
        configurator.setAntTargets(theAntLaunch, targets);
        final ILaunchConfiguration launch = theAntLaunch.doSave();
        AntEditorPlugin.getDefault().getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                DebugUITools.launch((ILaunchConfiguration)launch, (String)"run");
            }
        });
    }
}

