/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor;

import com.aicas.jamaica.eclipse.ant_editor.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class AntEditorPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aicas.jamaica.eclipse.ant_editor";
    private static AntEditorPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ProjectFile.initCache();
    }

    public void stop(BundleContext context) throws Exception {
        ProjectFile.shutdownCache();
        plugin = null;
        super.stop(context);
    }

    public static AntEditorPlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable t) {
        Status s = new Status(4, PLUGIN_ID, -1, Messages.AntEditorPlugin_generic_error_message, t);
        AntEditorPlugin.getDefault().getLog().log((IStatus)s);
    }

    public static void log(String message) {
        Status s = new Status(4, PLUGIN_ID, -1, message, null);
        AntEditorPlugin.getDefault().getLog().log((IStatus)s);
    }

    public static Shell getShell() {
        if (AntEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow() != null) {
            return AntEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public Version getAntEditorVersion() {
        Version antEditorVersion = null;
        try {
            Dictionary bundleHeaders = this.getBundle().getHeaders();
            String bVer = (String)bundleHeaders.get("Bundle-Version");
            if (bVer != null) {
                antEditorVersion = new Version(bVer);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return antEditorVersion;
    }

    public static String join(Object[] items, String separators) {
        StringBuffer joinedString = new StringBuffer();
        int i = 0;
        while (i < items.length) {
            joinedString.append(AntEditorPlugin.wrapWithQuotes(items[i].toString(), separators));
            if (i != items.length - 1) {
                joinedString.append(separators.charAt(0));
            }
            ++i;
        }
        return joinedString.toString();
    }

    public static String wrapWithQuotes(String item, String forbiddenChars) {
        StringBuffer wrappedItem = new StringBuffer();
        boolean mustBeWrapped = false;
        int i = 0;
        while (i < forbiddenChars.length()) {
            mustBeWrapped |= item.contains(forbiddenChars.substring(i, i + 1));
            ++i;
        }
        if (mustBeWrapped && !item.startsWith("\"")) {
            wrappedItem.append("\"");
        }
        wrappedItem.append(item);
        if (mustBeWrapped && !item.endsWith("\"")) {
            wrappedItem.append("\"");
        }
        return wrappedItem.toString();
    }

    public static IJavaProject getJavaProjectByName(String name) {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException e) {
            return null;
        }
        int i = 0;
        while (i < javaProjects.length) {
            IJavaProject javaProject = javaProjects[i];
            if (name.equals(javaProject.getProject().getName())) {
                return javaProject;
            }
            ++i;
        }
        return null;
    }

    public static String resolve(IPath file) {
        return AntEditorPlugin.resolve(file, null);
    }

    public static String resolve(IPath file, String relativeBase) {
        if (file == null) {
            return null;
        }
        try {
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(file);
            IPath p = f.getLocation();
            return LauncherPlugin.normalize((String)(p != null ? p.toString() : file.toString()), (String)relativeBase);
        }
        catch (IllegalArgumentException e) {
            String projectName = file.toString().startsWith("/") ? file.toString().substring(1) : file.toString();
            IJavaProject project = AntEditorPlugin.getJavaProjectByName(projectName);
            return LauncherPlugin.normalize((String)project.getResource().getLocation().toString(), (String)relativeBase);
        }
    }

    public static String getExeExtension() {
        return "win32".equals(Platform.getOS()) ? ".exe" : "";
    }

    public static String getSimpleClassName(String fullyQualifiedClassName) {
        String result = fullyQualifiedClassName;
        boolean openProperty = false;
        int lastPackageSeparatorIndex = -1;
        int lastClassSeparatorIndex = -1;
        char nextChar = '\u0000';
        int i = 0;
        while (i < result.length()) {
            nextChar = i + 1 < result.length() ? result.charAt(i + 1) : (char)'\u0000';
            switch (result.charAt(i)) {
                case '$': {
                    if (nextChar == '{') {
                        openProperty = true;
                        break;
                    }
                    if (openProperty) break;
                    lastClassSeparatorIndex = i;
                    break;
                }
                case '}': {
                    if (!openProperty) break;
                    openProperty = false;
                    break;
                }
                case '.': {
                    if (openProperty) break;
                    lastPackageSeparatorIndex = i;
                }
            }
            ++i;
        }
        result = result.substring(Math.max(lastPackageSeparatorIndex, lastClassSeparatorIndex) + 1);
        return result;
    }

    public static StringClasspathDescriber getClasspath(String projectName) {
        IJavaProject project = AntEditorPlugin.getJavaProjectByName(projectName);
        if (project == null || !project.exists()) {
            return null;
        }
        String projectLocation = AntEditorPlugin.resolve(project.getProject().getLocation());
        ArrayList<String> sourceLocations = new ArrayList<String>();
        ArrayList<String> libraryLocations = new ArrayList<String>();
        String outputLocation = ".";
        try {
            IClasspathEntry[] classpath;
            IClasspathEntry[] iClasspathEntryArray = classpath = project.getRawClasspath();
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry ice = iClasspathEntryArray[n2];
                if (ice.getEntryKind() == 3) {
                    sourceLocations.add(AntEditorPlugin.resolve(ice.getPath(), projectLocation));
                } else if (ice.getEntryKind() == 1) {
                    String resolvedPath = AntEditorPlugin.resolve(ice.getPath(), projectLocation);
                    libraryLocations.add(resolvedPath);
                }
                ++n2;
            }
            outputLocation = AntEditorPlugin.resolve(project.getOutputLocation(), projectLocation);
        }
        catch (JavaModelException jme) {
            AntEditorPlugin.log(jme);
        }
        StringClasspathDescriber scd = new StringClasspathDescriber();
        scd.outputLocation = outputLocation;
        scd.sourceLocations = sourceLocations;
        scd.libraryLocations = libraryLocations;
        return scd;
    }

    public static class StringClasspathDescriber {
        public String outputLocation;
        public List<String> sourceLocations;
        public List<String> libraryLocations;
    }
}

