/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.vm;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class JamaicaVMNatureJob
extends WorkspaceJob {
    private Mode mode;
    private IJavaProject javaProject;

    public JamaicaVMNatureJob() {
        this(Mode.INIT, null);
    }

    public JamaicaVMNatureJob(IJavaProject jp) {
        this(Mode.CHECK, jp);
    }

    private JamaicaVMNatureJob(Mode mode, IJavaProject project) {
        super(String.valueOf(mode.name()) + " JamaicaVM Nature");
        this.mode = mode;
        this.javaProject = project;
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        IStatus retval = Status.CANCEL_STATUS;
        if (this.mode == Mode.INIT) {
            retval = this.checkJavaProjects();
        } else if (this.mode == Mode.CHECK && this.javaProject != null) {
            retval = this.checkJavaProject(this.javaProject);
        }
        return retval;
    }

    private IStatus addJamaicaVMNature(IProject p) {
        IStatus retval = Status.CANCEL_STATUS;
        try {
            IProjectDescription pd = p.getDescription();
            String[] natures = pd.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = "com.aicas.jamaica.eclipse.launcher.jamaicavmnature";
            pd.setNatureIds(newNatures);
            p.setDescription(pd, null);
            retval = Status.OK_STATUS;
        }
        catch (CoreException e) {
            retval = Status.CANCEL_STATUS;
        }
        return retval;
    }

    private IStatus removeJamaicaVMNature(IProject p) {
        IStatus retval = Status.CANCEL_STATUS;
        try {
            IProjectDescription pd = p.getDescription();
            String[] natures = pd.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if (natures[i].equals("com.aicas.jamaica.eclipse.launcher.jamaicavmnature")) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    pd.setNatureIds(newNatures);
                    p.setDescription(pd, null);
                    retval = Status.OK_STATUS;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            retval = Status.CANCEL_STATUS;
        }
        return retval;
    }

    private IStatus checkJavaProject(IJavaProject jproject) {
        IStatus retval = Status.CANCEL_STATUS;
        try {
            IProjectDescription projDesc = jproject.getProject().getDescription();
            String[] natures = projDesc.getNatureIds();
            List<String> natureList = Arrays.asList(natures);
            IVMInstall jre = JavaRuntime.getVMInstall((IJavaProject)jproject);
            if (jre != null) {
                if (jre.getVMInstallType().getId().equals("com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMType")) {
                    if (!natureList.contains("com.aicas.jamaica.eclipse.launcher.jamaicavmnature")) {
                        retval = this.addJamaicaVMNature(jproject.getProject());
                    }
                } else if (natureList.contains("com.aicas.jamaica.eclipse.launcher.jamaicavmnature")) {
                    retval = this.removeJamaicaVMNature(jproject.getProject());
                }
            } else {
                IClasspathEntry[] iClasspathEntryArray = jproject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 5) {
                        String eeId = JavaRuntime.getExecutionEnvironmentId((IPath)entry.getPath());
                        if (eeId != null && eeId.startsWith("JamaicaVM")) {
                            if (!natureList.contains("com.aicas.jamaica.eclipse.launcher.jamaicavmnature")) {
                                retval = this.addJamaicaVMNature(jproject.getProject());
                            }
                        } else if (natureList.contains("com.aicas.jamaica.eclipse.launcher.jamaicavmnature")) {
                            retval = this.removeJamaicaVMNature(jproject.getProject());
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException ce) {
            retval = Status.CANCEL_STATUS;
        }
        return retval;
    }

    private IStatus checkJavaProjects() {
        IStatus retval = Status.CANCEL_STATUS;
        IJavaModel jmodel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            IJavaProject[] jprojects;
            IJavaProject[] iJavaProjectArray = jprojects = jmodel.getJavaProjects();
            int n = jprojects.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject jp = iJavaProjectArray[n2];
                retval = this.checkJavaProject(jp);
                ++n2;
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IViewPart packageView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.jdt.ui.PackageExplorer");
                    if (packageView != null) {
                        ((PackageExplorerPart)packageView.getViewSite().getPart()).refresh((IStructuredSelection)new StructuredSelection((Object[])jprojects));
                    }
                }
            });
        }
        catch (JavaModelException jme) {
            retval = Status.CANCEL_STATUS;
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        INIT,
        CHECK;

    }
}

