/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.wizards;

import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AcceleratedJarExportWizardPage
extends WizardPage {
    private IStructuredSelection selection;
    private ComboViewer targetChooser;
    private ComboViewer distroChooser;
    private String target;
    private String jarFile;
    private JamaicaVMDistribution distribution;
    private Text jarFileText;
    private IPath workspacePath;
    private DialogEntry optionsGroup;
    private final ModifyListener dialogChangedListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AcceleratedJarExportWizardPage.this.dialogChanged();
        }
    };

    public AcceleratedJarExportWizardPage(IStructuredSelection selection) {
        super("AcceleratedJarExportWizardPage");
        this.setTitle("Jamaica JAR Accelerator");
        this.setDescription("Create a new Accelerated JAR file (most-used methods will be compiled).");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        GridLayout dialogCompositeLayout = new GridLayout(3, false);
        dialogCompositeLayout.verticalSpacing = 6;
        dialogComposite.setLayout((Layout)dialogCompositeLayout);
        GridData wholeLine = new GridData(4, -1, true, false, 3, 1);
        GridLayout groupLayout = new GridLayout(3, false);
        groupLayout.verticalSpacing = 6;
        DialogEntry jarFileGroup = new DialogEntry(dialogComposite, 0);
        jarFileGroup.setLayoutData(new GridData(4, -1, true, false, 3, 1));
        jarFileGroup.setLayout((Layout)groupLayout);
        Label jarFileLabel = new Label((Composite)jarFileGroup, 0);
        jarFileLabel.setText("JAR:");
        this.jarFileText = new Text((Composite)jarFileGroup, 2048);
        this.jarFileText.setLayoutData((Object)new GridData(4, -1, true, false, 1, 1));
        this.jarFileText.setToolTipText("The JAR file you want to accelerate.");
        this.jarFileText.addModifyListener(this.dialogChangedListener);
        Button jarFileBrowse = new Button((Composite)jarFileGroup, 8);
        jarFileBrowse.setText("Browse...");
        jarFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.handleJarFileBrowse();
                AcceleratedJarExportWizardPage.this.dialogChanged();
            }

            private void handleJarFileBrowse() {
                AcceleratedJarExportWizardPage.this.workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                FileDialog dialog = new FileDialog(AcceleratedJarExportWizardPage.this.getShell(), 4096);
                dialog.setText("Select a JAR file:");
                dialog.setFilterExtensions(new String[]{"*.jar"});
                dialog.setFilterPath(AcceleratedJarExportWizardPage.this.workspacePath.toOSString());
                String selectedFile = dialog.open();
                if (selectedFile != null) {
                    Path selectedPath = new Path(selectedFile);
                    if (AcceleratedJarExportWizardPage.this.workspacePath.isPrefixOf((IPath)selectedPath)) {
                        AcceleratedJarExportWizardPage.this.jarFileText.setText(selectedPath.makeRelativeTo(AcceleratedJarExportWizardPage.this.workspacePath).toOSString());
                    } else {
                        AcceleratedJarExportWizardPage.this.jarFileText.setText(selectedPath.toOSString());
                    }
                }
            }
        });
        DialogEntry distroGroup = new DialogEntry(dialogComposite, 0);
        distroGroup.setLayoutData(new GridData(4, -1, true, false, 3, 1));
        distroGroup.setLayout((Layout)groupLayout);
        Label distroGroupHeader = new Label((Composite)distroGroup, 0);
        distroGroupHeader.setLayoutData((Object)wholeLine);
        distroGroupHeader.setText("Select the JAR Accelerator version:");
        Label distroLabel = new Label((Composite)distroGroup, 0);
        distroLabel.setText("Use:");
        this.distroChooser = new ComboViewer((Composite)distroGroup, 12);
        this.distroChooser.getControl().setLayoutData((Object)new GridData(4, -1, true, false));
        this.distroChooser.getControl().setToolTipText("The JAR accelerator that will be used for JAR compilation.");
        this.distroChooser.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.distroChooser.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.distroChooser.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AcceleratedJarExportWizardPage.this.dialogChanged();
            }
        });
        this.optionsGroup = new DialogEntry(dialogComposite, 0);
        this.optionsGroup.setLayoutData(new GridData(4, -1, true, false, 3, 1));
        this.optionsGroup.setLayout((Layout)groupLayout);
        Group optionsBox = new Group((Composite)this.optionsGroup, 0);
        optionsBox.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        optionsBox.setLayout((Layout)groupLayout);
        optionsBox.setText("Accelerator options:");
        Label targetLabel = new Label((Composite)optionsBox, 0);
        targetLabel.setText("Target platform:");
        this.targetChooser = new ComboViewer((Composite)optionsBox, 12);
        this.targetChooser.getControl().setLayoutData((Object)new GridData(4, -1, true, false));
        this.targetChooser.getControl().setToolTipText("The target platform for which the JAR will be compiled.");
        this.targetChooser.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.targetChooser.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.targetChooser.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AcceleratedJarExportWizardPage.this.dialogChanged();
            }
        });
        this.setControl((Control)dialogComposite);
        this.initialize();
        this.dialogChanged();
    }

    private void initialize() {
        IVMInstall[] allJamaicaJres;
        this.workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        IJavaProject jproj = null;
        ArrayList<JamaicaVMDistribution> accelDistros = new ArrayList<JamaicaVMDistribution>();
        IVMInstall[] iVMInstallArray = allJamaicaJres = JavaRuntime.getVMInstallType((String)"com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMType").getVMInstalls();
        int n = allJamaicaJres.length;
        int n2 = 0;
        while (n2 < n) {
            String instPath;
            JamaicaVMDistribution distro;
            IVMInstall jamaicaJre = iVMInstallArray[n2];
            File instLoc = jamaicaJre.getInstallLocation();
            if (instLoc != null && (distro = JamaicaVMDistribution.findOrSetup(instPath = instLoc.getAbsolutePath())) != null && distro.getAvailableTools().contains(ToolType.JARACCELERATOR)) {
                accelDistros.add(distro);
            }
            ++n2;
        }
        this.distroChooser.setInput(accelDistros);
        if (accelDistros.size() > 0) {
            this.distroChooser.setSelection((ISelection)new StructuredSelection(accelDistros.get(0)), true);
            this.distribution = (JamaicaVMDistribution)((Object)accelDistros.get(0));
            this.targetChooser.setInput((Object)((JamaicaVMDistribution)((Object)accelDistros.get(0))).getAvailableTargets());
            this.targetChooser.setSelection((ISelection)new StructuredSelection((Object)((JamaicaVMDistribution)((Object)accelDistros.get(0))).getHostTarget()));
            this.target = ((JamaicaVMDistribution)((Object)accelDistros.get(0))).getHostTarget();
        }
        if (this.selection != null && !this.selection.isEmpty() && this.selection.size() > 0) {
            Object obj = this.selection.getFirstElement();
            if (obj instanceof IResource) {
                IResource res = (IResource)obj;
                IPath location = res.getLocation();
                if (location != null && location.toFile().isFile() && location.toFile().getName().endsWith(".jar")) {
                    if (this.workspacePath.isPrefixOf(location)) {
                        this.jarFileText.setText(location.makeRelativeTo(this.workspacePath).toOSString());
                    } else {
                        this.jarFileText.setText(location.toOSString());
                    }
                }
                jproj = JavaCore.create((IProject)res.getProject());
            } else if (obj instanceof IJavaElement) {
                File f;
                IPath location;
                IJavaElement javaElement = (IJavaElement)obj;
                IResource res = javaElement.getResource();
                if (res != null && (location = res.getLocation()) != null && (f = location.toFile()).isFile() && f.getName().endsWith(".jar")) {
                    if (this.workspacePath.isPrefixOf(location)) {
                        this.jarFileText.setText(location.makeRelativeTo(this.workspacePath).toOSString());
                    } else {
                        this.jarFileText.setText(location.toOSString());
                    }
                }
                jproj = javaElement.getJavaProject();
            }
            if (jproj != null) {
                try {
                    JamaicaVMDistribution dist;
                    IVMInstall vm = JavaRuntime.getVMInstall(jproj);
                    if (vm != null && accelDistros.contains((Object)(dist = JamaicaVMDistribution.findOrSetup(vm.getInstallLocation().getAbsolutePath())))) {
                        this.distroChooser.setSelection((ISelection)new StructuredSelection((Object)dist), true);
                        this.distribution = dist;
                        this.targetChooser.setInput((Object)dist.getAvailableTargets());
                        this.targetChooser.setSelection((ISelection)new StructuredSelection((Object)dist.getHostTarget()));
                        this.target = dist.getHostTarget();
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    private void dialogChanged() {
        Object jarPath = Path.EMPTY;
        Path jarpathFromTextfield = new Path(this.jarFileText.getText());
        if (!jarpathFromTextfield.isEmpty()) {
            jarPath = !jarpathFromTextfield.isAbsolute() ? this.workspacePath.append((IPath)jarpathFromTextfield) : jarpathFromTextfield;
        }
        String curJAR = jarPath.toOSString();
        JamaicaVMDistribution curDistro = (JamaicaVMDistribution)((Object)((IStructuredSelection)this.distroChooser.getSelection()).getFirstElement());
        if (!((Object)((Object)curDistro)).equals((Object)this.distribution)) {
            this.distribution = curDistro;
            this.targetChooser.setInput((Object)curDistro.getAvailableTargets());
            this.targetChooser.setSelection((ISelection)new StructuredSelection((Object)curDistro.getHostTarget()));
        }
        String curTarget = (String)((IStructuredSelection)this.targetChooser.getSelection()).getFirstElement();
        List accelDistros = (List)this.distroChooser.getInput();
        if (accelDistros.isEmpty()) {
            this.updateStatus("No JamaicaVM distribution with JAR Accelerator available.", 3);
            this.optionsGroup.setEnabled(false);
            return;
        }
        if (curDistro == null) {
            this.updateStatus("No JAR Accelerator selected.", 3);
            this.optionsGroup.setEnabled(false);
            return;
        }
        this.optionsGroup.setEnabled(true);
        if (curJAR == null || curJAR.isEmpty()) {
            this.updateStatus("Select a JAR file that contains Java code.\n (Relative paths reference the Eclipse Workspace.)", 1);
            return;
        }
        File file = new File(curJAR);
        if (!file.canRead()) {
            this.updateStatus("JAR file does not exist or can't be read.", 3);
            return;
        }
        if (file.isDirectory() || !file.getName().endsWith(".jar")) {
            this.updateStatus("Select a JAR file that contains Java code.", 1);
            return;
        }
        if (!file.isAbsolute()) {
            this.updateStatus("Relative paths are based on workspace location.", 1);
            return;
        }
        this.jarFile = curJAR;
        this.distribution = curDistro;
        this.target = curTarget;
        this.updateStatus(null, 0);
    }

    private void updateStatus(String message, int type) {
        this.setMessage(message, type);
        this.setPageComplete(message == null);
    }

    public JamaicaVMDistribution getDistribution() {
        return this.distribution;
    }

    public String getTarget() {
        return this.target;
    }

    public String getJarFile() {
        return this.jarFile;
    }

    static class DialogEntry
    extends Composite {
        public DialogEntry(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout(5, false));
        }

        public void setEnabled(boolean state) {
            super.setEnabled(state);
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.setEnabled(state);
                if (c instanceof Composite) {
                    Control[] controlArray2 = ((Composite)c).getChildren();
                    int n3 = controlArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Control d = controlArray2[n4];
                        d.setEnabled(state);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }
}

