/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.DOMUtils;
import com.aicas.jamaica.eclipse.ant_editor.model.ProblemManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ToolOption {
    private final ToolChunk toolChunk;
    public static final String ATTR_ENABLED = "enabled";
    public static final String ATTR_ESCAPE = "escape";
    public static final String ATTR_APPEND = "append";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_NAME = "name";
    private Element optionElement;
    private List<ProblemManager.Problem> problems = new ArrayList<ProblemManager.Problem>();

    public ToolOption(ToolChunk toolChunk, Element optElement) {
        this.toolChunk = toolChunk;
        this.optionElement = optElement;
    }

    public String getValue() {
        return this.optionElement.getAttribute(ATTR_VALUE);
    }

    public void setValue(String value) {
        this.optionElement.setAttribute(ATTR_VALUE, value);
    }

    public boolean getState() {
        boolean res = this.optionElement.getAttribute(ATTR_ENABLED).isEmpty() ? true : Boolean.parseBoolean(this.optionElement.getAttribute(ATTR_ENABLED));
        return res;
    }

    public void setState(boolean state) {
        this.optionElement.setAttribute(ATTR_ENABLED, Boolean.toString(state));
    }

    public boolean getEscape() {
        boolean result = false;
        if (this.toolChunk.isBound()) {
            int verMaj = this.toolChunk.getDistribution().getVersionMajor();
            int verMin = this.toolChunk.getDistribution().getVersionMinor();
            result = verMaj > 8 || verMaj == 8 && verMin >= 5 ? Boolean.parseBoolean(this.optionElement.getAttribute(ATTR_ESCAPE)) : (verMaj == 8 && (verMin == 3 || verMin == 4) ? false : verMaj < 8 && verMaj >= 3 || verMaj == 8 && verMin <= 2);
        }
        return result;
    }

    public void setEscape(boolean escape) {
        if (this.toolChunk.isBound()) {
            int verMaj = this.toolChunk.getDistribution().getVersionMajor();
            int verMin = this.toolChunk.getDistribution().getVersionMinor();
            if (verMaj > 8 || verMaj == 8 && verMin >= 5) {
                this.optionElement.setAttribute(ATTR_ESCAPE, Boolean.toString(escape));
            }
        }
    }

    public boolean hasAppendSyntax() {
        return Boolean.parseBoolean(this.optionElement.getAttribute(ATTR_APPEND));
    }

    public void setAppendSyntax(boolean appendSyntax) {
        this.optionElement.setAttribute(ATTR_APPEND, Boolean.toString(appendSyntax));
    }

    public boolean isValid() {
        return this.problems.isEmpty();
    }

    public boolean isChildOfTree() {
        Node parent = this.optionElement.getParentNode();
        return this.toolChunk.getToolNode().isSameNode(parent);
    }

    public boolean addToTree() {
        boolean res = false;
        Node parent = this.optionElement.getParentNode();
        if (parent == null) {
            String optName;
            if (!this.optionElement.getOwnerDocument().equals(this.toolChunk.getToolNode().getOwnerDocument())) {
                this.optionElement = (Element)this.toolChunk.getToolNode().getOwnerDocument().adoptNode(this.optionElement);
            }
            if (this.toolChunk.options.containsKey(optName = this.getName())) {
                Element oldOpt = this.toolChunk.options.get(optName).getElement();
                oldOpt.getParentNode().replaceChild(this.optionElement, oldOpt);
                res = true;
            } else {
                res = DOMUtils.appendNode(this.toolChunk.getToolNode(), this.optionElement);
            }
        }
        return res;
    }

    public boolean removeFromTree() {
        return DOMUtils.removeNode(this.optionElement);
    }

    public void clearProblems() {
        ProblemManager probman = this.toolChunk.getManager().getProjectFile().getProblemManager();
        for (ProblemManager.Problem p : this.problems) {
            probman.problemSolved(p);
        }
        this.problems.clear();
    }

    public List<ProblemManager.Problem> getProblems() {
        return new ArrayList<ProblemManager.Problem>(this.problems);
    }

    public void setProblem(ProblemManager.Problem problem) {
        this.problems.add(problem);
    }

    public String getName() {
        String optionName = "";
        optionName = this.getElement().getTagName().toLowerCase().equals("option") ? this.getElement().getAttribute(ATTR_NAME) : this.getElement().getTagName();
        return optionName;
    }

    public Element getElement() {
        return this.optionElement;
    }

    public String toString() {
        return "Option:name=" + this.getName() + ":value=" + this.getValue() + ":state=" + this.getState() + ":append=" + this.hasAppendSyntax() + ":valid=" + this.isValid() + ":problems=" + this.getProblems();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getValue() == null ? 0 : this.getValue().hashCode());
        result = 31 * result + (this.getState() ? 1231 : 1237);
        result = 31 * result + (this.getEscape() ? 1231 : 1237);
        result = 31 * result + (this.hasAppendSyntax() ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolOption)) {
            return false;
        }
        ToolOption other = (ToolOption)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.optionElement.getTagName().equals(other.optionElement.getTagName())) {
            return false;
        }
        if (!this.getValue().equals(other.getValue())) {
            return false;
        }
        if (this.optionElement.hasAttribute(ATTR_ENABLED) != other.optionElement.hasAttribute(ATTR_ENABLED)) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        if (this.optionElement.hasAttribute(ATTR_ESCAPE) != other.optionElement.hasAttribute(ATTR_ESCAPE)) {
            return false;
        }
        if (this.getEscape() != other.getEscape()) {
            return false;
        }
        if (this.optionElement.hasAttribute(ATTR_APPEND) != other.optionElement.hasAttribute(ATTR_APPEND)) {
            return false;
        }
        return this.hasAppendSyntax() == other.hasAppendSyntax();
    }
}

