/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.ExecChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.ExecChunkManager;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolChunkManager
extends ModelPartManager<ToolChunk> {
    public ToolChunkManager(ProjectFile projectFile) {
        super(projectFile);
    }

    @Override
    public ToolChunk getTag(String name) {
        return (ToolChunk)super.getTag(name);
    }

    public void addToolChunk(String name, String depends, String taskdefName, Map<String, PossiblyEscapedString> options) throws ModelException {
        ToolChunk tc = this.getTag(name);
        if (tc == null) {
            Element element = this.getProjectFile().getDocument().createElement("target");
            element.setAttribute("name", name);
            element.setAttribute("depends", depends);
            Element newToolTag = this.getProjectFile().getDocument().createElement(taskdefName);
            newToolTag.setAttribute("jamaica", "${jamaica}");
            element.appendChild(newToolTag);
            ToolChunk newChunk = new ToolChunk((Node)element, newToolTag, this);
            newChunk.setTaskdefName(taskdefName);
            for (Map.Entry<String, PossiblyEscapedString> setting : options.entrySet()) {
                newChunk.setOption(setting.getKey(), setting.getValue());
            }
            String echoStr = newChunk.createEchoMessage(newChunk.calcExecutablePath(), newChunk.buildsForHost());
            newChunk.setEchoMessage(echoStr);
            this.setTag(name, newChunk);
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.ADDED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK, name));
        } else {
            tc.setDepends(depends);
            tc.setTaskdefName(taskdefName);
            for (String string : tc.getConfiguredOptions()) {
                tc.removeOption(string);
            }
            for (Map.Entry entry : options.entrySet()) {
                tc.setOption((String)entry.getKey(), (PossiblyEscapedString)entry.getValue());
            }
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK, name));
        }
    }

    public void cloneToolChunk(String sourceName, String newName) throws ModelException {
        ToolChunk oldChunk = this.getTag(sourceName);
        if (oldChunk == null) {
            throw new ModelException(MessageFormat.format(Messages.ToolChunkManager_Source_Jamaica_tool_target___1___is_unknown, sourceName));
        }
        this.addToolChunk(newName, oldChunk.getDepends(), oldChunk.getTaskdefName(), Collections.EMPTY_MAP);
        ToolChunk clonedChunk = this.getTag(newName);
        for (String optionName : oldChunk.getConfiguredOptions()) {
            clonedChunk.setOption(optionName, oldChunk.getOptionValue(optionName), oldChunk.getOptionState(optionName), oldChunk.hasAppendSyntax(optionName));
        }
        ExecChunk ec = this.findExecChunk(sourceName);
        if (ec != null) {
            String clonedName = "launch_" + newName.replaceFirst("build_", "");
            ExecChunkManager ecm = this.getProjectFile().getExecChunkManager();
            if (ecm.containsChunk(clonedName)) {
                int idx = 2;
                while (ecm.containsChunk(String.valueOf(clonedName) + '_' + idx)) {
                    ++idx;
                }
                clonedName = String.valueOf(clonedName) + '_' + idx;
            }
            this.getProjectFile().getExecChunkManager().addExecChunkForToolTarget(clonedName, ec.getDepends(), ec.getArgs(), newName);
        }
    }

    private ExecChunk findExecChunk(String toolChunkName) {
        ExecChunkManager ecm = this.getProjectFile().getExecChunkManager();
        for (String name : ecm.getNames()) {
            ExecChunk ec = ecm.getTag(name);
            if (!toolChunkName.equals(ec.getToolChunkName())) continue;
            return ec;
        }
        return null;
    }

    public void removeToolChunk(String name) {
        if (this.removeChunk(name)) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK, name));
        }
    }

    public void validateToolChunks() {
        List<String> knownToolChunks = this.getNames();
        for (String curTool : knownToolChunks) {
            this.getTag(curTool).revalidate();
        }
    }
}

