/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.model.ConditionTag;
import com.aicas.jamaica.eclipse.ant_editor.model.DOMUtils;
import com.aicas.jamaica.eclipse.ant_editor.model.ExecChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.ExecChunkManager;
import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartManager;
import com.aicas.jamaica.eclipse.ant_editor.model.PlainTargetChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.PlainTargetChunkManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ProblemManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectOpeningTag;
import com.aicas.jamaica.eclipse.ant_editor.model.PropertiesManager;
import com.aicas.jamaica.eclipse.ant_editor.model.PropertyTag;
import com.aicas.jamaica.eclipse.ant_editor.model.Tag;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefManager;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefTag;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunkManager;
import com.aicas.jamaica.eclipse.ant_editor.model.VersionTag;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFile
implements IModelPartChangedListener,
IResourceChangeListener {
    private static Map<IFile, ProjectFile> cache;
    private boolean dirty;
    private boolean stale;
    private boolean usable;
    private IFile file;
    private IDocumentProvider docProvider;
    private IFileEditorInput editorInput;
    private Document document;
    private ProjectOpeningTag projectOpeningTag = null;
    private VersionTag projectVersionTag = null;
    private PropertiesManager propertiesManager;
    private TaskdefManager taskdefManager;
    private ToolChunkManager toolChunkManager;
    private ExecChunkManager execChunkManager;
    private PlainTargetChunkManager plainTargetChunkManager;
    private ProblemManager problemManager;
    private Set<IModelPartChangedListener> listeners;
    private boolean active = true;
    private Object activeLock = new Object();
    IElementChangedListener elementChangedListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            if (event.getType() == 1 && event.getSource().toString().contains("RAW CLASSPATH CHANGED")) {
                ProjectFile.this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.PROJECT, ProjectFile.this.getName()));
            }
        }
    };

    private ProjectFile(IFile file) {
        this.file = file;
        this.listeners = new LinkedHashSet<IModelPartChangedListener>();
        this.propertiesManager = new PropertiesManager(this);
        this.taskdefManager = new TaskdefManager(this);
        this.toolChunkManager = new ToolChunkManager(this);
        this.execChunkManager = new ExecChunkManager(this);
        this.plainTargetChunkManager = new PlainTargetChunkManager(this);
        this.problemManager = new ProblemManager(this);
        this.propertiesManager.addListener(this);
        this.taskdefManager.addListener(this);
        this.toolChunkManager.addListener(this);
        this.execChunkManager.addListener(this);
        this.plainTargetChunkManager.addListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        JavaCore.addElementChangedListener((IElementChangedListener)this.elementChangedListener);
    }

    public static ProjectFile getInstance(IFile file) {
        if (cache.containsKey(file)) {
            return cache.get(file);
        }
        ProjectFile pf = new ProjectFile(file);
        cache.put(file, pf);
        return pf;
    }

    public static void initCache() {
        if (cache == null) {
            cache = new HashMap<IFile, ProjectFile>();
        }
    }

    public static void shutdownCache() {
        if (cache != null) {
            for (ProjectFile pf : cache.values()) {
                pf.dispose();
            }
            cache.clear();
            cache = null;
        }
    }

    private void dispose() {
        if (this.docProvider != null) {
            this.docProvider = null;
            this.editorInput = null;
        }
        if (cache.containsKey(this.getFile())) {
            cache.remove(this.getFile());
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.elementChangedListener);
    }

    public void addListener(IModelPartChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IModelPartChangedListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelPartChanged(ModelPartChangedEvent event) {
        Object object = this.activeLock;
        synchronized (object) {
            if (!this.active) {
                return;
            }
        }
        if (event.getAction() != ModelPartChangedEvent.ActionType.READ_COMPLETE && !event.getElementName().startsWith("PROBLEM")) {
            this.setDirty(true);
        }
        IModelPartChangedListener[] listenerArray = this.listeners.toArray(new IModelPartChangedListener[0]);
        Object lastHop = event.getLastHop();
        IModelPartChangedListener[] iModelPartChangedListenerArray = listenerArray;
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelPartChangedListener listener = iModelPartChangedListenerArray[n2];
            event.setLastHop(this);
            if (!listener.equals(lastHop)) {
                listener.modelPartChanged(event);
            }
            ++n2;
        }
    }

    public void setDocumentProvider(IDocumentProvider provider, IFileEditorInput input) {
        if (provider == null && this.docProvider != null) {
            this.docProvider = null;
            this.editorInput = null;
            this.setStale(true);
            this.dispose();
        } else if (provider != null && this.docProvider == null) {
            if (provider.getDocument((Object)input) == null || !input.getFile().equals((Object)this.file)) {
                throw new IllegalArgumentException(Messages.ProjectFile_Document_provider_does_not_contain_the_IDocument_for_this_ProjectFile__s_IFile);
            }
            this.docProvider = provider;
            this.editorInput = input;
            if (this.getDocument() != null) {
                this.setStale(true);
            }
        } else if (provider != null && this.docProvider != null) {
            if (provider.getDocument((Object)input) == null) {
                throw new IllegalArgumentException(Messages.ProjectFile_Document_provider_does_not_contain_the_IDocument_for_this_ProjectFile__s_IFile);
            }
            this.docProvider = provider;
            this.editorInput = input;
            cache.remove(this.file);
            this.file = input.getFile();
            cache.put(this.file, this);
            this.setStale(true);
        }
    }

    public IFile getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.file.getName();
    }

    Document getDocument() {
        return this.document;
    }

    public IJavaProject getProject() {
        IJavaProject jp = null;
        try {
            IProjectNature pn = this.file.getProject().getNature("org.eclipse.jdt.core.javanature");
            if (pn != null && (jp = JavaCore.create((IProject)this.file.getProject())) == null) {
                AntEditorPlugin.log("Got no java project for ANT build file!");
            }
        }
        catch (CoreException ce) {
            AntEditorPlugin.log(ce);
        }
        return jp;
    }

    public IVMInstall getProjectJRE() {
        IVMInstall retval = null;
        try {
            retval = JavaRuntime.getVMInstall((IJavaProject)this.getProject());
        }
        catch (CoreException e) {
            AntEditorPlugin.log(e);
        }
        return retval;
    }

    public boolean hasJamaicaJRE() {
        return this.getProjectJRE() != null && this.getProjectJRE().getClass().toString().contains("JamaicaVM");
    }

    public String getProjectJRELocation() {
        String retval = null;
        if (this.getProjectJRE() != null) {
            retval = LauncherPlugin.normalize((String)this.getProjectJRE().getInstallLocation().getAbsolutePath());
        }
        return retval;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isStale() {
        return this.stale;
    }

    private void setStale(boolean stale) {
        this.stale = stale;
    }

    public void markStale() {
        this.setStale(true);
    }

    public boolean isUsable() {
        return this.usable;
    }

    private void setUsable(boolean usable) {
        this.usable = usable;
    }

    public boolean shouldRead() {
        return !this.usable || this.stale;
    }

    public PropertiesManager getPropertiesManager() {
        return this.propertiesManager;
    }

    public TaskdefManager getTaskdefManager() {
        return this.taskdefManager;
    }

    public ToolChunkManager getToolChunkManager() {
        return this.toolChunkManager;
    }

    public ExecChunkManager getExecChunkManager() {
        return this.execChunkManager;
    }

    public PlainTargetChunkManager getPlainTargetChunkManager() {
        return this.plainTargetChunkManager;
    }

    public ProblemManager getProblemManager() {
        return this.problemManager;
    }

    public String getName() {
        if (this.isUsable()) {
            return this.projectOpeningTag.getName();
        }
        return "";
    }

    public String getBasedir() {
        if (this.isUsable()) {
            return this.projectOpeningTag.getBasedir();
        }
        return "";
    }

    public String getBasedirPath() {
        Path baseDirPath = new Path(this.getBasedir());
        if (!baseDirPath.isAbsolute()) {
            baseDirPath = this.file.getProject().getFullPath().append((IPath)baseDirPath);
        }
        return AntEditorPlugin.resolve((IPath)baseDirPath);
    }

    public void setBasedir(String basedir) {
        String oldBasedir = this.projectOpeningTag.getBasedir();
        this.projectOpeningTag.setBasedir(basedir);
        if (!oldBasedir.equals(basedir)) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.PROJECT, "basedir"));
        }
    }

    public String getDefaultTarget() {
        if (this.isUsable()) {
            return this.projectOpeningTag.getDefaultTarget();
        }
        return "";
    }

    public void setDefaultTarget(String defaultTarget) {
        String oldDefaultTarget = this.projectOpeningTag.getDefaultTarget();
        this.projectOpeningTag.setDefaultTarget(defaultTarget);
        if (!oldDefaultTarget.equals(defaultTarget)) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.PROJECT, "default"));
        }
    }

    void appendTag(Tag newTag) {
        Element docRoot = this.getDocument().getDocumentElement();
        if (docRoot != null) {
            docRoot.appendChild(newTag.getNode());
        }
    }

    void insertTag(Tag newTag, ModelPartManager<?> manager) {
        String newLine = "\n";
        Element docRoot = this.getDocument().getDocumentElement();
        if (manager instanceof PropertiesManager || manager instanceof TaskdefManager) {
            if (docRoot != null) {
                Node curNode;
                Node lastElement = curNode = docRoot.getFirstChild();
                Node afterLastElement = null;
                while (curNode != null && (curNode.getNodeType() == 8 || curNode.getNodeType() == 3)) {
                    if (curNode.getNodeType() != 3) {
                        lastElement = curNode;
                    }
                    curNode = curNode.getNextSibling();
                }
                Node node = afterLastElement = lastElement != null ? lastElement.getNextSibling() : null;
                if (manager instanceof PropertiesManager) {
                    docRoot.insertBefore(this.getDocument().createTextNode(String.valueOf(newLine) + "  "), afterLastElement);
                    docRoot.insertBefore(newTag.getNode(), afterLastElement);
                } else if (manager instanceof TaskdefManager) {
                    while (curNode != null && (curNode.getNodeType() == 1 && "property".equals(curNode.getNodeName()) || curNode.getNodeType() == 3 || curNode.getNodeType() == 8)) {
                        if (curNode.getNodeType() != 3) {
                            lastElement = curNode;
                        }
                        curNode = curNode.getNextSibling();
                    }
                    afterLastElement = lastElement != null ? lastElement.getNextSibling() : null;
                    docRoot.insertBefore(this.getDocument().createTextNode(String.valueOf(newLine) + "  "), afterLastElement);
                    docRoot.insertBefore(newTag.getNode(), afterLastElement);
                }
            }
        } else if (docRoot != null) {
            Node last = docRoot.getLastChild();
            while (last != null && (last.getNodeType() == 3 || last.getNodeType() == 8)) {
                last = last.getPreviousSibling();
            }
            last = last != null ? last.getNextSibling() : null;
            docRoot.insertBefore(this.getDocument().createTextNode(String.valueOf(newLine) + newLine + "  "), last);
            docRoot.insertBefore(newTag.getNode(), last);
        }
    }

    void removeTag(Tag t) {
        Node tagParent = t.getNode().getParentNode();
        if (tagParent != null) {
            Node prevSib = t.getNode().getPreviousSibling();
            if (prevSib != null && prevSib.getNodeType() == 3) {
                tagParent.removeChild(prevSib);
            }
            tagParent.removeChild(t.getNode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void read() throws ModelException {
        this.setUsable(false);
        String input = null;
        if (this.docProvider != null) {
            input = this.docProvider.getDocument((Object)this.editorInput).get();
        } else {
            try {
                BufferedReader contents = new BufferedReader(new InputStreamReader(this.file.getContents()));
                StringBuilder inputBuilder = new StringBuilder();
                String line = null;
                while ((line = contents.readLine()) != null) {
                    inputBuilder.append(line);
                }
                input = inputBuilder.toString();
            }
            catch (IOException ioe) {
                throw new ModelException(Messages.ProjectFile_Could_not_read_the_contents_of_the_underlying_file, ioe);
            }
            catch (CoreException ce) {
                throw new ModelException(Messages.ProjectFile_Could_not_access_the_contents_of_the_underlying_file, ce);
            }
        }
        Object ce = this.activeLock;
        synchronized (ce) {
            this.active = false;
        }
        try {
            this.doRead(input);
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            throw new ModelException(Messages.ProjectFile_The_Ant_buildfile_structure_is_invalid, sioobe);
        }
        this.setUsable(true);
        this.setDirty(false);
        this.setStale(false);
        Object object = this.activeLock;
        synchronized (object) {
            this.active = true;
        }
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.READ_COMPLETE, ModelPartChangedEvent.ModelPartType.PROJECT, this.getName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doRead(String input) throws ModelException {
        this.propertiesManager.doClear();
        this.taskdefManager.doClear();
        this.toolChunkManager.doClear();
        this.execChunkManager.doClear();
        this.plainTargetChunkManager.doClear();
        this.problemManager.doClear();
        try {
            this.document = DOMUtils.getDocument(input);
        }
        catch (Exception e) {
            throw new ModelException(e);
        }
        Element docRoot = this.document.getDocumentElement();
        List<Node> comments = DOMUtils.findNodes(this.document, (short)8);
        for (Node comment : comments) {
            if (!VersionTag.VERSION_TAG_PATTERN.matcher(comment.getNodeValue()).find()) continue;
            this.projectVersionTag = new VersionTag(comment);
            break;
        }
        if (this.projectVersionTag == null) {
            throw new ModelException("XML file was not created with the Jamaica Ant Editor.");
        }
        TagMaker tagMaker = new TagMaker(){

            public void createTaskdefTag(Node node) throws ModelException {
                TaskdefTag taskTag = new TaskdefTag(node, ProjectFile.this.taskdefManager);
                String taskClass = taskTag.getClassname();
                if (ToolType.valueOfClassname((String)taskClass) != null) {
                    ProjectFile.this.taskdefManager.setTag(taskTag.getName(), taskTag);
                }
            }

            public void createPropertyTag(Node node) throws ModelException {
                PropertyTag propTag = new PropertyTag(node, ProjectFile.this.propertiesManager);
                ProjectFile.this.propertiesManager.setTag(propTag.getName(), propTag);
            }

            public void createTargetTag(Node node) throws ModelException {
                List<String> taskNames = ProjectFile.this.taskdefManager.getNames();
                boolean foundTool = false;
                boolean foundExec = false;
                List<Node> targetElements = DOMUtils.findNodes(node, (short)1);
                int j = 0;
                while (j < targetElements.size() && !foundTool && !foundExec) {
                    Element subEle = (Element)targetElements.get(j);
                    if (taskNames.contains(subEle.getTagName()) && ProjectFile.this.taskdefManager.getToolType(subEle.getTagName()) != null) {
                        foundTool = true;
                        ToolChunk newToolChunk = new ToolChunk(node, subEle, ProjectFile.this.toolChunkManager);
                        ProjectFile.this.toolChunkManager.setTag(newToolChunk.getName(), newToolChunk);
                    } else if (subEle.getTagName().equals("exec")) {
                        foundExec = true;
                        ExecChunk newExecChunk = new ExecChunk(node, subEle, ProjectFile.this.execChunkManager);
                        ProjectFile.this.execChunkManager.setTag(newExecChunk.getName(), newExecChunk);
                    } else if (subEle.getTagName().equals("taskdef")) {
                        this.createTaskdefTag(subEle);
                    }
                    ++j;
                }
                if (!foundTool && !foundExec) {
                    PlainTargetChunk ptc = new PlainTargetChunk(node, ProjectFile.this.plainTargetChunkManager);
                    ProjectFile.this.plainTargetChunkManager.setTag(ptc.getName(), ptc);
                }
            }

            public void createConditionTag(Node node) throws ModelException {
                ConditionTag condTag = new ConditionTag(node, ProjectFile.this.propertiesManager);
                ProjectFile.this.propertiesManager.setTag(condTag.getName(), condTag);
            }
        };
        Node curNode = docRoot;
        boolean doneParsing = false;
        boolean foundNextElement = false;
        LinkedHashSet<String> parsableTags = new LinkedHashSet<String>();
        parsableTags.add("project");
        parsableTags.add("property");
        parsableTags.add("taskdef");
        parsableTags.add("target");
        parsableTags.add("condition");
        while (!doneParsing) {
            if (curNode.getNodeType() == 1 && parsableTags.contains(curNode.getNodeName())) {
                String tagName = curNode.getNodeName();
                if (curNode.equals(docRoot)) {
                    if (!"project".equals(tagName)) throw new ModelException(Messages.ProjectFile_No____project___tag_found);
                    this.projectOpeningTag = new ProjectOpeningTag(docRoot);
                } else if ("property".equals(tagName)) {
                    tagMaker.createPropertyTag(curNode);
                } else if ("condition".equals(tagName)) {
                    tagMaker.createConditionTag(curNode);
                } else if ("taskdef".equals(tagName)) {
                    tagMaker.createTaskdefTag(curNode);
                } else if ("target".equals(tagName)) {
                    tagMaker.createTargetTag(curNode);
                }
            }
            foundNextElement = false;
            do {
                if (curNode.equals(docRoot)) {
                    if (curNode.hasChildNodes()) {
                        if ((curNode = curNode.getFirstChild()).getNodeType() != 1) continue;
                        foundNextElement = true;
                        continue;
                    }
                    doneParsing = true;
                    continue;
                }
                if (curNode.getNextSibling() != null) {
                    if ((curNode = curNode.getNextSibling()).getNodeType() != 1) continue;
                    foundNextElement = true;
                    continue;
                }
                if (curNode.getParentNode() != null) {
                    if (!(curNode = curNode.getParentNode()).equals(docRoot)) continue;
                    doneParsing = true;
                    continue;
                }
                doneParsing = true;
            } while (!foundNextElement && !doneParsing);
        }
    }

    public synchronized void write() throws CoreException {
        if (this.docProvider != null) {
            this.docProvider.getDocument((Object)this.editorInput).set(this.doWrite(0));
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.doWrite(0).getBytes());
            this.file.setContents((InputStream)bais, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        this.setDirty(false);
        this.setStale(false);
    }

    private String doWrite(int indent) throws CoreException {
        try {
            return DOMUtils.serializeDocument(this.document);
        }
        catch (Exception e) {
            Status stat = new Status(4, "com.aicas.jamaica.eclipse.ant_editor", "Could not serialize the DOM tree.", (Throwable)e);
            throw new CoreException((IStatus)stat);
        }
    }

    @Override
    public void modelPartChanged(ModelPartChangedEvent mpcEvent) {
        String projectDefaultTarget;
        String eleName;
        if (mpcEvent.getAction().equals((Object)ModelPartChangedEvent.ActionType.REMOVED) && (mpcEvent.getPart().equals((Object)ModelPartChangedEvent.ModelPartType.EXEC_CHUNK) || mpcEvent.getPart().equals((Object)ModelPartChangedEvent.ModelPartType.TOOL_CHUNK) || mpcEvent.getPart().equals((Object)ModelPartChangedEvent.ModelPartType.TARGET_CHUNK)) && (eleName = mpcEvent.getElementName()).equals(projectDefaultTarget = this.projectOpeningTag.getDefaultTarget())) {
            this.projectOpeningTag.setDefaultTarget("");
        }
        this.fireModelPartChanged(mpcEvent);
    }

    private boolean fileAffected(IResourceDelta delta) {
        assert (delta != null);
        if (delta.getResource().equals((Object)this.file)) {
            return true;
        }
        boolean myResult = false;
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(4);
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            if (myResult |= this.fileAffected(childDelta)) break;
            ++n2;
        }
        return myResult;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.docProvider != null) {
            return;
        }
        if (event.getDelta() == null || event.getDelta().getKind() != 4) {
            return;
        }
        if (this.fileAffected(event.getDelta())) {
            this.setStale(true);
        }
    }

    ProjectFile() {
        this.listeners = new LinkedHashSet<IModelPartChangedListener>();
        this.propertiesManager = new PropertiesManager(this);
        this.taskdefManager = new TaskdefManager(this);
        this.toolChunkManager = new ToolChunkManager(this);
        this.execChunkManager = new ExecChunkManager(this);
        this.plainTargetChunkManager = new PlainTargetChunkManager(this);
        this.problemManager = new ProblemManager(this);
        this.propertiesManager.addListener(this);
        this.taskdefManager.addListener(this);
        this.toolChunkManager.addListener(this);
        this.execChunkManager.addListener(this);
        this.plainTargetChunkManager.addListener(this);
    }

    static interface TagMaker {
        public void createPropertyTag(Node var1) throws ModelException;

        public void createTaskdefTag(Node var1) throws ModelException;

        public void createTargetTag(Node var1) throws ModelException;

        public void createConditionTag(Node var1) throws ModelException;
    }
}

