/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemManager {
    public static final String JAMAICA_PROBLEM = "com.aicas.jamaica.eclipse.ant_editor.problemmarker";
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private ProjectFile projectFile;
    private List<Problem> currentProblems;
    private WorkspaceJob updateMarkersJob = new WorkspaceJob(Messages.ProblemManager_update_markers_job_name){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            ArrayList probs = new ArrayList(ProblemManager.this.currentProblems.size());
            List list = ProblemManager.this.currentProblems;
            synchronized (list) {
                probs.addAll(ProblemManager.this.currentProblems);
            }
            List<IMarker> currentMarkers = Arrays.asList(ProblemManager.this.projectFile.getFile().findMarkers(ProblemManager.JAMAICA_PROBLEM, false, 0));
            ArrayList<IMarker> obsoleteMarkers = new ArrayList<IMarker>();
            obsoleteMarkers.addAll(currentMarkers);
            for (Problem p : probs) {
                if (p.getMarker() != null && currentMarkers.contains(p.getMarker())) {
                    ProblemManager.this.updateMarker(p.getMarker(), p);
                    obsoleteMarkers.remove(p.getMarker());
                    continue;
                }
                if (p.getMarker() != null) continue;
                IMarker newMarker = ProblemManager.this.projectFile.getFile().createMarker(ProblemManager.JAMAICA_PROBLEM);
                p.setMarker(newMarker);
                ProblemManager.this.updateMarker(newMarker, p);
            }
            for (IMarker m : obsoleteMarkers) {
                m.delete();
            }
            monitor.done();
            return new Status(0, "com.aicas.jamaica.eclipse.ant_editor", 0, "", null);
        }
    };
    private WorkspaceJob removeAllMarkersJob = new WorkspaceJob(Messages.ProblemManager_remove_markers_job_name){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            ArrayList probs = new ArrayList(ProblemManager.this.currentProblems.size());
            List list = ProblemManager.this.currentProblems;
            synchronized (list) {
                probs.addAll(ProblemManager.this.currentProblems);
            }
            if (ProblemManager.this.projectFile.getFile().exists()) {
                List<IMarker> currentMarkers = Arrays.asList(ProblemManager.this.projectFile.getFile().findMarkers(ProblemManager.JAMAICA_PROBLEM, false, 0));
                for (Problem p : probs) {
                    if (p.getMarker() == null || !currentMarkers.contains(p.getMarker())) continue;
                    p.getMarker().delete();
                    p.setMarker(null);
                }
            } else {
                AntEditorPlugin.log(String.valueOf(ProblemManager.this.projectFile.getFile().toString()) + " could not be found");
            }
            monitor.done();
            return new Status(0, "com.aicas.jamaica.eclipse.ant_editor", 0, "", null);
        }
    };

    public ProblemManager(ProjectFile parent) {
        this.projectFile = parent;
        this.currentProblems = Collections.synchronizedList(new ArrayList());
    }

    public Problem reportProblem(String location, String message, int severity) {
        return this.reportProblem(location, message, severity, -1, -1, null);
    }

    public Problem reportProblem(String location, String message, int severity, Problem oldProblem) {
        return this.reportProblem(location, message, severity, -1, -1, oldProblem);
    }

    public Problem reportProblem(String location, String message, int severity, int start, int offset) {
        return this.reportProblem(location, message, severity, start, offset, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem reportProblem(String location, String message, int severity, int start, int offset, Problem oldProblem) {
        Problem newProblem = null;
        if (oldProblem == null) {
            newProblem = new Problem(location, message, severity, start, offset);
            List<Problem> list = this.currentProblems;
            synchronized (list) {
                if (!this.currentProblems.contains(newProblem)) {
                    this.currentProblems.add(newProblem);
                }
            }
        }
        newProblem = oldProblem;
        if (!this.currentProblems.contains(oldProblem)) {
            List<Problem> list = this.currentProblems;
            synchronized (list) {
                this.currentProblems.add(newProblem);
            }
        }
        oldProblem.setLocation(location);
        oldProblem.setMessage(message);
        oldProblem.setSeverity(severity);
        oldProblem.setStart(start);
        oldProblem.setOffset(offset);
        this.updateMarkersJob.schedule();
        return newProblem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void problemSolved(Problem p) {
        boolean wasKnown = false;
        List<Problem> list = this.currentProblems;
        synchronized (list) {
            wasKnown = this.currentProblems.remove(p);
        }
        if (wasKnown) {
            this.updateMarkersJob.schedule();
        }
    }

    public List<Problem> getProblems() {
        return this.currentProblems;
    }

    public void showMarkers() {
        this.updateMarkersJob.schedule();
    }

    public void hideMarkers() {
        this.removeAllMarkersJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClear() {
        List<Problem> list = this.currentProblems;
        synchronized (list) {
            this.currentProblems.clear();
        }
        this.updateMarkersJob.schedule();
    }

    private void updateMarker(IMarker marker, Problem problem) throws CoreException {
        marker.setAttribute("severity", problem.getSeverity());
        marker.setAttribute("message", (Object)problem.getMessage());
        if (problem.getStart() > -1 && problem.getOffset() > -1) {
            marker.setAttribute("charStart", problem.getStart());
            marker.setAttribute("charEnd", problem.getStart() + problem.getOffset());
        }
        marker.setAttribute("transient", true);
        marker.setAttribute("location", (Object)problem.getLocation());
    }

    public static class Problem {
        private int severity;
        private int start;
        private int offset;
        private String message;
        private String location;
        private IMarker marker;

        public Problem(String location, String message, int severity, int start, int offset) {
            this.location = location;
            this.message = message;
            this.severity = severity;
            this.start = start;
            this.offset = offset;
        }

        public IMarker getMarker() {
            return this.marker;
        }

        public void setMarker(IMarker marker) {
            this.marker = marker;
        }

        public int getSeverity() {
            return this.severity;
        }

        public int getStart() {
            return this.start;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLocation() {
            return this.location;
        }

        public void setSeverity(int severity) {
            this.severity = severity;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof Problem)) {
                return false;
            }
            Problem other = (Problem)o;
            return this.location.equals(other.location) && this.message.equals(other.message) && this.offset == other.offset && this.severity == other.severity && this.start == other.start;
        }

        public String toString() {
            String severityString = null;
            switch (this.severity) {
                case 1: {
                    severityString = Messages.ProblemManager_Warning;
                    break;
                }
                case 2: {
                    severityString = Messages.ProblemManager_Error;
                    break;
                }
                default: {
                    severityString = Messages.ProblemManager_Unknown;
                }
            }
            if (this.start != -1 && this.offset != -1) {
                return MessageFormat.format(Messages.ProblemManager_toString_format_with_positions, severityString, this.message, this.location, this.start, this.start + this.offset);
            }
            return MessageFormat.format(Messages.ProblemManager_toString_format_simple, severityString, this.message, this.location);
        }
    }
}

