/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import com.aicas.jamaica.eclipse.core.ToolType;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class OptionValidator {
    public abstract String validate(PossiblyEscapedString var1);

    public static OptionValidator getValidator(final String optname, final ToolChunk tchunk) {
        ToolType tooltype = tchunk.getTaskdef().getToolType();
        if (tooltype.equals((Object)ToolType.JAMAICA) || tooltype.equals((Object)ToolType.JAMAICA_INTERNAL)) {
            if (optname.equals("agentlib")) {
                return new OptionValidator(){
                    private final String AGENT_AND_TRANSPORT_DEFINITION = "BuiltInAgent=transport=dt_socket";
                    private final Pattern OPT_VALIDATION_REGEX = Pattern.compile("BuiltInAgent=transport=dt_socket,server=([yn]),suspend=([yn]),address=([\\p{Alnum}\\.-]+:|.{0})([0-9]{1,5})");

                    public String validate(PossiblyEscapedString value) {
                        return this.OPT_VALIDATION_REGEX.matcher(value.getString()).matches() ? null : MessageFormat.format(Messages.OptionValidator_Value___1___does_not_match_the_required_regular_expression, value.getString());
                    }
                };
            }
            if (optname.equals("resource")) {
                return new OptionValidator(){

                    public String validate(PossiblyEscapedString optionValue) {
                        String result = null;
                        String baseDirPath = tchunk.getManager().getProjectFile().getBasedirPath();
                        IToolOptions toolOpts = tchunk.getToolOptions();
                        List resSeps = toolOpts.getTupleSeparators(optname);
                        List cpSeps = toolOpts.getTupleSeparators("classpath");
                        List resEntries = toolOpts.split(optionValue, resSeps);
                        PossiblyEscapedString cpVal = tchunk.getOptionValueResolved("classpath");
                        List cpEntries = toolOpts.split(cpVal, cpSeps);
                        for (PossiblyEscapedString resEntrie : resEntries) {
                            if (resEntrie == null || resEntrie.getString().isEmpty()) continue;
                            IPath resourcePath = new Path(toolOpts.unescape(resEntrie)).makeRelative();
                            boolean matchedClasspath = false;
                            int i = 0;
                            while (i < cpEntries.size() && !matchedClasspath) {
                                if (cpEntries.get(i) != null && !((PossiblyEscapedString)cpEntries.get(i)).getString().isEmpty()) {
                                    Path classPath = new Path(toolOpts.unescape((PossiblyEscapedString)cpEntries.get(i)));
                                    if (!classPath.isAbsolute()) {
                                        classPath = new Path(String.valueOf(baseDirPath) + File.separator + classPath);
                                    }
                                    if (classPath.toFile().isDirectory()) {
                                        if (new Path(classPath + File.separator + resourcePath).toFile().isFile()) {
                                            matchedClasspath = true;
                                        }
                                    } else if (classPath.toFile().isFile()) {
                                        try {
                                            ZipFile zipFile = new ZipFile(classPath.toFile());
                                            ZipEntry zipEntry = zipFile.getEntry(resourcePath.toString());
                                            if (zipEntry != null) {
                                                matchedClasspath = true;
                                            }
                                            zipFile.close();
                                        }
                                        catch (ZipException zipFile) {
                                        }
                                        catch (IOException ioe) {
                                            AntEditorPlugin.log(ioe);
                                        }
                                    }
                                }
                                ++i;
                            }
                            if (matchedClasspath) continue;
                            if (result == null) {
                                result = "";
                            }
                            if (!result.isEmpty()) {
                                result = result.concat(", ");
                            }
                            result = result.concat("'" + resourcePath.toString() + "'");
                        }
                        if (result != null) {
                            result = "The following files are not in the Builder classpath: " + result;
                        }
                        return result;
                    }
                };
            }
            return null;
        }
        return null;
    }
}

