/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import com.aicas.jamaica.eclipse.ant_editor.editors.UsedOptionTreeElement;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class UsedOptionTreeContentProvider
implements ITreeContentProvider {
    private Map<String, List<String>> visibleOptionMap;
    private ToolChunk toolChunk;

    UsedOptionTreeContentProvider() {
    }

    private void updateOptions() {
        this.visibleOptionMap = new LinkedHashMap<String, List<String>>();
        IToolOptions toolOptions = this.toolChunk.getToolOptions();
        ArrayList<String> optionsToDisplay = new ArrayList<String>();
        optionsToDisplay.addAll(this.toolChunk.getConfiguredOptions());
        for (String string : optionsToDisplay) {
            String groupName = toolOptions.getGroup(string);
            if (groupName == null) {
                groupName = "<unknown options>";
            }
            if (!this.visibleOptionMap.containsKey(groupName)) {
                this.visibleOptionMap.put(groupName, new ArrayList());
            }
            this.visibleOptionMap.get(groupName).add(string);
        }
        for (List list : this.visibleOptionMap.values()) {
            Collections.sort(list);
        }
    }

    public Object[] getChildren(Object parentElement) {
        Object[] retval = new Object[]{};
        UsedOptionTreeElement parentTreeEle = (UsedOptionTreeElement)parentElement;
        ArrayList<UsedOptionTreeElement> childEleList = new ArrayList<UsedOptionTreeElement>();
        if (this.visibleOptionMap.containsKey(parentTreeEle.name_)) {
            List<String> optList = this.visibleOptionMap.get(parentTreeEle.name_);
            for (String opt : optList) {
                UsedOptionTreeElement childTreeEle = new UsedOptionTreeElement(UsedOptionTreeElement.ElementType.OPTION, opt, this.toolChunk);
                childEleList.add(childTreeEle);
            }
            retval = childEleList.toArray();
        } else if (parentTreeEle.type_.equals((Object)UsedOptionTreeElement.ElementType.OPTION) && "XdefineProperty".equals(parentTreeEle.name_)) {
            PossiblyEscapedString optValue = this.toolChunk.getOptionValue(parentTreeEle.name_);
            List optSeps = this.toolChunk.getToolOptions().getTupleSeparators(parentTreeEle.name_);
            if (optValue != null && optSeps != null && !optSeps.isEmpty()) {
                List props = this.toolChunk.getToolOptions().split(optValue, optSeps);
                for (PossiblyEscapedString prop : props) {
                    if (prop.getString().isEmpty()) continue;
                    childEleList.add(new UsedOptionTreeElement(UsedOptionTreeElement.ElementType.PROPERTY, prop.getString(), this.toolChunk));
                }
            }
            retval = childEleList.toArray();
        }
        return retval;
    }

    public Object getParent(Object element) {
        UsedOptionTreeElement retval = null;
        String eleName = null;
        UsedOptionTreeElement.ElementType eleType = null;
        if (element instanceof UsedOptionTreeElement) {
            UsedOptionTreeElement te = (UsedOptionTreeElement)element;
            eleName = te.name_;
            eleType = te.type_;
        } else if (element instanceof String) {
            eleName = (String)element;
        }
        if (this.toolChunk.getToolOptions().getAvailableOptions().contains(eleName)) {
            String groupName = this.toolChunk.getToolOptions().getGroup(eleName);
            retval = new UsedOptionTreeElement(UsedOptionTreeElement.ElementType.GROUP, groupName, this.toolChunk);
        } else if (UsedOptionTreeElement.ElementType.PROPERTY.equals((Object)eleType)) {
            retval = new UsedOptionTreeElement(UsedOptionTreeElement.ElementType.OPTION, "XdefineProperty", this.toolChunk);
        }
        return retval;
    }

    public boolean hasChildren(Object element) {
        boolean retval = false;
        if (!(element instanceof UsedOptionTreeElement)) {
            return retval;
        }
        UsedOptionTreeElement te = (UsedOptionTreeElement)element;
        if (this.visibleOptionMap.containsKey(te.name_)) {
            retval = true;
        } else {
            for (List<String> optList : this.visibleOptionMap.values()) {
                if (!optList.contains(te.name_)) continue;
                if ("XdefineProperty".equals(te.name_)) {
                    String optVal = this.toolChunk.getOptionValue(te.name_).getString();
                    if (optVal != null && !optVal.isEmpty()) {
                        retval = true;
                        continue;
                    }
                    retval = false;
                    continue;
                }
                retval = false;
            }
        }
        return retval;
    }

    public Object[] getElements(Object inputElement) {
        this.updateOptions();
        ArrayList<String> usedOptGroups = new ArrayList<String>(this.visibleOptionMap.keySet());
        Collections.sort(usedOptGroups);
        ArrayList<UsedOptionTreeElement> elementList = new ArrayList<UsedOptionTreeElement>();
        for (String groupName : usedOptGroups) {
            UsedOptionTreeElement te = new UsedOptionTreeElement(UsedOptionTreeElement.ElementType.GROUP, groupName, this.toolChunk);
            elementList.add(te);
        }
        return elementList.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ToolChunk) {
            this.toolChunk = (ToolChunk)newInput;
            this.updateOptions();
        }
    }

    public void dispose() {
        this.visibleOptionMap = null;
        this.toolChunk = null;
    }
}

