/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.ant_launching.AntLaunchUtils;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.InfoPopUp;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.OptionValueEditorDialog;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.ToolArgFileDialog;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.ToolEnvironmentDialog;
import com.aicas.jamaica.eclipse.ant_editor.editors.JamaicaAntEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.Messages;
import com.aicas.jamaica.eclipse.ant_editor.editors.OptionFilteredTree;
import com.aicas.jamaica.eclipse.ant_editor.editors.UnusedOptionTreeContentProvider;
import com.aicas.jamaica.eclipse.ant_editor.editors.UsedOptionTreeContentProvider;
import com.aicas.jamaica.eclipse.ant_editor.editors.UsedOptionTreeElement;
import com.aicas.jamaica.eclipse.ant_editor.editors.UsedOptsNameColLabelProvider;
import com.aicas.jamaica.eclipse.ant_editor.editors.UsedOptsValueColLabelProvider;
import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.PropertiesManager;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import com.aicas.jamaica.eclipse.core.ToolType;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class OptionsPage
extends FormPage
implements IModelPartChangedListener,
IPropertyListener {
    public static final String OPTIONS_PAGE_ID_PREFIX = "com.aicas.jamaica.eclipse.ant_editor.editors.OptionsPage_";
    private JamaicaAntEditor editor;
    private OptionValueEditorDialog editDialog;
    private String antTargetName;
    private ToolChunk toolchunk;
    private PropertiesManager propertiesManager;
    private TaskdefManager taskdefManager;
    private IFile buildFile;
    private ScrolledForm optionsForm;
    private SashForm optionSash;
    private OptionFilteredTree allOptsTree;
    private OptionFilteredTree setOptsTree;
    private Button showNormalBox;
    private Button showExtendedBox;
    private Button addSelectedButton;
    private Button removeSelectedButton;
    private Button envButton;
    private Button argfileButton;
    private FormToolkit toolkit;
    private StyledText antTargetNameText;
    private StyledText antTargetDependsText;
    private static final int OFFSET_NORMAL = 6;

    public OptionsPage(JamaicaAntEditor parent, String antTargetName) {
        super((FormEditor)parent, OPTIONS_PAGE_ID_PREFIX + antTargetName, antTargetName);
        this.editor = parent;
        this.antTargetName = antTargetName;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.toolkit = managedForm.getToolkit();
        this.optionsForm = managedForm.getForm();
        Composite formbody = this.optionsForm.getBody();
        this.toolkit.decorateFormHeading(this.optionsForm.getForm());
        this.optionsForm.setText(Messages.OptionsPage_header_prefix);
        this.optionsForm.setImage(JamaicaAntEditor.getResourceManager().createImage(JamaicaAntEditor.PluginImage.IMG_OPTION_PAGE_HEADER.getImgDesc()));
        GridLayout bodyLayout = new GridLayout(1, true);
        bodyLayout.verticalSpacing = 0;
        bodyLayout.horizontalSpacing = 0;
        bodyLayout.marginHeight = 0;
        bodyLayout.marginWidth = 0;
        formbody.setLayout((Layout)bodyLayout);
        Composite mainContainer = this.toolkit.createComposite(formbody, 0);
        GridData gdata = GridDataFactory.fillDefaults().grab(true, true).hint(formbody.getClientArea().width, formbody.getClientArea().height).create();
        mainContainer.setLayoutData((Object)gdata);
        this.optionsForm.setMinSize(0, 0);
        GridLayout mainContainerLayout = new GridLayout(1, true);
        mainContainerLayout.marginWidth = 6;
        mainContainerLayout.marginHeight = 6;
        mainContainerLayout.horizontalSpacing = 6;
        mainContainerLayout.verticalSpacing = 6;
        mainContainer.setLayout((Layout)mainContainerLayout);
        this.createTargetSection(mainContainer);
        this.createActionsSection(mainContainer);
        this.optionSash = new SashForm(mainContainer, 65792);
        this.toolkit.adapt((Composite)this.optionSash);
        this.optionSash.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createAllOptSection((Composite)this.optionSash);
        this.createSetOptSection((Composite)this.optionSash);
        this.optionSash.setWeights(new int[]{34, 66});
        try {
            Method meth = this.optionsForm.getClass().getMethod("reskin", Integer.TYPE);
            meth.invoke((Object)this.optionsForm, 1);
        }
        catch (NoSuchMethodException meth) {
        }
        catch (Exception e) {
            AntEditorPlugin.log(e);
        }
        if (this.toolchunk != null) {
            this.updateUI();
        }
    }

    private void createSetOptSection(Composite parent) {
        Section setOptSection = this.toolkit.createSection(parent, 256);
        setOptSection.setText(Messages.OptionsPage_used_options);
        Composite setOptsCompo = this.toolkit.createComposite((Composite)setOptSection, 0);
        setOptsCompo.setLayout((Layout)new FormLayout());
        setOptSection.setClient((Control)setOptsCompo);
        this.setOptsTree = new OptionFilteredTree(setOptsCompo, 68354, new PatternFilter(), true);
        this.setOptsTree.setInitialText(Messages.OptionsPage_search_for);
        FormData setOptsTreeLayoutData = new FormData(350, 375);
        setOptsTreeLayoutData.left = new FormAttachment(0, 0);
        setOptsTreeLayoutData.top = new FormAttachment(0, 6);
        setOptsTreeLayoutData.bottom = new FormAttachment(100, 0);
        setOptsTreeLayoutData.right = new FormAttachment(100, 0);
        this.setOptsTree.setLayoutData(setOptsTreeLayoutData);
        TreeViewer setOptsTreeViewer = this.setOptsTree.getViewer();
        setOptsTreeViewer.getTree().setHeaderVisible(true);
        setOptsTreeViewer.getTree().setLinesVisible(true);
        TreeViewerColumn tvc = new TreeViewerColumn(setOptsTreeViewer, 0);
        tvc.getColumn().setText(Messages.OptionsPage_name);
        tvc.setLabelProvider((CellLabelProvider)new UsedOptsNameColLabelProvider());
        TreeViewerColumn tvc2 = new TreeViewerColumn(setOptsTreeViewer, 0);
        tvc2.getColumn().setText(Messages.OptionsPage_value);
        tvc2.setLabelProvider((CellLabelProvider)new UsedOptsValueColLabelProvider());
        setOptsTreeViewer.setContentProvider((IContentProvider)new UsedOptionTreeContentProvider());
        setOptsTreeViewer.setAutoExpandLevel(-1);
        setOptsTreeViewer.setInput((Object)this.toolchunk);
        setOptsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int numSelected = ((IStructuredSelection)event.getSelection()).size();
                OptionsPage.this.removeSelectedButton.setEnabled(numSelected > 0);
            }
        });
        setOptsTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeViewer setOptsTreeViewer = OptionsPage.this.setOptsTree.getViewer();
                ISelection select = setOptsTreeViewer.getSelection();
                if (!select.isEmpty() && select instanceof IStructuredSelection) {
                    IStructuredSelection strucSelec = (IStructuredSelection)select;
                    Object first = strucSelec.getFirstElement();
                    if (setOptsTreeViewer.isExpandable(first)) {
                        boolean expState = setOptsTreeViewer.getExpandedState(first);
                        setOptsTreeViewer.setExpandedState(first, !expState);
                    } else if (strucSelec.size() == 1 && first instanceof UsedOptionTreeElement) {
                        UsedOptionTreeElement treeEle = (UsedOptionTreeElement)first;
                        if (treeEle.type_.equals((Object)UsedOptionTreeElement.ElementType.PROPERTY)) {
                            OptionsPage.this.editOption("XdefineProperty");
                        } else {
                            OptionsPage.this.editOption(treeEle.name_);
                        }
                    }
                }
            }
        });
        this.removeSelectedButton.setEnabled(((IStructuredSelection)setOptsTreeViewer.getSelection()).size() > 0);
        final OptionTreeMenuSelectionAdapter setOptsAdapter = new OptionTreeMenuSelectionAdapter(this.setOptsTree);
        final Menu setOptsContextMenu = new Menu((Control)setOptsTreeViewer.getTree());
        setOptsContextMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] menuItemArray = setOptsContextMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem menuItem = menuItemArray[n2];
                    menuItem.dispose();
                    ++n2;
                }
                TreeItem[] items = OptionsPage.this.setOptsTree.getViewer().getTree().getSelection();
                if (items.length == 1) {
                    if (items[0].getParentItem() == null) {
                        if (OptionsPage.this.setOptsTree.getViewer().isExpandable((Object)new UsedOptionTreeElement(UsedOptionTreeElement.ElementType.GROUP, items[0].getText(), OptionsPage.this.toolchunk))) {
                            if (items[0].getExpanded()) {
                                MenuItem collapseItem = new MenuItem(setOptsContextMenu, 8);
                                collapseItem.setText(Messages.OptionsPage_collapse);
                                collapseItem.addSelectionListener((SelectionListener)setOptsAdapter);
                            } else {
                                MenuItem expandItem = new MenuItem(setOptsContextMenu, 8);
                                expandItem.setText(Messages.OptionsPage_expand);
                                expandItem.addSelectionListener((SelectionListener)setOptsAdapter);
                            }
                        }
                    } else {
                        MenuItem editItem = new MenuItem(setOptsContextMenu, 8);
                        editItem.setText(Messages.OptionsPage_edit);
                        editItem.addSelectionListener((SelectionListener)setOptsAdapter);
                        MenuItem removeItem = new MenuItem(setOptsContextMenu, 8);
                        removeItem.setText(Messages.OptionsPage_remove);
                        removeItem.addSelectionListener((SelectionListener)setOptsAdapter);
                        MenuItem helpItem = new MenuItem(setOptsContextMenu, 8);
                        helpItem.setText(Messages.OptionsPage_help);
                        helpItem.addSelectionListener((SelectionListener)setOptsAdapter);
                    }
                }
            }
        });
        setOptsTreeViewer.getTree().setMenu(setOptsContextMenu);
    }

    private void createAllOptSection(Composite parent) {
        Section allOptSection = this.toolkit.createSection(parent, 256);
        allOptSection.setText(Messages.OptionsPage_available_options);
        Composite allOptsCompo = this.toolkit.createComposite((Composite)allOptSection, 0);
        allOptsCompo.setLayout((Layout)new FormLayout());
        allOptSection.setClient((Control)allOptsCompo);
        this.allOptsTree = new OptionFilteredTree(allOptsCompo, 68354, new PatternFilter(), true);
        this.allOptsTree.setInitialText(Messages.OptionsPage_search_for);
        TreeViewer allOptsTreeViewer = this.allOptsTree.getViewer();
        allOptsTreeViewer.setContentProvider((IContentProvider)new UnusedOptionTreeContentProvider());
        allOptsTreeViewer.getTree().setHeaderVisible(false);
        allOptsTreeViewer.getTree().setLinesVisible(true);
        TreeViewerColumn tvc = new TreeViewerColumn(allOptsTreeViewer, 0);
        tvc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
        allOptsTreeViewer.setAutoExpandLevel(-1);
        allOptsTreeViewer.setInput((Object)this.toolchunk);
        allOptsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int numSelected = ((IStructuredSelection)event.getSelection()).size();
                OptionsPage.this.addSelectedButton.setEnabled(numSelected > 0);
            }
        });
        allOptsTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeViewer tview = OptionsPage.this.allOptsTree.getViewer();
                ISelection select = event.getSelection();
                if (!select.isEmpty() && select instanceof IStructuredSelection) {
                    IStructuredSelection strucSelec = (IStructuredSelection)select;
                    Object first = strucSelec.getFirstElement();
                    if (tview.isExpandable(first)) {
                        boolean expState = tview.getExpandedState(first);
                        tview.setExpandedState(first, !expState);
                    } else {
                        OptionsPage.this.addOptions();
                    }
                }
            }
        });
        final OptionTreeMenuSelectionAdapter allOptsAdapter = new OptionTreeMenuSelectionAdapter(this.allOptsTree);
        final Menu allOptsContextMenu = new Menu((Control)allOptsTreeViewer.getTree());
        allOptsContextMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] menuItemArray = allOptsContextMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem menuItem = menuItemArray[n2];
                    menuItem.dispose();
                    ++n2;
                }
                TreeItem[] items = OptionsPage.this.allOptsTree.getViewer().getTree().getSelection();
                if (items.length == 1) {
                    if (items[0].getParentItem() == null) {
                        if (OptionsPage.this.allOptsTree.getViewer().isExpandable((Object)items[0].getText())) {
                            if (items[0].getExpanded()) {
                                MenuItem collapseItem = new MenuItem(allOptsContextMenu, 8);
                                collapseItem.setText(Messages.OptionsPage_collapse);
                                collapseItem.addSelectionListener((SelectionListener)allOptsAdapter);
                            } else {
                                MenuItem expandItem = new MenuItem(allOptsContextMenu, 8);
                                expandItem.setText(Messages.OptionsPage_expand);
                                expandItem.addSelectionListener((SelectionListener)allOptsAdapter);
                            }
                        }
                    } else {
                        MenuItem addItem = new MenuItem(allOptsContextMenu, 8);
                        addItem.setText(Messages.OptionsPage_add);
                        addItem.addSelectionListener((SelectionListener)allOptsAdapter);
                        MenuItem helpItem = new MenuItem(allOptsContextMenu, 8);
                        helpItem.setText(Messages.OptionsPage_help);
                        helpItem.addSelectionListener((SelectionListener)allOptsAdapter);
                    }
                }
            }
        });
        allOptsTreeViewer.getTree().setMenu(allOptsContextMenu);
        this.addSelectedButton = new Button(allOptsCompo, 8);
        this.addSelectedButton.setText(">");
        this.addSelectedButton.setToolTipText(Messages.OptionsPage_add_from_left_tree);
        this.addSelectedButton.setEnabled(((IStructuredSelection)allOptsTreeViewer.getSelection()).size() > 0);
        this.addSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsPage.this.addOptions();
            }
        });
        FormData allSelBttnLData = new FormData(350, 375);
        allSelBttnLData.top = new FormAttachment(0, 6);
        allSelBttnLData.bottom = new FormAttachment(50, -6);
        allSelBttnLData.right = new FormAttachment(100, 0);
        allSelBttnLData.width = 25;
        this.addSelectedButton.setLayoutData((Object)allSelBttnLData);
        Composite filterCheckboxes = this.toolkit.createComposite(allOptsCompo, 0);
        this.removeSelectedButton = new Button(allOptsCompo, 8);
        this.removeSelectedButton.setText("<");
        this.removeSelectedButton.setToolTipText(Messages.OptionsPage_remove_from_right_tree);
        this.removeSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsPage.this.removeOptions();
            }
        });
        FormData rmSelBttnData = new FormData(350, 375);
        rmSelBttnData.top = new FormAttachment((Control)this.addSelectedButton, 6);
        rmSelBttnData.bottom = new FormAttachment((Control)filterCheckboxes, -6);
        rmSelBttnData.right = new FormAttachment(100, 0);
        rmSelBttnData.width = 25;
        this.removeSelectedButton.setLayoutData((Object)rmSelBttnData);
        FormData allOptsTreeLayoutData = new FormData(350, 375);
        allOptsTreeLayoutData.left = new FormAttachment(0, 0);
        allOptsTreeLayoutData.top = new FormAttachment(0, 6);
        allOptsTreeLayoutData.bottom = new FormAttachment((Control)filterCheckboxes, -6);
        allOptsTreeLayoutData.right = new FormAttachment((Control)this.addSelectedButton, -6);
        this.allOptsTree.setLayoutData(allOptsTreeLayoutData);
        FormData filterCheckboxesData = new FormData();
        filterCheckboxesData.left = new FormAttachment(0, 0);
        filterCheckboxesData.right = new FormAttachment(100, 0);
        filterCheckboxesData.bottom = new FormAttachment(100, 0);
        filterCheckboxes.setLayoutData((Object)filterCheckboxesData);
        GridLayout gl = new GridLayout(3, false);
        gl.verticalSpacing = 8;
        gl.horizontalSpacing = 6;
        filterCheckboxes.setLayout((Layout)gl);
        Label showOptionsLabel = new Label(filterCheckboxes, 0);
        showOptionsLabel.setText(Messages.OptionsPage_show_option_type);
        showOptionsLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.showNormalBox = this.toolkit.createButton(filterCheckboxes, null, 32);
        this.showNormalBox.setText(Messages.OptionsPage_normal);
        this.showNormalBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.showNormalBox.setSelection(true);
        this.showNormalBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OptionsPage.this.updateAllOptsTree();
            }
        });
        this.showExtendedBox = this.toolkit.createButton(filterCheckboxes, null, 32);
        this.showExtendedBox.setText(Messages.OptionsPage_extended);
        this.showExtendedBox.setToolTipText(Messages.OptionsPage_shows_all_options_with_X);
        this.showExtendedBox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.showExtendedBox.setSelection(true);
        this.showExtendedBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OptionsPage.this.updateAllOptsTree();
            }
        });
    }

    private void createActionsSection(Composite parent) {
        Section actionSection = this.toolkit.createSection(parent, 256);
        actionSection.setText(Messages.OptionsPage_actions);
        actionSection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite actionComposite = this.toolkit.createComposite((Composite)actionSection, 0);
        actionSection.setClient((Control)actionComposite);
        FillLayout fl_composite_1 = new FillLayout(256);
        fl_composite_1.marginHeight = 2;
        fl_composite_1.marginWidth = 0;
        fl_composite_1.spacing = 5;
        actionComposite.setLayout((Layout)fl_composite_1);
        Button backButton = new Button(actionComposite, 0);
        backButton.setText(Messages.OptionsPage_overview);
        backButton.setToolTipText(Messages.OptionsPage_go_back_to_overview_page);
        backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OptionsPage.this.editor.setActivePage("com.aicas.jamaica.eclipse.ant_editor.editors.OverviewPage");
            }
        });
        Button invokeButton = new Button(actionComposite, 0);
        ToolType tt = this.toolchunk.getToolType();
        if (ToolType.isJamaica((ToolType)tt)) {
            invokeButton.setText(Messages.OptionsPage_build);
        } else if (ToolType.JARACCELERATOR.equals((Object)tt)) {
            invokeButton.setText(Messages.OptionsPage_accelerate);
        } else {
            invokeButton.setText(Messages.OptionsPage_start);
        }
        invokeButton.setToolTipText(MessageFormat.format(Messages.OptionsPage_run_the___0___with_currently_set_options, tt.toolname()));
        invokeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OptionsPage.this.invokeAntOnThisTarget();
            }
        });
        this.argfileButton = new Button(actionComposite, 0);
        this.argfileButton.setText(Messages.OptionsPage_argument_files);
        this.argfileButton.setToolTipText(MessageFormat.format(Messages.OptionsPage_set_argument_files_for___0___, this.toolchunk.getToolType().toolname()));
        this.argfileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OptionsPage.this.openArgfileDialog(false);
            }
        });
        this.envButton = new Button(actionComposite, 0);
        this.envButton.setText(Messages.OptionsPage_environment);
        this.envButton.setToolTipText(MessageFormat.format(Messages.OptionsPage_set_environment_variables_for___0___, this.toolchunk.getToolType().toolname()));
        this.envButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OptionsPage.this.openEnvironmentDialog(false);
            }
        });
    }

    private void createTargetSection(Composite parent) {
        Section targetSection = this.toolkit.createSection(parent, 256);
        targetSection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        targetSection.setText(Messages.OptionsPage_target);
        Composite targetComposite = this.toolkit.createComposite((Composite)targetSection, 0);
        targetSection.setClient((Control)targetComposite);
        GridLayout targetBoxLayout = new GridLayout(2, true);
        targetBoxLayout.marginWidth = 0;
        targetBoxLayout.marginHeight = 0;
        targetBoxLayout.horizontalSpacing = 8;
        targetComposite.setLayout((Layout)targetBoxLayout);
        Composite nameGroup = new Composite(targetComposite, 0);
        this.toolkit.adapt(nameGroup);
        GridLayout gl_group = new GridLayout(2, false);
        gl_group.marginHeight = 0;
        gl_group.marginWidth = 0;
        gl_group.horizontalSpacing = 4;
        nameGroup.setLayout((Layout)gl_group);
        GridData nameGroupLayoutData = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).create();
        nameGroup.setLayoutData((Object)nameGroupLayoutData);
        CLabel antTargetNameLabel = new CLabel(nameGroup, 0);
        antTargetNameLabel.setText(Messages.OptionsPage_name_colon);
        this.antTargetNameText = new StyledText(nameGroup, 2060);
        this.toolkit.adapt((Composite)this.antTargetNameText);
        this.antTargetNameText.setEditable(false);
        this.antTargetNameText.setCaret(null);
        this.antTargetNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        Composite depGroup = new Composite(targetComposite, 0);
        this.toolkit.adapt(depGroup);
        GridLayout gl_grpDependency = new GridLayout(3, false);
        gl_grpDependency.marginWidth = 0;
        gl_grpDependency.marginHeight = 0;
        gl_grpDependency.horizontalSpacing = 4;
        depGroup.setLayout((Layout)gl_grpDependency);
        GridData depGroupLayoutData = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).create();
        depGroup.setLayoutData((Object)depGroupLayoutData);
        CLabel antTargetDependsLabel = new CLabel(depGroup, 0);
        antTargetDependsLabel.setText(Messages.OptionsPage_dependencies);
        this.antTargetDependsText = new StyledText(depGroup, 2060);
        this.toolkit.adapt((Composite)this.antTargetDependsText);
        this.antTargetDependsText.setEditable(false);
        this.antTargetDependsText.setCaret(null);
        this.antTargetDependsText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        Button button = new Button(depGroup, 0);
        button.setText("...");
        GridData gd_button = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_button.widthHint = 35;
        button.setLayoutData((Object)gd_button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ArrayList<String> allChunks = new ArrayList<String>();
                ProjectFile pf = OptionsPage.this.toolchunk.getManager().getProjectFile();
                allChunks.addAll(pf.getToolChunkManager().getNames());
                allChunks.addAll(pf.getExecChunkManager().getNames());
                allChunks.addAll(pf.getPlainTargetChunkManager().getNames());
                ListSelectionDialog lsd = new ListSelectionDialog(OptionsPage.this.getSite().getShell(), allChunks, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new LabelProvider(), Messages.OptionsPage_Select_Ant_target_dependencies);
                lsd.setTitle(Messages.OptionsPage_Change_dependencies);
                if (OptionsPage.this.toolchunk.getDepends() != null) {
                    Object[] dependsArray = OptionsPage.this.toolchunk.getDepends().split(",");
                    lsd.setInitialSelections(dependsArray);
                }
                if (lsd.open() == 0) {
                    Object[] result = lsd.getResult();
                    if (result.length > 0) {
                        OptionsPage.this.toolchunk.setDepends(AntEditorPlugin.join(result, Arrays.asList(",")));
                    } else {
                        OptionsPage.this.toolchunk.setDepends("");
                    }
                }
            }
        });
    }

    public void setProjectFile(ProjectFile projectFile) {
        boolean changed = false;
        if (this.toolchunk != projectFile.getToolChunkManager().getTag(this.antTargetName)) {
            this.toolchunk = projectFile.getToolChunkManager().getTag(this.antTargetName);
            if (this.allOptsTree != null) {
                this.allOptsTree.getViewer().setInput((Object)this.toolchunk);
            }
            if (this.setOptsTree != null) {
                this.setOptsTree.getViewer().setInput((Object)this.toolchunk);
            }
            changed = true;
        }
        if (this.propertiesManager != projectFile.getPropertiesManager()) {
            this.propertiesManager = projectFile.getPropertiesManager();
            changed = true;
        }
        if (this.taskdefManager != projectFile.getTaskdefManager()) {
            this.taskdefManager = projectFile.getTaskdefManager();
            changed = true;
        }
        projectFile.addListener(this);
        if (this.buildFile != projectFile.getFile()) {
            this.buildFile = projectFile.getFile();
            changed = true;
        }
        if (this.optionsForm != null && changed) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    OptionsPage.this.updateUI();
                }
            });
        }
    }

    public void setActive(boolean active) {
        if (active) {
            this.updateUI();
        }
        super.setActive(active);
    }

    public void modelPartChanged(final ModelPartChangedEvent event) {
        if (this.optionsForm != null && !this.optionsForm.isDisposed()) {
            if (event.getPart() == ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION && event.getSource() == this.toolchunk && event.getElementName() != null) {
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        OptionsPage.this.updateUI();
                        if (event.getAction() == ModelPartChangedEvent.ActionType.ADDED) {
                            OptionsPage.this.revealOption(event.getElementName());
                        }
                    }
                });
            } else if ((event.getPart().equals((Object)ModelPartChangedEvent.ModelPartType.TOOL_CHUNK) || event.getPart().equals((Object)ModelPartChangedEvent.ModelPartType.TARGET_CHUNK)) && event.getAction().equals((Object)ModelPartChangedEvent.ActionType.CHANGED) && event.getSource().equals(this.toolchunk)) {
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        OptionsPage.this.updateUI();
                    }
                });
            }
        }
    }

    public void revealOption(final String optionName) {
        this.getSite().getWorkbenchWindow().getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                UsedOptionTreeElement treeEle = new UsedOptionTreeElement(UsedOptionTreeElement.ElementType.OPTION, optionName, OptionsPage.this.toolchunk);
                OptionsPage.this.setOptsTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)treeEle), true);
            }
        });
    }

    public void dispose() {
        if (this.toolchunk != null) {
            this.toolchunk.removeListener(this);
            this.propertiesManager.removeListener(this);
            this.taskdefManager.removeListener(this);
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
    }

    private void addOptions() {
        assert (this.optionsForm != null && this.toolchunk != null);
        IStructuredSelection selection = (IStructuredSelection)this.allOptsTree.getViewer().getSelection();
        IToolOptions toolOptions = this.toolchunk.getToolOptions();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectionObj = objectArray[n2];
            String treeItem = (String)selectionObj;
            if (!toolOptions.getAvailableGroups().contains(treeItem)) {
                PossiblyEscapedString initialValue = PossiblyEscapedString.plain((String)"");
                if (toolOptions.isAppendable(treeItem)) {
                    initialValue = PossiblyEscapedString.plain((String)"");
                } else {
                    initialValue = toolOptions.getDefaultValue(treeItem, this.toolchunk.getTargetValue().getString());
                    if (initialValue != null) {
                        if (initialValue.getString().equals("true")) {
                            initialValue = new PossiblyEscapedString("false", initialValue.isEscaped());
                        } else if (initialValue.getString().equals("false")) {
                            initialValue = new PossiblyEscapedString("true", initialValue.isEscaped());
                        }
                    } else if (treeItem.equals(Messages.OptionsPage_agentlib)) {
                        initialValue = PossiblyEscapedString.plain((String)"BuiltInAgent=transport=dt_socket,server=y,suspend=y,address=localhost:8000");
                    }
                }
                this.toolchunk.setOption(treeItem, initialValue);
            }
            ++n2;
        }
    }

    private void removeOptions() {
        assert (this.optionsForm != null && this.toolchunk != null);
        IStructuredSelection selection = (IStructuredSelection)this.setOptsTree.getViewer().getSelection();
        IToolOptions toolOptions = this.toolchunk.getToolOptions();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectionObj = objectArray[n2];
            UsedOptionTreeElement treeItem = (UsedOptionTreeElement)selectionObj;
            if (!toolOptions.getAvailableGroups().contains(treeItem.name_)) {
                if (treeItem.type_.equals((Object)UsedOptionTreeElement.ElementType.PROPERTY)) {
                    PossiblyEscapedString curOptVal = this.toolchunk.getOptionValue("XdefineProperty");
                    if (curOptVal != null && !curOptVal.getString().isEmpty()) {
                        IToolOptions toolOpts = this.toolchunk.getToolOptions();
                        List propSeps = toolOpts.getTupleSeparators("XdefineProperty");
                        if (propSeps != null && !propSeps.isEmpty()) {
                            ArrayList propList = new ArrayList();
                            propList.addAll(toolOpts.split(curOptVal, propSeps));
                            if (propList.contains(treeItem.name_)) {
                                propList.removeAll(Arrays.asList(treeItem.name_));
                                PossiblyEscapedString newOptVal = toolOpts.join(propList, propSeps);
                                this.toolchunk.setOption("XdefineProperty", newOptVal);
                            }
                        } else {
                            AntEditorPlugin.log("Option 'XdefineProperty' should have at least one tuple separator.");
                        }
                    }
                } else if (treeItem.type_.equals((Object)UsedOptionTreeElement.ElementType.OPTION)) {
                    this.toolchunk.removeOption(treeItem.name_);
                }
            }
            ++n2;
        }
    }

    private void editOption(String optname) {
        this.editDialog = new OptionValueEditorDialog(this.setOptsTree.getShell(), this.toolchunk, optname, this.toolkit);
        this.editDialog.open();
        this.editDialog = null;
    }

    private void updateUI() {
        if (this.toolchunk == null || this.optionsForm == null || this.optionsForm.isDisposed()) {
            return;
        }
        this.optionsForm.setRedraw(false);
        this.antTargetNameText.setText(this.toolchunk.getName());
        this.antTargetDependsText.setText(this.toolchunk.getDepends());
        if (this.optionSash.getSize().y < 5) {
            this.optionSash.setSize(this.optionSash.computeSize(this.optionSash.getSize().x, -1));
        }
        int verMaj = -1;
        int verMin = -1;
        ToolType tool = ToolType.INVALID;
        if (this.toolchunk.isBound()) {
            verMaj = this.toolchunk.getDistribution().getVersionMajor();
            verMin = this.toolchunk.getDistribution().getVersionMinor();
            tool = this.toolchunk.getToolType();
        }
        boolean tooOld = verMaj < 6 || verMaj == 6 && verMin < 1;
        this.envButton.setEnabled(!tooOld);
        boolean hasArgFiles = (verMaj > 8 || verMaj == 8 && verMin >= 5) && (tool.equals((Object)ToolType.JAMAICA) || tool.equals((Object)ToolType.JARACCELERATOR));
        this.argfileButton.setEnabled(hasArgFiles);
        if (this.editDialog != null) {
            this.editDialog.updateUI();
        }
        this.updateAllOptsTree();
        this.updateSetOptsTree();
        this.optionSash.layout(true, true);
        this.optionsForm.reflow(true);
        this.optionsForm.setMinSize(0, 0);
        this.optionsForm.layout(true, true);
        this.optionsForm.setRedraw(true);
    }

    private void openEnvironmentDialog(boolean blockOnOpen) {
        if (this.toolchunk != null) {
            ToolEnvironmentDialog d = new ToolEnvironmentDialog(this.getSite().getShell(), this.toolchunk);
            d.setBlockOnOpen(blockOnOpen);
            d.open();
        }
    }

    private void openArgfileDialog(boolean blockOnOpen) {
        if (this.toolchunk != null) {
            ToolArgFileDialog d = new ToolArgFileDialog(this.getSite().getShell(), this.toolchunk);
            d.setBlockOnOpen(blockOnOpen);
            d.open();
        }
    }

    public void invokeAntOnThisTarget() {
        try {
            AntLaunchUtils.runAntTarget(this.buildFile, this.antTargetName);
        }
        catch (CoreException ce) {
            AntEditorPlugin.log(ce);
        }
    }

    public ToolChunk getModel() {
        return this.toolchunk;
    }

    public void propertyChanged(Object source, int propId) {
        if (source.equals(this.editor)) {
            switch (propId) {
                case 258: {
                    this.setInput(this.editor.getEditorInput());
                    break;
                }
                case 1: {
                    break;
                }
                case 257: {
                    break;
                }
            }
        }
    }

    private void updateAllOptsTree() {
        assert (this.allOptsTree != null && this.allOptsTree.getViewer() != null && this.toolchunk != null);
        this.allOptsTree.setRedraw(false);
        TreeViewer tviewer = this.allOptsTree.getViewer();
        ((UnusedOptionTreeContentProvider)tviewer.getContentProvider()).setVisibility(this.showNormalBox.getSelection(), this.showExtendedBox.getSelection());
        tviewer.refresh(true);
        tviewer.expandAll();
        this.allOptsTree.packTree();
        Tree tree = tviewer.getTree();
        if (tree.getItemCount() > 0) {
            if (tree.getSelectionCount() <= 0) {
                tree.showItem(tree.getItem(0));
            } else {
                tree.setSelection(tree.getSelection());
            }
        }
        this.allOptsTree.setRedraw(true);
    }

    private void updateSetOptsTree() {
        assert (this.setOptsTree != null && this.setOptsTree.getViewer() != null && this.toolchunk != null);
        this.setOptsTree.setRedraw(false);
        TreeViewer tviewer = this.setOptsTree.getViewer();
        tviewer.refresh(true);
        tviewer.expandAll();
        this.setOptsTree.packTree();
        Tree tree = tviewer.getTree();
        if (tree.getItemCount() > 0) {
            if (tree.getSelectionCount() <= 0) {
                tree.showItem(tree.getItem(0));
            } else {
                tree.setSelection(tree.getSelection());
            }
        }
        this.setOptsTree.setRedraw(true);
    }

    class OptionTreeMenuSelectionAdapter
    extends SelectionAdapter {
        private FilteredTree ftree;

        public OptionTreeMenuSelectionAdapter(FilteredTree ftree) {
            this.ftree = ftree;
        }

        public void widgetSelected(SelectionEvent e) {
            Object eventSrc;
            String selectedOption = "";
            Object firstElement = null;
            ISelection sel = this.ftree.getViewer().getSelection();
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection ssel = (IStructuredSelection)sel;
                firstElement = ssel.getFirstElement();
                if (firstElement instanceof UsedOptionTreeElement) {
                    UsedOptionTreeElement treeEle = (UsedOptionTreeElement)firstElement;
                    selectedOption = treeEle.type_.equals((Object)UsedOptionTreeElement.ElementType.PROPERTY) ? "XdefineProperty" : treeEle.name_;
                } else if (firstElement instanceof String) {
                    selectedOption = (String)firstElement;
                }
            }
            if ((eventSrc = e.getSource()) instanceof MenuItem) {
                MenuItem mi = (MenuItem)eventSrc;
                String miText = mi.getText();
                if (miText.equals(Messages.OptionsPage_add)) {
                    OptionsPage.this.addOptions();
                } else if (miText.equals(Messages.OptionsPage_remove)) {
                    OptionsPage.this.removeOptions();
                } else if (miText.equals(Messages.OptionsPage_edit)) {
                    OptionsPage.this.editOption(selectedOption);
                } else if (miText.equals(Messages.OptionsPage_help)) {
                    InfoPopUp.showOptionHelp(this.ftree.getShell(), OptionsPage.this.toolchunk, selectedOption);
                } else if (miText.equals(Messages.OptionsPage_expand) || miText.equals(Messages.OptionsPage_collapse)) {
                    boolean expState = this.ftree.getViewer().getExpandedState(firstElement);
                    this.ftree.getViewer().setExpandedState(firstElement, !expState);
                }
            }
        }
    }
}

