/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class OptionFilteredTree
extends FilteredTree {
    private String previousFilterText;
    private boolean narrowingDown;

    public OptionFilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
        super(parent, treeStyle, filter, useNewLook);
    }

    protected long getRefreshJobDelay() {
        return 0L;
    }

    protected void textChanged() {
        this.narrowingDown = this.previousFilterText == null || this.previousFilterText.equals(this.initialText) || this.getFilterString().startsWith(this.previousFilterText);
        this.previousFilterText = this.getFilterString();
        super.textChanged();
    }

    protected WorkbenchJob doCreateRefreshJob() {
        return new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (OptionFilteredTree.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = OptionFilteredTree.this.getFilterString();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                boolean bl = initial = OptionFilteredTree.this.initialText != null && OptionFilteredTree.this.initialText.equals(text);
                if (initial) {
                    OptionFilteredTree.this.getPatternFilter().setPattern(null);
                } else if (text != null) {
                    OptionFilteredTree.this.getPatternFilter().setPattern(text);
                }
                Composite redrawFalseControl = OptionFilteredTree.this.treeComposite != null ? OptionFilteredTree.this.treeComposite : OptionFilteredTree.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    if (!OptionFilteredTree.this.narrowingDown) {
                        TreeItem[] is = OptionFilteredTree.this.treeViewer.getTree().getItems();
                        int i = 0;
                        while (i < is.length) {
                            TreeItem item = is[i];
                            if (item.getExpanded()) {
                                OptionFilteredTree.this.treeViewer.setExpandedState(item.getData(), false);
                            }
                            ++i;
                        }
                    }
                    OptionFilteredTree.this.treeViewer.refresh(true);
                    OptionFilteredTree.this.treeViewer.expandAll();
                    OptionFilteredTree.this.updateToolbar(true);
                }
                finally {
                    OptionFilteredTree.this.packTree();
                    Tree tree = OptionFilteredTree.this.treeViewer.getTree();
                    if (tree.getItemCount() > 0) {
                        if (tree.getSelectionCount() <= 0) {
                            tree.showItem(tree.getItem(0));
                        } else {
                            tree.setSelection(tree.getSelection());
                        }
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public void packTree() {
        TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn tcol = treeColumnArray[n2];
            tcol.pack();
            ++n2;
        }
    }
}

