/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.analyzer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall3;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.CompatibleEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentAnalyzerDelegate;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamaicaExeEnvAnalyzer
implements IExecutionEnvironmentAnalyzerDelegate {
    private static final String JamaicaVM_6 = "JamaicaVM-6";
    private static final String JamaicaVM_8 = "JamaicaVM-8";
    private static final String JavaSE_1_8 = "JavaSE-1.8";
    private static final String JavaSE_1_7 = "JavaSE-1.7";
    private static final String JavaSE_1_6 = "JavaSE-1.6";
    private static final String JAVA_SPEC_VERSION = "java.specification.version";
    private static final String JAVA_SPEC_NAME = "java.specification.name";
    private static final String JAVA_VERSION = "java.version";
    private static final String JAVA_VM_VERSION = "java.vm.version";
    private static final String JAVA_VM_NAME = "java.vm.name";
    private static final String JAVA_VM_VENDOR = "java.vm.vendor";
    private static final String[] VM_PROPERTIES = new String[]{"java.specification.name", "java.specification.version", "java.version", "java.vm.version", "java.vm.name", "java.vm.vendor"};

    public CompatibleEnvironment[] analyze(IVMInstall vm, IProgressMonitor monitor) throws CoreException {
        ArrayList<CompatibleEnvironment> result = new ArrayList<CompatibleEnvironment>();
        ArrayList<String> types = new ArrayList<String>();
        if (!(vm instanceof IVMInstall3)) {
            return new CompatibleEnvironment[0];
        }
        IVMInstall3 vm3 = (IVMInstall3)vm;
        Map map = null;
        try {
            map = vm3.evaluateSystemProperties(VM_PROPERTIES, null);
        }
        catch (CoreException ce) {
            return new CompatibleEnvironment[0];
        }
        String vmName = (String)map.get(JAVA_VM_NAME);
        String vmVersion = (String)map.get(JAVA_VM_VERSION);
        String vmVendor = (String)map.get(JAVA_VM_VENDOR);
        String javaVersion = (String)map.get(JAVA_VERSION);
        if (vmName != null && vmName.toLowerCase().contains("jamaicavm") && vmVendor != null && vmVendor.toLowerCase().contains("aicas")) {
            if (vmVersion != null && vmVersion.matches("[0]?6\\.[\\d]*[\\w]*.*") && javaVersion != null && javaVersion.startsWith("1.6")) {
                types.add(JamaicaVM_6);
                types.add(JavaSE_1_6);
            } else if ((vmVersion != null && vmVersion.matches("[0]?6\\.[\\d]*[\\w]*.*") || vmVersion != null && vmVersion.matches("[0]?8\\.[\\d]*[\\w]*.*")) && javaVersion != null && javaVersion.startsWith("1.8")) {
                types.add(JamaicaVM_8);
                types.add(JamaicaVM_6);
                types.add(JavaSE_1_8);
                types.add(JavaSE_1_7);
                types.add(JavaSE_1_6);
            }
        }
        int i = 0;
        while (i < types.size()) {
            this.addEnvironment(result, (String)types.get(i), i == 0);
            ++i;
        }
        return result.toArray(new CompatibleEnvironment[0]);
    }

    private void addEnvironment(List<CompatibleEnvironment> result, String id, boolean strict) {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment env = manager.getEnvironment(id);
        if (env != null) {
            result.add(new CompatibleEnvironment(env, strict));
        }
    }
}

