/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher;

import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.Messages;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolInfoOptions
implements IToolOptions {
    private int cBoolSE;
    private int cListSE;
    private int cStringSE;
    private int cStringListSE;
    private int cAgentlibSE;
    private Class<?> cl_LegacyToolInfoSupplier;
    private Class<?> cl_ToolInfoSupplier;
    private Class<?> cl_ToolType;
    private Class<?> cl_OptionLevel;
    private Class<?> cl_SyntaxTree;
    private Class<?> cl_CollectionNode;
    private Class<?> cl_EnvBackedNode;
    private Class<?> cl_FiniteLeaf;
    private Class<?> cl_MapNode;
    private Class<?> cl_ProductNode;
    private Class<?> cl_SimpleLeaf;
    private Class<?> cl_SumNode;
    private Class<?> cl_PossiblyEscapedString;
    private Method mtd_TIS_getDocSections;
    private Method mtd_TIS_getDocSectionFor;
    private Method mtd_TIS_getOptionLevelFor;
    private Method mtd_TIS_getDescriptionFor;
    private Method mtd_TIS_getSeparatorsFor;
    private Method mtd_TIS_getParameterDescriptionFor;
    private Method mtd_TIS_getAllowedValuesFor;
    private Method mtd_TIS_supportsMultipleArguments;
    private Method mtd_TIS_validate;
    private Method mtd_TIS_tokenizeAndValidate;
    private Method mtd_TIS_getOptionNamesWithAliases;
    private Method mtd_TIS_getOptionNames;
    private Method mtd_TIS_loadConfigValues;
    private Method mtd_TIS_loadPossiblyEscapedConfigValues;
    private Method mtd_TIS_getArgumentRolesFor;
    private Method mtd_TIS_getSyntaxTreeFor;
    private Method mtd_ToolType_getResource;
    private Method mtd_TIS_validateEsc;
    private Method mtd_TIS_decodeEscaping;
    private Method mtd_TIS_tokenizeAndValidateEsc;
    private Method mtd_PES_getString;
    private Method mtd_PES_isEscaped;
    private Map<String, String> optionTypeToConstantMapping;
    private Object obj_LTIS;
    private Object obj_TIS;
    private String toolClasspath;
    private String toolPath;
    private JamaicaVMDistribution distribution;
    private Map<String, IntermediateOption> options;
    private List<String> optionNames;
    private List<String> groupNames;
    private Map<String, Map<String, PossiblyEscapedString>> defaultValues;
    private Map<String, Map<String, Object>> rawDefaultValues;

    public void init(AbstractJamaicaDistribution abstractDist, ToolType tool) {
        block40: {
            if (!(abstractDist instanceof JamaicaVMDistribution)) {
                throw new IllegalArgumentException("Unsupported distribution type: " + abstractDist);
            }
            this.distribution = (JamaicaVMDistribution)abstractDist;
            if (!(ToolType.isJamaica((ToolType)tool) || ToolType.isJamaicah((ToolType)tool) || ToolType.JARACCELERATOR.equals((Object)tool) || ToolType.THREADMONITOR.equals((Object)tool) || ToolType.PROFILE_ANALYZER.equals((Object)tool))) {
                throw new IllegalArgumentException(String.valueOf(Messages.JarExportedOptions_Unsupported_tool_type) + ": " + tool);
            }
            String mainBin = String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "bin" + File.separator;
            String mainLib = String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "lib" + File.separator;
            String exeExt = "";
            String scriptExt = "";
            if (Platform.getOS().equals("win32")) {
                exeExt = ".exe";
                scriptExt = ".cmd";
            }
            switch (tool) {
                case JAMAICA: {
                    this.toolPath = String.valueOf(mainBin) + "jamaicabuilder_bin" + exeExt;
                    break;
                }
                case JAMAICA_INTERNAL: {
                    this.toolPath = String.valueOf(mainBin) + "jamaicabuilder_interpreted" + scriptExt;
                    break;
                }
                case JAMAICAH: {
                    this.toolPath = String.valueOf(mainBin) + "jamaicah_bin" + exeExt;
                    break;
                }
                case JAMAICAH_INTERNAL: {
                    this.toolPath = String.valueOf(mainBin) + "jamaicah_interpreted" + scriptExt;
                    break;
                }
                case JARACCELERATOR: {
                    this.toolPath = String.valueOf(mainBin) + "jamaicajaraccelerator_bin" + exeExt;
                    break;
                }
                case PROFILE_ANALYZER: {
                    this.toolPath = String.valueOf(mainBin) + "profileanalyzer_bin" + exeExt;
                    break;
                }
                case THREADMONITOR: {
                    this.toolPath = String.valueOf(mainLib) + "JamaicaTrace.jar";
                    if (new File(this.toolPath).isFile()) break;
                    this.toolPath = String.valueOf(mainLib) + "ThreadMonitor.jar";
                }
            }
            String string = this.toolPath = new File(this.toolPath).isFile() ? this.toolPath : null;
            if (this.toolPath == null) {
                throw new IllegalStateException("Executable not found for tool: " + tool.toolname());
            }
            boolean isInternal = ToolType.isInternalType((ToolType)tool);
            try {
                if (ToolType.isJamaica((ToolType)tool) || ToolType.isJamaicah((ToolType)tool) || ToolType.JARACCELERATOR.equals((Object)tool) || ToolType.PROFILE_ANALYZER.equals((Object)tool)) {
                    if (isInternal) {
                        String classesDir = String.valueOf(this.distribution.getClassesDirectory(this.distribution.getHostTarget())) + File.separator;
                        if (classesDir != null) {
                            this.toolClasspath = LauncherPlugin.normalize(classesDir);
                        }
                    } else {
                        this.toolClasspath = LauncherPlugin.normalize(String.valueOf(mainLib) + "JamaicaTools.jar");
                    }
                    URLClassLoader toolClassloader = new URLClassLoader(new URL[]{new File(this.toolClasspath).toURI().toURL()});
                    this.optionTypeToConstantMapping = new HashMap<String, String>(3);
                    this.optionTypeToConstantMapping.put("NORMAL", "normal");
                    this.optionTypeToConstantMapping.put("EXTENDED", "extended");
                    this.optionTypeToConstantMapping.put("INTERNAL", "internal");
                    String tool_resfile = "";
                    String tool_name = "VOIDTOOL";
                    String tool_optfile = "";
                    if (ToolType.isJamaica((ToolType)tool)) {
                        tool_name = "BUILDER";
                        tool_resfile = "builder.xml";
                        tool_optfile = "jamaica.conf";
                    } else if (ToolType.isJamaicah((ToolType)tool)) {
                        tool_name = "JAMAICAH";
                        tool_resfile = "jamaicah.xml";
                        tool_optfile = "jamaicah.conf";
                    } else if (ToolType.JARACCELERATOR.equals((Object)tool)) {
                        tool_name = "JARACCELERATOR";
                        tool_resfile = "jar-accelerator.xml";
                        tool_optfile = "jaraccelerator.conf";
                    } else if (ToolType.PROFILE_ANALYZER.equals((Object)tool)) {
                        tool_name = "PROFILEANALYZER";
                        tool_resfile = "profileanalyzer.xml";
                        tool_optfile = "profileanalyzer.conf";
                    }
                    this.cl_SyntaxTree = toolClassloader.loadClass("com.aicas.optionsparser.ast.SyntaxTree");
                    this.cl_CollectionNode = toolClassloader.loadClass("com.aicas.optionsparser.ast.CollectionNode");
                    this.cl_EnvBackedNode = toolClassloader.loadClass("com.aicas.optionsparser.ast.EnvBackedNode");
                    this.cl_FiniteLeaf = toolClassloader.loadClass("com.aicas.optionsparser.ast.FiniteLeaf");
                    this.cl_MapNode = toolClassloader.loadClass("com.aicas.optionsparser.ast.MapNode");
                    this.cl_ProductNode = toolClassloader.loadClass("com.aicas.optionsparser.ast.ProductNode");
                    this.cl_SimpleLeaf = toolClassloader.loadClass("com.aicas.optionsparser.ast.SimpleLeaf");
                    this.cl_SumNode = toolClassloader.loadClass("com.aicas.optionsparser.ast.SumNode");
                    this.cl_PossiblyEscapedString = toolClassloader.loadClass("com.aicas.optionsparser.util.PossiblyEscapedString");
                    this.mtd_PES_getString = this.cl_PossiblyEscapedString.getMethod("getString", null);
                    this.mtd_PES_isEscaped = this.cl_PossiblyEscapedString.getMethod("isEscaped", null);
                    this.cl_OptionLevel = toolClassloader.loadClass("com.aicas.optionsparser.OptionLevel");
                    this.cl_LegacyToolInfoSupplier = toolClassloader.loadClass("com.aicas.optionsparser.util.LegacyToolInformationSupplier");
                    this.cl_ToolInfoSupplier = toolClassloader.loadClass("com.aicas.optionsparser.util.ToolInformationSupplier");
                    this.mtd_TIS_getDocSections = this.cl_LegacyToolInfoSupplier.getMethod("getDocumentationSections", null);
                    this.mtd_TIS_getDocSectionFor = this.cl_LegacyToolInfoSupplier.getMethod("getDocumentationSectionFor", String.class);
                    this.mtd_TIS_getOptionLevelFor = this.cl_LegacyToolInfoSupplier.getMethod("getOptionLevelFor", String.class);
                    this.mtd_TIS_getDescriptionFor = this.cl_LegacyToolInfoSupplier.getMethod("getDescriptionFor", String.class);
                    this.mtd_TIS_getSeparatorsFor = this.cl_LegacyToolInfoSupplier.getMethod("getSeparatorsFor", String.class);
                    this.mtd_TIS_getParameterDescriptionFor = this.cl_LegacyToolInfoSupplier.getMethod("getParameterDescriptionFor", String.class);
                    this.mtd_TIS_getAllowedValuesFor = this.cl_LegacyToolInfoSupplier.getMethod("getAllowedValuesFor", String.class);
                    this.mtd_TIS_supportsMultipleArguments = this.cl_LegacyToolInfoSupplier.getMethod("supportsMultipleArguments", String.class);
                    this.mtd_TIS_validate = this.cl_LegacyToolInfoSupplier.getMethod("validate", String.class, String.class);
                    this.mtd_TIS_decodeEscaping = this.cl_LegacyToolInfoSupplier.getMethod("decodeEscaping", this.cl_PossiblyEscapedString);
                    try {
                        this.mtd_TIS_validateEsc = this.cl_LegacyToolInfoSupplier.getMethod("validate", String.class, this.cl_PossiblyEscapedString);
                    }
                    catch (NoSuchMethodException nsme) {
                        this.mtd_TIS_validateEsc = this.cl_ToolInfoSupplier.getMethod("validate", String.class, this.cl_PossiblyEscapedString);
                    }
                    this.mtd_TIS_tokenizeAndValidate = this.cl_LegacyToolInfoSupplier.getMethod("tokenizeAndValidate", String.class, String.class);
                    try {
                        this.mtd_TIS_tokenizeAndValidateEsc = this.cl_LegacyToolInfoSupplier.getMethod("tokenizeAndValidate", String.class, this.cl_PossiblyEscapedString);
                    }
                    catch (NoSuchMethodException nsme) {
                        this.mtd_TIS_tokenizeAndValidateEsc = this.cl_ToolInfoSupplier.getMethod("tokenizeAndValidate", String.class, this.cl_PossiblyEscapedString);
                    }
                    this.mtd_TIS_getOptionNamesWithAliases = this.cl_LegacyToolInfoSupplier.getMethod("getOptionNamesWithAliases", null);
                    this.mtd_TIS_getOptionNames = this.cl_LegacyToolInfoSupplier.getMethod("getOptionNames", null);
                    this.mtd_TIS_loadConfigValues = this.cl_LegacyToolInfoSupplier.getMethod("loadConfigValues", String.class);
                    this.mtd_TIS_loadPossiblyEscapedConfigValues = this.cl_LegacyToolInfoSupplier.getMethod("loadPossiblyEscapedConfigValues", String.class);
                    this.mtd_TIS_getArgumentRolesFor = this.cl_LegacyToolInfoSupplier.getMethod("getArgumentRolesFor", String.class);
                    this.mtd_TIS_getSyntaxTreeFor = this.cl_LegacyToolInfoSupplier.getMethod("getSyntaxTreeFor", String.class);
                    try {
                        this.cl_ToolType = toolClassloader.loadClass("com.aicas.jamaica.plugin.core.ToolType");
                    }
                    catch (ClassNotFoundException e) {
                        this.cl_ToolType = toolClassloader.loadClass("com.aicas.jamaica.tools.ant.ToolType");
                    }
                    this.mtd_ToolType_getResource = this.cl_ToolType.getMethod("getResource", null);
                    if (this.cl_ToolType.isEnum()) {
                        Enum[] toolTypes;
                        Enum[] enumArray = toolTypes = (Enum[])this.cl_ToolType.getEnumConstants();
                        int n = toolTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Enum toolType = enumArray[n2];
                            if (toolType.name().equals(tool_name)) {
                                tool_resfile = (String)this.mtd_ToolType_getResource.invoke((Object)toolType, null);
                            }
                            ++n2;
                        }
                    }
                    Constructor<?> ctor_LTIS = this.cl_LegacyToolInfoSupplier.getConstructor(ClassLoader.class, String.class);
                    this.obj_LTIS = ctor_LTIS.newInstance(toolClassloader, tool_resfile);
                    Constructor<?> ctor_TIS = this.cl_ToolInfoSupplier.getConstructor(ClassLoader.class, String.class);
                    this.obj_TIS = ctor_TIS.newInstance(toolClassloader, tool_resfile);
                    this.groupNames = new ArrayList<String>((Set)this.mtd_TIS_getDocSections.invoke(this.obj_LTIS, null));
                    this.optionNames = new ArrayList<String>((List)this.mtd_TIS_getOptionNames.invoke(this.obj_LTIS, null));
                    this.options = new LinkedHashMap<String, IntermediateOption>();
                    for (String optName : this.optionNames) {
                        IntermediateOption opt = new IntermediateOption();
                        opt.init(optName);
                        this.options.put(opt.name, opt);
                    }
                    this.rawDefaultValues = new LinkedHashMap<String, Map<String, Object>>();
                    for (String target : this.distribution.getAvailableTargets()) {
                        File defOptValFile = new File(String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "target" + File.separator + target + File.separator + "etc" + File.separator + tool_optfile);
                        if (!defOptValFile.canRead()) continue;
                        try {
                            Map rawMap = (Map)this.mtd_TIS_loadPossiblyEscapedConfigValues.invoke(this.obj_LTIS, defOptValFile.getAbsolutePath());
                            this.rawDefaultValues.put(target, rawMap);
                        }
                        catch (InvocationTargetException e) {
                            LauncherPlugin.log(e.getCause().getMessage(), e.getCause());
                        }
                    }
                    break block40;
                }
                if (ToolType.THREADMONITOR.equals((Object)tool)) {
                    this.toolClasspath = this.toolPath;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void printOptionType(IToolOptions.EditorType et) {
        System.out.println("Printing all " + et + " options:");
        for (IntermediateOption o : this.options.values()) {
            if (!o.editorType.equals((Object)et)) continue;
            System.out.println("  " + o.name);
        }
    }

    public boolean isAppendable(String optionName) {
        return this.options.containsKey(optionName) ? this.options.get((Object)optionName).editorType.equals((Object)IToolOptions.EditorType.STRING_LIST) : false;
    }

    public List<String> getAvailableOptions() {
        return this.optionNames;
    }

    public List<String> getAvailableGroups() {
        return this.groupNames;
    }

    public String getGroup(String optionName) {
        String retval = null;
        if (this.options.containsKey(optionName)) {
            retval = this.options.get((Object)optionName).group;
        }
        return retval;
    }

    public String getType(String optionName) {
        String retval = null;
        if (this.options.containsKey(optionName)) {
            retval = this.options.get((Object)optionName).type;
        }
        return retval;
    }

    public String getDescription(String optionName, String targetName) {
        String retval = null;
        if (this.options.containsKey(optionName)) {
            retval = this.options.get((Object)optionName).description;
        }
        return retval;
    }

    public PossiblyEscapedString getDefaultValue(String optionName, String targetName) {
        String t;
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        if (optionName.equals("target")) {
            return PossiblyEscapedString.plain((String)this.distribution.getHostTarget());
        }
        String string = t = targetName == null ? this.distribution.getHostTarget() : targetName;
        if (this.defaultValues == null) {
            this.defaultValues = new LinkedHashMap<String, Map<String, PossiblyEscapedString>>();
        }
        if (this.rawDefaultValues.containsKey(t) && !this.defaultValues.containsKey(t)) {
            Map<String, Object> rawMap = this.rawDefaultValues.get(t);
            LinkedHashMap<String, PossiblyEscapedString> pesMap = new LinkedHashMap<String, PossiblyEscapedString>();
            for (Map.Entry<String, Object> e : rawMap.entrySet()) {
                String optName = e.getKey();
                PossiblyEscapedString optPes = this.convertObjToPes(e.getValue());
                pesMap.put(optName, optPes);
            }
            this.defaultValues.put(t, pesMap);
        }
        return this.defaultValues.containsKey(t) ? this.defaultValues.get(t).get(optionName) : null;
    }

    public List<String> getEnvVarSeparators(String optionName) {
        if (this.options.containsKey(optionName)) {
            ArrayList<String> retval = new ArrayList<String>();
            retval.addAll(this.options.get((Object)optionName).envVarSeparators);
            return retval;
        }
        return null;
    }

    public List<String> getKeyValueSeparators(String optionName) {
        if (this.options.containsKey(optionName)) {
            ArrayList<String> retval = new ArrayList<String>();
            retval.addAll(this.options.get((Object)optionName).keyValueSeparators);
            return retval;
        }
        return null;
    }

    public List<String> getTupleSeparators(String optionName) {
        if (this.options.containsKey(optionName)) {
            ArrayList<String> retval = new ArrayList<String>();
            retval.addAll(this.options.get((Object)optionName).tupleSeparators);
            return retval;
        }
        return null;
    }

    public String getArgument(String optionName) {
        String retval = null;
        if (this.options.containsKey(optionName)) {
            retval = this.options.get((Object)optionName).argument;
        }
        return retval;
    }

    public IToolOptions.EditorType getOptionEditorType(String optionName) {
        IToolOptions.EditorType retval = null;
        if (this.options.containsKey(optionName)) {
            retval = this.options.get((Object)optionName).editorType;
        }
        return retval;
    }

    public List<String> getOptionEditorArgs(String optionName) {
        List<String> retval = null;
        if (this.options.containsKey(optionName)) {
            retval = this.options.get((Object)optionName).editorArgs;
        }
        return retval;
    }

    public List<String> validate(String optionName, PossiblyEscapedString value) {
        ArrayList<String> retval = new ArrayList<String>();
        if (!this.options.containsKey(optionName)) {
            retval.add(Messages.JarExportedOptions_Unknown_option);
        } else if ("target".equals(optionName)) {
            if (!this.distribution.getAvailableTargets().contains(value.getString())) {
                retval.add("Platform '" + value.getString() + "' is not supported by this JamaicaVM distribution!");
            }
        } else {
            try {
                Object jarPES = this.convertPesToObj(value);
                if (this.mtd_TIS_validateEsc.getDeclaringClass().equals(this.cl_LegacyToolInfoSupplier)) {
                    retval.addAll((List)this.mtd_TIS_validateEsc.invoke(this.obj_LTIS, optionName, jarPES));
                } else {
                    retval.addAll((List)this.mtd_TIS_validateEsc.invoke(this.obj_TIS, optionName, jarPES));
                }
            }
            catch (Exception e) {
                LauncherPlugin.log(e);
                retval.add("Validation failed: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage()));
            }
        }
        return retval;
    }

    public String getToolClasspath() {
        return this.toolClasspath;
    }

    public String getToolPath() {
        return this.toolPath;
    }

    public List<PossiblyEscapedString> split(PossiblyEscapedString item, List<String> separators) {
        ArrayList<PossiblyEscapedString> retval = null;
        if (item != null) {
            retval = new ArrayList<PossiblyEscapedString>();
            if (separators == null || separators.isEmpty()) {
                retval.add(item);
            } else {
                String tok;
                String regex = "";
                int i = 0;
                while (i < separators.size()) {
                    regex = String.valueOf(regex) + Pattern.quote(separators.get(i));
                    if (i < separators.size() - 1) {
                        regex = String.valueOf(regex) + "|";
                    }
                    ++i;
                }
                Matcher m = Pattern.compile(regex).matcher(item.getString());
                int lastEndPos = 0;
                while (m.find()) {
                    if (this.isEscaped(item, m.start(), m.end())) continue;
                    tok = item.getString().substring(lastEndPos, m.start());
                    retval.add(new PossiblyEscapedString(tok, item.isEscaped()));
                    lastEndPos = m.end();
                }
                tok = item.getString().substring(lastEndPos, item.getString().length());
                retval.add(new PossiblyEscapedString(tok, item.isEscaped()));
            }
        }
        return retval;
    }

    public PossiblyEscapedString join(List<PossiblyEscapedString> items, List<String> separators) {
        PossiblyEscapedString retval = PossiblyEscapedString.plain((String)"");
        int i = 0;
        while (i < items.size()) {
            PossiblyEscapedString pes = items.get(i);
            boolean esc = retval.isEscaped() || pes.isEscaped();
            retval = new PossiblyEscapedString(String.valueOf(retval.getString()) + pes.getString(), esc);
            if (i < items.size() - 1) {
                retval = new PossiblyEscapedString(String.valueOf(retval.getString()) + separators.get(0), retval.isEscaped());
            }
            ++i;
        }
        return retval;
    }

    public String unescape(PossiblyEscapedString pes) {
        String retval = null;
        if (pes != null) {
            try {
                Object jarPES = this.convertPesToObj(pes);
                retval = (String)this.mtd_TIS_decodeEscaping.invoke(this.obj_LTIS, jarPES);
            }
            catch (Exception e) {
                LauncherPlugin.log(e);
            }
        }
        return retval;
    }

    protected Object convertPesToObj(PossiblyEscapedString pes) {
        Object retval = null;
        try {
            Constructor<?> ctor = this.cl_PossiblyEscapedString.getConstructor(String.class, Boolean.TYPE);
            retval = ctor.newInstance(pes.getString(), pes.isEscaped());
        }
        catch (Exception e) {
            LauncherPlugin.log(e.getMessage(), e);
        }
        return retval;
    }

    protected PossiblyEscapedString convertObjToPes(Object o) {
        PossiblyEscapedString retval = null;
        try {
            String optVal = (String)this.mtd_PES_getString.invoke(o, null);
            Boolean optEsc = (Boolean)this.mtd_PES_isEscaped.invoke(o, null);
            retval = new PossiblyEscapedString(optVal, optEsc.booleanValue());
        }
        catch (Exception e) {
            LauncherPlugin.log(e.getMessage(), e);
        }
        return retval;
    }

    public PossiblyEscapedString escape(String item, List<String> separators) {
        if (item == null) {
            return null;
        }
        if (separators == null || separators.isEmpty()) {
            return PossiblyEscapedString.plain((String)item);
        }
        StringBuffer escapedItem = new StringBuffer(item);
        int i = 0;
        while (i < separators.size()) {
            int sepPos = -1;
            int startPos = 0;
            while ((sepPos = escapedItem.indexOf(separators.get(i), startPos)) > -1) {
                if (!this.isEscaped(PossiblyEscapedString.escaped((String)escapedItem.toString()), sepPos, sepPos + separators.get(i).length())) {
                    escapedItem.insert(sepPos, '\\');
                    ++sepPos;
                }
                startPos = sepPos + separators.get(i).length();
            }
            ++i;
        }
        return PossiblyEscapedString.escaped((String)escapedItem.toString());
    }

    public boolean isEscaped(PossiblyEscapedString item, int start, int end) {
        boolean retval = false;
        if (item.isEscaped()) {
            int lcount = 0;
            int i = start - 1;
            while (i >= 0) {
                if (item.getString().charAt(i) != '\\') break;
                ++lcount;
                --i;
            }
            if (lcount % 2 == 1) {
                retval = true;
            }
        }
        return retval;
    }

    private class IntermediateOption {
        String name = null;
        String group = null;
        String type = null;
        Collection<String> allowedVals = null;
        Boolean hasMultiArgs = false;
        List<String> tupleSeparators = new ArrayList<String>();
        List<String> keyValueSeparators = new ArrayList<String>();
        List<String> envVarSeparators = new ArrayList<String>();
        IToolOptions.EditorType editorType = null;
        List<String> editorArgs = null;
        Set<String> roles = null;
        String description = null;
        String argument = null;

        private IntermediateOption() {
        }

        void init(String optname) throws Exception {
            this.name = optname;
            this.group = (String)ToolInfoOptions.this.mtd_TIS_getDocSectionFor.invoke(ToolInfoOptions.this.obj_LTIS, optname);
            Object optLevel = ToolInfoOptions.this.mtd_TIS_getOptionLevelFor.invoke(ToolInfoOptions.this.obj_LTIS, optname);
            Enum[] enumArray = (Enum[])ToolInfoOptions.this.cl_OptionLevel.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum enum_OptLvl = enumArray[n2];
                if (enum_OptLvl.equals(optLevel)) {
                    this.type = (String)ToolInfoOptions.this.optionTypeToConstantMapping.get(enum_OptLvl.name());
                }
                ++n2;
            }
            this.roles = (Set)ToolInfoOptions.this.mtd_TIS_getArgumentRolesFor.invoke(ToolInfoOptions.this.obj_LTIS, this.name);
            this.argument = (String)ToolInfoOptions.this.mtd_TIS_getParameterDescriptionFor.invoke(ToolInfoOptions.this.obj_LTIS, optname);
            if (this.argument != null && this.argument.length() < 1) {
                this.argument = null;
            }
            this.description = (String)ToolInfoOptions.this.mtd_TIS_getDescriptionFor.invoke(ToolInfoOptions.this.obj_LTIS, optname);
            Object ast = ToolInfoOptions.this.mtd_TIS_getSyntaxTreeFor.invoke(ToolInfoOptions.this.obj_LTIS, optname);
            new ASTParser(ast, false);
            this.determineEditorType();
            this.determineEditorArgs();
        }

        void determineSeparators() throws Exception {
            if (this.editorType == null) {
                throw new Exception("Editor type not determined yet. Run method 'determineSettingEditorType' first.");
            }
            if (this.editorType.equals((Object)IToolOptions.EditorType.STRING_LIST)) {
                List sepas = (List)ToolInfoOptions.this.mtd_TIS_getSeparatorsFor.invoke(ToolInfoOptions.this.obj_LTIS, this.name);
                if (sepas != null) {
                    this.tupleSeparators.addAll(sepas);
                } else {
                    this.tupleSeparators.clear();
                }
            } else if (this.editorType.equals((Object)IToolOptions.EditorType.LIST_SELECTION) && this.hasMultiArgs.booleanValue()) {
                this.tupleSeparators.add(" ");
            } else {
                this.tupleSeparators.clear();
            }
        }

        void determineEditorType() {
            if (this.name.equals("agentlib")) {
                this.editorType = IToolOptions.EditorType.AGENTLIB;
                ToolInfoOptions toolInfoOptions = ToolInfoOptions.this;
                toolInfoOptions.cAgentlibSE = toolInfoOptions.cAgentlibSE + 1;
            } else if (this.name.equals("target")) {
                this.editorType = IToolOptions.EditorType.LIST_SELECTION;
                ToolInfoOptions toolInfoOptions = ToolInfoOptions.this;
                toolInfoOptions.cListSE = toolInfoOptions.cListSE + 1;
            } else if (this.allowedVals != null && this.allowedVals.size() == 2 && this.allowedVals.contains("true") && this.allowedVals.contains("false") && !this.hasMultiArgs.booleanValue()) {
                this.editorType = IToolOptions.EditorType.BOOLEAN;
                ToolInfoOptions toolInfoOptions = ToolInfoOptions.this;
                toolInfoOptions.cBoolSE = toolInfoOptions.cBoolSE + 1;
            } else if (this.allowedVals == null && this.hasMultiArgs.booleanValue()) {
                this.editorType = IToolOptions.EditorType.STRING_LIST;
                ToolInfoOptions toolInfoOptions = ToolInfoOptions.this;
                toolInfoOptions.cStringListSE = toolInfoOptions.cStringListSE + 1;
            } else if (this.allowedVals != null && this.allowedVals.size() > 0) {
                this.editorType = IToolOptions.EditorType.LIST_SELECTION;
                ToolInfoOptions toolInfoOptions = ToolInfoOptions.this;
                toolInfoOptions.cListSE = toolInfoOptions.cListSE + 1;
            } else {
                this.editorType = IToolOptions.EditorType.STRING;
                ToolInfoOptions toolInfoOptions = ToolInfoOptions.this;
                toolInfoOptions.cStringSE = toolInfoOptions.cStringSE + 1;
            }
        }

        void determineEditorArgs() throws Exception {
            if (this.editorType == null) {
                throw new Exception("Editor type not determined yet. Run method 'determineSettingEditorType' first.");
            }
            ArrayList<String> ediArgs = new ArrayList<String>();
            if (this.name.equals("target")) {
                ediArgs.addAll(ToolInfoOptions.this.distribution.getAvailableTargets());
            } else if (this.editorType.equals((Object)IToolOptions.EditorType.LIST_SELECTION)) {
                if (this.hasMultiArgs.booleanValue()) {
                    ediArgs.add("multi");
                }
                ediArgs.addAll(this.allowedVals);
            } else {
                if (this.roles.contains("file")) {
                    ediArgs.add("file");
                }
                if (this.roles.contains("directory")) {
                    ediArgs.add("directory");
                }
            }
            this.editorArgs = ediArgs.size() > 0 ? ediArgs : null;
        }

        public String toString() {
            return ">> Option: " + this.name + " <<\n" + "   Group: " + this.group + "\n" + "   Type: " + this.type + "\n" + "   Tuple-Seps: [" + this.tupleSeparators + "]\n" + "   KeyVal-Seps: [" + this.keyValueSeparators + "]\n" + "   EnvVar-Seps: [" + this.envVarSeparators + "]\n" + "   Arg: " + this.argument + "\n" + "   Desc: " + this.description + "\n" + "   Editor type: " + this.editorType + "\n" + "   Editor args: " + this.editorArgs + "\n" + "   MultiArgs: " + this.hasMultiArgs + "\n" + "   AllowedVals: " + this.allowedVals + "\n" + "   Roles: " + this.roles + "\n";
        }

        class ASTParser {
            private int rec_ = 0;
            private boolean debug_ = false;

            public ASTParser(Object ast) {
                this(ast, false);
            }

            public ASTParser(Object ast, boolean debug) {
                this.debug_ = debug;
                this.parse(ast);
            }

            private void parse(Object ast) {
                ++this.rec_;
                if (this.debug_ && this.rec_ < 2) {
                    System.out.println();
                }
                if (this.debug_) {
                    System.out.print(String.valueOf(IntermediateOption.this.name) + ": " + ast.getClass().getSimpleName() + " > ");
                }
                try {
                    if (ToolInfoOptions.this.cl_CollectionNode.isInstance(ast)) {
                        Object child = ToolInfoOptions.this.cl_CollectionNode.getMethod("getChild", null).invoke(ast, null);
                        Set argSeps = (Set)ToolInfoOptions.this.cl_CollectionNode.getMethod("getSeparators", null).invoke(ast, null);
                        Boolean uniqueElements = (Boolean)ToolInfoOptions.this.cl_CollectionNode.getMethod("hasUniqueElements", null).invoke(ast, null);
                        IntermediateOption.this.hasMultiArgs = true;
                        if (argSeps != null) {
                            IntermediateOption.this.tupleSeparators.addAll(argSeps);
                        }
                        if (this.debug_) {
                            System.out.print("Unique: " + uniqueElements + ", ");
                        }
                        if (this.debug_) {
                            System.out.println("Separators: " + argSeps);
                        }
                        this.parse(child);
                    } else if (ToolInfoOptions.this.cl_EnvBackedNode.isInstance(ast)) {
                        Object child = ToolInfoOptions.this.cl_EnvBackedNode.getMethod("getChild", null).invoke(ast, null);
                        String envSep = (String)ToolInfoOptions.this.cl_EnvBackedNode.getMethod("getSeparator", null).invoke(ast, null);
                        if (envSep != null && !envSep.isEmpty()) {
                            IntermediateOption.this.envVarSeparators.add(envSep);
                        }
                        if (this.debug_) {
                            System.out.println("Env-separator: [" + envSep + "]");
                        }
                        this.parse(child);
                    } else if (ToolInfoOptions.this.cl_FiniteLeaf.isInstance(ast)) {
                        Set vals;
                        IntermediateOption.this.allowedVals = vals = (Set)ToolInfoOptions.this.cl_FiniteLeaf.getMethod("getValues", null).invoke(ast, null);
                        if (this.debug_) {
                            System.out.println("Values: " + vals);
                        }
                    } else if (ToolInfoOptions.this.cl_MapNode.isInstance(ast)) {
                        String tupleSep;
                        Object keyChild = ToolInfoOptions.this.cl_MapNode.getMethod("getKeyChild", null).invoke(ast, null);
                        Object valueChild = ToolInfoOptions.this.cl_MapNode.getMethod("getValueChild", null).invoke(ast, null);
                        String keyValSep = (String)ToolInfoOptions.this.cl_MapNode.getMethod("getKeyValueSeparator", null).invoke(ast, null);
                        if (keyValSep != null && !keyValSep.isEmpty()) {
                            IntermediateOption.this.keyValueSeparators.add(keyValSep);
                        }
                        if ((tupleSep = (String)ToolInfoOptions.this.cl_MapNode.getMethod("getTupleSeparator", null).invoke(ast, null)) != null && !tupleSep.isEmpty()) {
                            IntermediateOption.this.tupleSeparators.add(tupleSep);
                        }
                        IntermediateOption.this.hasMultiArgs = true;
                        if (this.debug_) {
                            System.out.print("Keyval-Sep: [" + keyValSep + "], ");
                        }
                        if (this.debug_) {
                            System.out.println("Tuple-Sep: [" + tupleSep + "]");
                        }
                        this.parse(keyChild);
                        this.parse(valueChild);
                    } else if (ToolInfoOptions.this.cl_ProductNode.isInstance(ast)) {
                        Object leftChild = ToolInfoOptions.this.cl_ProductNode.getMethod("getLeftChild", null).invoke(ast, null);
                        Object rightChild = ToolInfoOptions.this.cl_ProductNode.getMethod("getRightChild", null).invoke(ast, null);
                        String sepa = (String)ToolInfoOptions.this.cl_ProductNode.getMethod("getSeparator", null).invoke(ast, null);
                        if (this.debug_) {
                            System.out.println("Separator: [" + sepa + "]");
                        }
                        this.parse(leftChild);
                        this.parse(rightChild);
                    } else if (ToolInfoOptions.this.cl_SimpleLeaf.isInstance(ast)) {
                        Set rls;
                        IntermediateOption.this.roles = rls = (Set)ToolInfoOptions.this.cl_SimpleLeaf.getMethod("getRoles", null).invoke(ast, null);
                        IntermediateOption.this.allowedVals = null;
                        if (this.debug_) {
                            System.out.println("Roles: " + rls);
                        }
                    } else if (ToolInfoOptions.this.cl_SumNode.isInstance(ast)) {
                        List children = (List)ToolInfoOptions.this.cl_SumNode.getMethod("getChildren", null).invoke(ast, null);
                        if (this.debug_) {
                            System.out.println();
                        }
                        for (Object child : children) {
                            this.parse(child);
                        }
                    }
                }
                catch (Exception e) {
                    LauncherPlugin.log(e);
                }
                if (this.debug_ && this.rec_ < 2) {
                    System.out.println("   -----------   ");
                }
                --this.rec_;
            }
        }
    }
}

