/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.vm;

import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.vm.LaunchingMessages;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamaicaVMRunner
extends AbstractVMRunner {
    protected IVMInstall myVMInstallInstance;

    public JamaicaVMRunner(IVMInstall vmInstance) {
        this.myVMInstallInstance = vmInstance;
    }

    public String getPluginIdentifier() {
        return "com.aicas.jamaica.eclipse.launcher";
    }

    protected String constructProgramString(VMRunnerConfiguration config, String launchMode) throws CoreException {
        String command = null;
        String vmTypeString = null;
        String vmBinaryName = null;
        Map map = config.getVMSpecificAttributesMap();
        if (map != null) {
            vmTypeString = (String)map.get("com.aicas.jamaica.eclipse.launcher.vm.VM_TYPE");
            if (AbstractJamaicaDistribution.VMType.ALTERNATE.name().equals(vmTypeString)) {
                vmBinaryName = (String)map.get("com.aicas.jamaica.eclipse.launcher.vm.VM_BINARY_NAME");
            }
        }
        AbstractJamaicaDistribution.VMType vmType = null;
        JamaicaVMDistribution dist = JamaicaVMDistribution.findOrSetup(LauncherPlugin.normalize(this.myVMInstallInstance.getInstallLocation().getAbsolutePath()));
        if (dist != null) {
            vmType = vmTypeString == null ? ("debug".equals(launchMode) ? AbstractJamaicaDistribution.VMType.VM_DEBUG_INTERFACE : (dist.getVM(AbstractJamaicaDistribution.VMType.VM_DEFAULT) != null ? AbstractJamaicaDistribution.VMType.VM_DEFAULT : AbstractJamaicaDistribution.VMType.VM_SLIM)) : AbstractJamaicaDistribution.VMType.valueOf((String)vmTypeString);
            if (!vmType.equals((Object)AbstractJamaicaDistribution.VMType.ALTERNATE)) {
                command = dist.getVM(vmType);
            } else {
                String exePath = LauncherPlugin.normalize(String.valueOf(dist.getTargetBinDirectory(dist.getHostTarget())) + "/" + vmBinaryName);
                if (new File(exePath).exists()) {
                    command = exePath;
                }
            }
            if (command != null) {
                return command;
            }
        }
        this.abort(MessageFormat.format(LaunchingMessages.JamaicaVMRunner_JamaicaVM_executable___1___not_found_for_VM___2__, vmType.name(), this.myVMInstallInstance.getName()), null, 150);
        return null;
    }

    public void run(VMRunnerConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.common_Launching_JamaicaVM, 2);
        subMonitor.subTask(LaunchingMessages.common_Constructing_command_line);
        String program = this.constructProgramString(config, launch.getLaunchMode());
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(program);
        String[] allVMArgs = this.combineVmArgs(config, this.myVMInstallInstance);
        this.addArguments(allVMArgs, arguments);
        String[] cp = config.getClassPath();
        if (cp.length > 0) {
            arguments.add("-classpath");
            arguments.add(this.convertClasspath(cp));
        }
        arguments.add(config.getClassToLaunch());
        String[] programArgs = config.getProgramArguments();
        this.addArguments(programArgs, arguments);
        String[] cmdLine = new String[arguments.size()];
        arguments.toArray(cmdLine);
        ILaunchConfiguration lc = launch.getLaunchConfiguration();
        boolean appendNativeEnvs = lc != null ? lc.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true) : true;
        String[] envp = this.mergeEnvironment(config.getEnvironment(), appendNativeEnvs, this.myVMInstallInstance.getInstallLocation().toString());
        subMonitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        subMonitor.subTask(LaunchingMessages.common_Starting_JamaicaVM);
        Process p = null;
        File workingDir = this.getWorkingDir(config);
        p = this.exec(cmdLine, workingDir, envp);
        if (p == null) {
            return;
        }
        if (monitor.isCanceled()) {
            p.destroy();
            return;
        }
        IProcess process = this.newProcess(launch, p, this.renderProcessLabel(cmdLine), this.getDefaultProcessMap());
        process.setAttribute(IProcess.ATTR_CMDLINE, this.join(cmdLine, ' '));
        subMonitor.worked(1);
        subMonitor.done();
    }

    protected boolean getJamaicaSpecificFlag(VMRunnerConfiguration config, String name, boolean defaultValue) {
        Map jamaicaSpecificAttributes = config.getVMSpecificAttributesMap();
        boolean flag = defaultValue;
        if (jamaicaSpecificAttributes != null && jamaicaSpecificAttributes.get(name) != null) {
            flag = Boolean.parseBoolean((String)jamaicaSpecificAttributes.get(name));
        }
        return flag;
    }

    protected void addArguments(String[] s, List<String> l) {
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String curString = stringArray[n2];
            l.add(curString);
            ++n2;
        }
    }

    protected String join(String[] array, char delimiter) {
        StringBuffer buffer = new StringBuffer();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            buffer.append(s);
            buffer.append(delimiter);
            ++n2;
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    protected String convertClasspath(String[] cp) {
        return this.join(cp, File.pathSeparatorChar);
    }

    protected File getWorkingDir(VMRunnerConfiguration config) throws CoreException {
        String path = config.getWorkingDirectory();
        if (path == null) {
            return null;
        }
        File dir = new File(path);
        if (!dir.isDirectory()) {
            this.abort(LaunchingMessages.JamaicaVMRunner_Working_directory_does_not_exist, null, 108);
        }
        return dir;
    }

    protected String[] mergeEnvironment(String[] configEnvs, boolean appendNativeEnvs, String jamaica) {
        int numOfEnvs = configEnvs == null ? 0 : configEnvs.length;
        Map nativeEnvs = null;
        if (appendNativeEnvs) {
            nativeEnvs = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
            numOfEnvs += nativeEnvs == null ? 0 : nativeEnvs.size();
        }
        String[] envs = new String[++numOfEnvs];
        int idx = 0;
        if (appendNativeEnvs && nativeEnvs != null) {
            for (String envName : nativeEnvs.keySet()) {
                if (envName.startsWith("Path")) {
                    String s = (String)nativeEnvs.get(envName);
                    StringTokenizer st = new StringTokenizer(s, ";");
                    StringBuilder sb = new StringBuilder("");
                    while (st.hasMoreTokens()) {
                        String tmp = st.nextToken();
                        if (tmp.contains("jre") && tmp.contains("bin")) continue;
                        sb.append(String.valueOf(tmp) + ";");
                    }
                    s = sb.toString();
                    envs[idx++] = String.valueOf(envName) + '=' + s;
                    continue;
                }
                envs[idx++] = String.valueOf(envName) + '=' + (String)nativeEnvs.get(envName);
            }
        }
        if (configEnvs != null) {
            int i = 0;
            while (i < configEnvs.length) {
                envs[idx++] = configEnvs[i];
                ++i;
            }
        }
        envs[idx] = "JAMAICA=" + jamaica;
        return envs;
    }

    protected String renderProcessLabel(String[] cmdLine) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getDateTimeInstance(2, 2).format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, cmdLine[0], timestamp);
    }
}

