/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.dialog;

import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.dialog.DialogMessages;
import com.aicas.jamaica.eclipse.launcher.dialog.SWTDialogFactory;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamaicaEnvironmentTab
extends AbstractLaunchConfigurationTab {
    private HashMap<String, String> map;
    private Text heapText;
    private Text maxHeapText;
    private Text heapSizeIncrementText;
    private Text javaStackText;
    private Text nativeStacktext;
    private Text numThreadsText;
    private Text maxNumThreadText;
    private Text numJniThreadsText;
    private Text finalizerPriText;
    private Text primapText;
    private Text analyseText;
    private Text reservedMemoryText;
    private Text scopedSizeText;
    private Text immortalSizeText;
    private Text profileFileNameText;
    private Combo lazyCombo;
    private Combo strictRtsjCombo;
    private Combo schedulingCombo;
    private GridLayout gridLayout;
    private GridData gridData;
    private Label label;
    private Group memoryGroup;
    private Group rtsjGroup;
    private Group otherGroup;
    private Group threadGroup;
    private static String JAMAICAVM_HEAPSIZE = "2M";
    private static String JAMAICAVM_MAXHEAPSIZE = "768M";
    private static String JAMAICAVM_HEAPSIZEINCREMENT = "4M";
    private static String JAMAICAVM_JAVA_STACKSIZE = "64K";
    private static String JAMAICAVM_NATIVE_STACKSIZE = "128K";
    private static int JAMAICAVM_NUMTHREADS = 10;
    private static int JAMAICAVM_MAXNUMTHREADS = 511;
    private static int JAMAICAVM_NUMJNITHREADS = 0;
    private static int JAMAICAVM_FINALIZERPRI = 10;
    private static String JAMAICAVM_PRIMAP = "";
    private static int JAMAICAVM_ANALYSE = 0;
    private static int JAMAICAVM_RESERVEDMEMORY = 10;
    private static int JAMAICAVM_SCOPEDSIZE = 0;
    private static String JAMAICAVM_IMMORTALSIZE = "4M";
    private static boolean JAMAICAVM_LAZY = true;
    private static boolean JAMAICAVM_STRICTRTSJ = false;
    private static JamaicaScheduling JAMAICAVM_SCHEDULING = JamaicaScheduling.OTHER;
    private static String JAMAICAVM_PROFILEFILENAME = "";
    private final KeyListener keyListener = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            if (e.getSource().equals(JamaicaEnvironmentTab.this.maxHeapText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_MAXHEAPSIZE", JamaicaEnvironmentTab.this.maxHeapText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.heapText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_HEAPSIZE", JamaicaEnvironmentTab.this.heapText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.heapSizeIncrementText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_HEAPSIZEINCREMENT", JamaicaEnvironmentTab.this.heapSizeIncrementText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.javaStackText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_JAVA_STACKSIZE", JamaicaEnvironmentTab.this.javaStackText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.nativeStacktext)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_NATIVE_STACKSIZE", JamaicaEnvironmentTab.this.nativeStacktext.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.numThreadsText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_NUMTHREADS", JamaicaEnvironmentTab.this.numThreadsText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.maxNumThreadText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_MAXNUMTHREADS", JamaicaEnvironmentTab.this.maxNumThreadText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.numJniThreadsText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_NUMJNITHREADS", JamaicaEnvironmentTab.this.numJniThreadsText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.finalizerPriText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_FINALIZERPRI", JamaicaEnvironmentTab.this.finalizerPriText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.primapText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_PRIMAP", JamaicaEnvironmentTab.this.primapText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.analyseText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_ANALYSE", JamaicaEnvironmentTab.this.analyseText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.reservedMemoryText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_RESERVEDMEMORY", JamaicaEnvironmentTab.this.reservedMemoryText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.scopedSizeText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_SCOPEDSIZE", JamaicaEnvironmentTab.this.scopedSizeText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.immortalSizeText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_IMMORTALSIZE", JamaicaEnvironmentTab.this.immortalSizeText.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.profileFileNameText)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_PROFILEFILENAME", JamaicaEnvironmentTab.this.profileFileNameText.getText());
            }
            JamaicaEnvironmentTab.this.updateLaunchConfigurationDialog();
        }
    };
    SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource().equals(JamaicaEnvironmentTab.this.lazyCombo)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_LAZY", JamaicaEnvironmentTab.this.lazyCombo.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.strictRtsjCombo)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_STRICTRTSJ", JamaicaEnvironmentTab.this.strictRtsjCombo.getText());
            } else if (e.getSource().equals(JamaicaEnvironmentTab.this.schedulingCombo)) {
                JamaicaEnvironmentTab.this.replaceEntry("JAMAICAVM_SCHEDULING", JamaicaEnvironmentTab.this.schedulingCombo.getText());
            }
            JamaicaEnvironmentTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.gridLayout = new GridLayout(2, true);
        comp.setLayout((Layout)this.gridLayout);
        comp.setFont(font);
        this.gridData = new GridData();
        this.gridData.horizontalAlignment = 2;
        this.gridData.grabExcessVerticalSpace = true;
        comp.setLayoutData((Object)this.gridData);
        this.setControl((Control)comp);
        this.label = new Label(comp, 0);
        this.gridData = new GridData();
        this.gridData.horizontalSpan = 2;
        this.label.setLayoutData((Object)this.gridData);
        this.label.setText("Set JamaicaVM specific environment variables");
        this.label = new Label(comp, 0);
        this.gridData = new GridData();
        this.gridData.horizontalSpan = 2;
        this.label.setLayoutData((Object)this.gridData);
        this.label.setText(DialogMessages.JamaicaEnvironmentTab_Warning_Variables_will_be_overwritten);
        this.label.setFont(new Font((Device)Display.getDefault(), "null", 8, 0));
        this.rtsjGroup = new Group(comp, 0);
        this.gridLayout = new GridLayout(2, true);
        this.rtsjGroup.setLayout((Layout)this.gridLayout);
        this.rtsjGroup.setFont(font);
        this.rtsjGroup.setText(DialogMessages.JamaicaEnvironmentTab_group_rtsj);
        this.gridData = new GridData();
        this.gridData.verticalAlignment = 128;
        this.gridData.horizontalAlignment = 128;
        this.rtsjGroup.setLayoutData((Object)this.gridData);
        this.label = new Label((Composite)this.rtsjGroup, 0);
        this.label.setText(DialogMessages.JamaicaEnvironmentTab_rtsj_group_description);
        this.gridData = new GridData();
        this.gridData.horizontalSpan = 2;
        this.label.setLayoutData((Object)this.gridData);
        this.immortalSizeText = SWTDialogFactory.createText((Composite)this.rtsjGroup, DialogMessages.JamaicaEnvironmentTab_immortal_memory, this.keyListener);
        this.scopedSizeText = SWTDialogFactory.createText((Composite)this.rtsjGroup, DialogMessages.JamaicaEnvironmentTab_scoped_memory, this.keyListener);
        this.reservedMemoryText = SWTDialogFactory.createText((Composite)this.rtsjGroup, DialogMessages.JamaicaEnvironmentTab_reserved_memory, this.keyListener);
        this.finalizerPriText = SWTDialogFactory.createText((Composite)this.rtsjGroup, DialogMessages.JamaicaEnvironmentTab_finalizer_pri, this.keyListener);
        this.primapText = SWTDialogFactory.createText((Composite)this.rtsjGroup, DialogMessages.JamaicaEnvironmentTab_primap, this.keyListener);
        this.label = new Label((Composite)this.rtsjGroup, 0);
        this.label = new Label((Composite)this.rtsjGroup, 0);
        this.label.setText("e.g., 1..11=50,12..39=51..78,40=85");
        this.label.setFont(new Font((Device)Display.getDefault(), "null", 8, 0));
        this.strictRtsjCombo = SWTDialogFactory.createBooleanOptionCombo((Composite)this.rtsjGroup, DialogMessages.JamaicaEnvironmentTab_strict_rtsj, this.selectionListener);
        this.memoryGroup = new Group(comp, 0);
        this.gridLayout = new GridLayout(2, true);
        this.memoryGroup.setLayout((Layout)this.gridLayout);
        this.memoryGroup.setFont(font);
        this.memoryGroup.setText(DialogMessages.JamaicaEnvironmentTab_group_memory);
        this.gridData = new GridData();
        this.gridData.verticalAlignment = 128;
        this.gridData.horizontalAlignment = 128;
        this.memoryGroup.setLayoutData((Object)this.gridData);
        this.label = new Label((Composite)this.memoryGroup, 0);
        this.gridData = new GridData();
        this.gridData.horizontalSpan = 2;
        this.label.setLayoutData((Object)this.gridData);
        this.label.setText(DialogMessages.JamaicaEnvironmentTab_memory_group_description);
        this.heapText = SWTDialogFactory.createText((Composite)this.memoryGroup, DialogMessages.JamaicaEnvironmentTab_heap_size, this.keyListener);
        this.maxHeapText = SWTDialogFactory.createText((Composite)this.memoryGroup, DialogMessages.JamaicaEnvironmentTab_max_heap_size, this.keyListener);
        this.heapSizeIncrementText = SWTDialogFactory.createText((Composite)this.memoryGroup, DialogMessages.JamaicaEnvironmentTab_inc_heap_size, this.keyListener);
        this.javaStackText = SWTDialogFactory.createText((Composite)this.memoryGroup, DialogMessages.JamaicaEnvironmentTab_java_stack_size, this.keyListener);
        this.nativeStacktext = SWTDialogFactory.createText((Composite)this.memoryGroup, DialogMessages.JamaicaEnvironmentTab_native_stack_size, this.keyListener);
        this.label = new Label((Composite)this.memoryGroup, 0);
        this.gridData = new GridData();
        this.gridData.horizontalSpan = 2;
        this.gridData.verticalSpan = 10;
        this.label.setLayoutData((Object)this.gridData);
        this.threadGroup = new Group(comp, 0);
        this.gridLayout = new GridLayout(2, true);
        this.threadGroup.setLayout((Layout)this.gridLayout);
        this.threadGroup.setFont(font);
        this.threadGroup.setText(DialogMessages.JamaicaEnvironmentTab_group_threads);
        this.gridData = new GridData();
        this.gridData.verticalAlignment = 128;
        this.gridData.horizontalAlignment = 128;
        this.threadGroup.setLayoutData((Object)this.gridData);
        this.label = new Label((Composite)this.threadGroup, 0);
        this.label.setText(DialogMessages.JamaicaEnvironmentTab_thread_group_description);
        this.gridData = new GridData();
        this.gridData.horizontalSpan = 2;
        this.label.setLayoutData((Object)this.gridData);
        this.numThreadsText = SWTDialogFactory.createText((Composite)this.threadGroup, DialogMessages.JamaicaEnvironmentTab_num_threads, this.keyListener);
        this.maxNumThreadText = SWTDialogFactory.createText((Composite)this.threadGroup, DialogMessages.JamaicaEnvironmentTab_max_num_threads, this.keyListener);
        this.numJniThreadsText = SWTDialogFactory.createText((Composite)this.threadGroup, DialogMessages.JamaicaEnvironmentTab_num_jni_threads, this.keyListener);
        this.otherGroup = new Group(comp, 0);
        this.gridLayout = new GridLayout(3, false);
        this.otherGroup.setLayout((Layout)this.gridLayout);
        this.otherGroup.setFont(font);
        this.otherGroup.setText(DialogMessages.JamaicaEnvironmentTab_group_other);
        this.gridData = new GridData();
        this.gridData.verticalAlignment = 128;
        this.gridData.horizontalAlignment = 128;
        this.otherGroup.setLayoutData((Object)this.gridData);
        this.label = new Label((Composite)this.otherGroup, 0);
        this.label.setText(DialogMessages.JamaicaEnvironmentTab_other_group_description);
        this.gridData = new GridData();
        this.gridData.horizontalSpan = 3;
        this.label.setLayoutData((Object)this.gridData);
        this.analyseText = SWTDialogFactory.createText((Composite)this.otherGroup, DialogMessages.JamaicaEnvironmentTab_analyse, this.keyListener);
        this.label = new Label((Composite)this.otherGroup, 0);
        this.lazyCombo = SWTDialogFactory.createBooleanOptionCombo((Composite)this.otherGroup, DialogMessages.JamaicaEnvironmentTab_lazy, this.selectionListener);
        this.label = new Label((Composite)this.otherGroup, 0);
        this.schedulingCombo = SWTDialogFactory.createEnumOptionCombo((Composite)this.otherGroup, DialogMessages.JamaicaEnvironmentTab_scheduling, this.selectionListener);
        this.label = new Label((Composite)this.otherGroup, 0);
        this.profileFileNameText = SWTDialogFactory.createTextWithFileDialog((Composite)this.otherGroup, DialogMessages.JamaicaEnvironmentTab_profilefilename, this.keyListener);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        HashMap<String, String> m = null;
        try {
            if (configuration.getAttribute("com.aicas.jamaica.eclipse.launcher.jamaicavm_map", null) != null) {
                m = (HashMap)configuration.getAttribute("com.aicas.jamaica.eclipse.launcher.jamaicavm_map", null);
            } else if (m == null || m.isEmpty()) {
                m = JamaicaEnvironmentTab.fillMap();
                this.setMap(m);
            }
        }
        catch (CoreException e) {
            LauncherPlugin.getDefault();
            LauncherPlugin.log(e.toString());
        }
        configuration.setAttribute("com.aicas.jamaica.eclipse.launcher.jamaicavm_map", this.getMap());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.setMap((HashMap)configuration.getAttribute("com.aicas.jamaica.eclipse.launcher.jamaicavm_map", null));
            this.heapText.setText(this.getMap().get("JAMAICAVM_HEAPSIZE") != null ? this.getMap().get("JAMAICAVM_HEAPSIZE") : "");
            this.maxHeapText.setText(this.getMap().get("JAMAICAVM_MAXHEAPSIZE") != null ? this.getMap().get("JAMAICAVM_MAXHEAPSIZE") : "");
            this.heapSizeIncrementText.setText(this.getMap().get("JAMAICAVM_HEAPSIZEINCREMENT") != null ? this.getMap().get("JAMAICAVM_HEAPSIZEINCREMENT") : "");
            this.javaStackText.setText(this.getMap().get("JAMAICAVM_JAVA_STACKSIZE") != null ? this.getMap().get("JAMAICAVM_JAVA_STACKSIZE") : "");
            this.nativeStacktext.setText(this.getMap().get("JAMAICAVM_NATIVE_STACKSIZE") != null ? this.getMap().get("JAMAICAVM_NATIVE_STACKSIZE") : "");
            this.numThreadsText.setText(this.getMap().get("JAMAICAVM_NUMTHREADS"));
            this.maxNumThreadText.setText(this.getMap().get("JAMAICAVM_MAXNUMTHREADS"));
            this.numJniThreadsText.setText(this.getMap().get("JAMAICAVM_NUMJNITHREADS"));
            this.finalizerPriText.setText(this.getMap().get("JAMAICAVM_FINALIZERPRI"));
            this.primapText.setText(this.getMap().get("JAMAICAVM_PRIMAP") != null ? this.getMap().get("JAMAICAVM_PRIMAP") : "");
            this.analyseText.setText(this.getMap().get("JAMAICAVM_ANALYSE"));
            this.reservedMemoryText.setText(this.getMap().get("JAMAICAVM_RESERVEDMEMORY"));
            this.scopedSizeText.setText(this.getMap().get("JAMAICAVM_SCOPEDSIZE"));
            this.immortalSizeText.setText(this.getMap().get("JAMAICAVM_IMMORTALSIZE") != null ? this.getMap().get("JAMAICAVM_IMMORTALSIZE") : "");
            this.lazyCombo.select(this.getMap().get("JAMAICAVM_LAZY").equals("true") ? 0 : 1);
            this.strictRtsjCombo.select(this.getMap().get("JAMAICAVM_STRICTRTSJ").equals("true") ? 0 : 1);
            this.schedulingCombo.select(this.getMap().get("JAMAICAVM_SCHEDULING").equals(JamaicaScheduling.OTHER.getName()) ? JamaicaScheduling.OTHER.getIndex() : (this.getMap().get("JAMAICAVM_SCHEDULING").equals(JamaicaScheduling.RR.getName()) ? JamaicaScheduling.RR.getIndex() : JamaicaScheduling.FIFO.getIndex()));
            this.profileFileNameText.setText(this.getMap().get("JAMAICAVM_PROFILEFILENAME") != null ? this.getMap().get("JAMAICAVM_PROFILEFILENAME") : "");
        }
        catch (CoreException ce) {
            LauncherPlugin.getDefault();
            LauncherPlugin.log(ce.toString());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.aicas.jamaica.eclipse.launcher.jamaicavm_map", this.getMap());
    }

    public String getName() {
        return DialogMessages.JamaicaEnvironmentTab_environment_tab_get_name;
    }

    public HashMap<String, String> getMap() {
        return this.map;
    }

    public void setMap(HashMap<String, String> map) {
        this.map = map;
    }

    private static HashMap<String, String> fillMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("JAMAICAVM_HEAPSIZE", JAMAICAVM_HEAPSIZE);
        map.put("JAMAICAVM_MAXHEAPSIZE", JAMAICAVM_MAXHEAPSIZE);
        map.put("JAMAICAVM_HEAPSIZEINCREMENT", JAMAICAVM_HEAPSIZEINCREMENT);
        map.put("JAMAICAVM_JAVA_STACKSIZE", JAMAICAVM_JAVA_STACKSIZE);
        map.put("JAMAICAVM_NATIVE_STACKSIZE", JAMAICAVM_NATIVE_STACKSIZE);
        map.put("JAMAICAVM_NUMTHREADS", String.valueOf(JAMAICAVM_NUMTHREADS));
        map.put("JAMAICAVM_MAXNUMTHREADS", String.valueOf(JAMAICAVM_MAXNUMTHREADS));
        map.put("JAMAICAVM_NUMJNITHREADS", String.valueOf(JAMAICAVM_NUMJNITHREADS));
        map.put("JAMAICAVM_FINALIZERPRI", String.valueOf(JAMAICAVM_FINALIZERPRI));
        map.put("JAMAICAVM_PRIMAP", JAMAICAVM_PRIMAP);
        map.put("JAMAICAVM_ANALYSE", String.valueOf(JAMAICAVM_ANALYSE));
        map.put("JAMAICAVM_RESERVEDMEMORY", String.valueOf(JAMAICAVM_RESERVEDMEMORY));
        map.put("JAMAICAVM_SCOPEDSIZE", String.valueOf(JAMAICAVM_SCOPEDSIZE));
        map.put("JAMAICAVM_IMMORTALSIZE", JAMAICAVM_IMMORTALSIZE);
        map.put("JAMAICAVM_LAZY", String.valueOf(JAMAICAVM_LAZY));
        map.put("JAMAICAVM_STRICTRTSJ", String.valueOf(JAMAICAVM_STRICTRTSJ));
        map.put("JAMAICAVM_SCHEDULING", JAMAICAVM_SCHEDULING.toString());
        map.put("JAMAICAVM_PROFILEFILENAME", JAMAICAVM_PROFILEFILENAME);
        return map;
    }

    private void removeEntry(String option) {
        if (this.getMap().containsKey(option)) {
            this.getMap().remove(option);
        }
    }

    private void replaceEntry(String option, String newValue) {
        this.removeEntry(option);
        this.getMap().put(option, newValue);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.analyseText.getText().equals("") || Integer.parseInt(this.analyseText.getText()) < 0 || Integer.parseInt(this.analyseText.getText()) > 100) {
            this.setErrorMessage(DialogMessages.JamaicaEnvironmentTab_analyse_error);
            return false;
        }
        if (this.reservedMemoryText.getText().equals("") || Integer.parseInt(this.reservedMemoryText.getText()) < 0 || Integer.parseInt(this.reservedMemoryText.getText()) > 100) {
            this.setErrorMessage(DialogMessages.JamaicaEnvironmentTab_reserved_memory_error);
            return false;
        }
        if (this.numThreadsText.getText().equals("") || this.numThreadsText.getText().equals("0")) {
            this.setErrorMessage(DialogMessages.JamaicaEnvironmentTab_num_threads_error);
            return false;
        }
        if (this.maxNumThreadText.getText().equals("") || Integer.parseInt(this.maxNumThreadText.getText()) < Integer.parseInt(this.numThreadsText.getText())) {
            this.setErrorMessage(DialogMessages.JamaicaEnvironmentTab_max_num_threads_error);
            return false;
        }
        if (this.numJniThreadsText.getText().equals("")) {
            this.setErrorMessage(DialogMessages.JamaicaEnvironmentTab_num_jni_threads_error);
            return false;
        }
        if (this.finalizerPriText.getText().equals("0")) {
            this.setErrorMessage(DialogMessages.JamaicaEnvironmentTab_finaliter_pri_error);
            return false;
        }
        if (this.scopedSizeText.getText().equals("")) {
            this.setErrorMessage(DialogMessages.JamaicaEnvironmentTab_scoped_memory_error);
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum JamaicaScheduling {
        OTHER(DialogMessages.JamaicaEnvironmentTab_scheduling_other, 0),
        RR(DialogMessages.JamaicaEnvironmentTab_scheduling_roundrobin, 1),
        FIFO(DialogMessages.JamaicaEnvironmentTab_scheduling_fifo, 2);

        String name;
        int index;

        private JamaicaScheduling(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

