/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher;

import com.aicas.jamaica.Option;
import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.AbstractQuoteEscapedOptions;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.Messages;
import com.aicas.jamaica.range.BooleanRange;
import com.aicas.jamaica.range.ListRange;
import com.aicas.jamaica.range.Range;
import com.aicas.jamaica.range.StringRangeDirectory;
import com.aicas.jamaica.range.StringRangeFile;
import com.aicas.jamaica.range.StringRangeFromList;
import com.aicas.jamaica.range.StringRangeSomeFromList;
import com.aicas.jamaica.tools.xml.BoxiParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxiOptions
extends AbstractQuoteEscapedOptions {
    public static final String DESC_DEFAULT_TAG = "@DEFAULT@";
    public static final int DESC_DEFAULT_TAG_LENGTH = "@DEFAULT@".length();
    public static final String DESC_DEFAULT_IMMEDIATE_TAG = "@DEFAULT:";
    public static final int DESC_DEFAULT_IMMEDIATE_TAG_LENGTH = "@DEFAULT:".length();
    private JamaicaVMDistribution distribution;
    private String toolClasspath;
    private String toolPath;
    private Map<String, Option> options;
    private List<String> groups;
    private Map<String, Properties> defaultValues;

    public PossiblyEscapedString getDefaultValue(String optionName, String targetName) {
        PossiblyEscapedString retval = null;
        if (!this.options.containsKey(optionName)) {
            retval = null;
        } else if (optionName.equals("target")) {
            String host = this.distribution.getHostTarget();
            if (host != null) {
                retval = PossiblyEscapedString.plain((String)host);
            }
        } else {
            String t = targetName == null ? this.distribution.getHostTarget() : targetName;
            String optDefVal = this.defaultValues.containsKey(t) ? this.defaultValues.get(t).getProperty(optionName) : null;
            Option opt = this.options.get(optionName);
            if (opt.getRange().getClass().equals(Range.BOOLEAN_VALUE.getClass()) && (optDefVal == null || optDefVal.isEmpty())) {
                optDefVal = Boolean.toString(Boolean.parseBoolean(optDefVal));
            }
            if (optDefVal != null) {
                retval = PossiblyEscapedString.plain((String)optDefVal);
            }
        }
        return retval;
    }

    public List<String> getAvailableGroups() {
        return this.groups;
    }

    public String getGroup(String optionName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        return this.options.get(optionName).getGroup();
    }

    public String getType(String optionName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        return this.options.get(optionName).getType();
    }

    public String getDescription(String optionName, String targetName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        StringBuffer desc = new StringBuffer(this.options.get(optionName).getDescription());
        int dtPos = desc.indexOf(DESC_DEFAULT_TAG);
        if (dtPos >= 0) {
            String defaultValue = this.getDefaultValue(optionName, targetName).getString();
            desc.replace(dtPos, dtPos + DESC_DEFAULT_TAG_LENGTH, defaultValue == null ? "" : String.valueOf('\n') + MessageFormat.format(Messages.BoxiOptions_Default___1, defaultValue));
        } else {
            int dtiStartPos = desc.indexOf(DESC_DEFAULT_IMMEDIATE_TAG);
            if (dtiStartPos >= 0) {
                int dtiEndPos = desc.indexOf("@", dtiStartPos + DESC_DEFAULT_IMMEDIATE_TAG_LENGTH);
                if (dtiEndPos < 0) {
                    dtiEndPos = desc.length();
                }
                String defaultValue = desc.substring(dtiStartPos + DESC_DEFAULT_IMMEDIATE_TAG_LENGTH, dtiEndPos);
                desc.replace(dtiStartPos, dtiEndPos + 1, String.valueOf('\n') + MessageFormat.format(Messages.BoxiOptions_Default___1, defaultValue));
            }
        }
        return desc.toString();
    }

    public String getArgument(String optionName) {
        return null;
    }

    public List<String> getAvailableOptions() {
        if (this.options == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.options.keySet());
    }

    public List<String> getEnvVarSeparators(String optionName) {
        return null;
    }

    public List<String> getKeyValueSeparators(String optionName) {
        return null;
    }

    public List<String> getTupleSeparators(String optionName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        ArrayList<String> retval = new ArrayList<String>();
        Option option = this.options.get(optionName);
        Range range = option.getRange();
        if (optionName.equals("resource")) {
            retval.add(" ");
            return retval;
        }
        if (range instanceof ListRange) {
            String seps = ((ListRange)range).getSeparators();
            if (seps != null && !seps.isEmpty()) {
                char[] cArray = seps.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    retval.add("" + c);
                    ++n2;
                }
            }
            retval.add(" ");
            return retval;
        }
        if (range instanceof StringRangeFromList) {
            retval.add(" ");
            return retval;
        }
        return retval;
    }

    public IToolOptions.EditorType getOptionEditorType(String optionName) {
        if (this.options.containsKey(optionName)) {
            Option option = this.options.get(optionName);
            Range range = option.getRange();
            if (optionName.equals("agentlib")) {
                return IToolOptions.EditorType.AGENTLIB;
            }
            if (optionName.equals("target")) {
                return IToolOptions.EditorType.LIST_SELECTION;
            }
            if (range instanceof BooleanRange) {
                return IToolOptions.EditorType.BOOLEAN;
            }
            if (range instanceof ListRange) {
                return IToolOptions.EditorType.STRING_LIST;
            }
            if (range instanceof StringRangeFromList) {
                return IToolOptions.EditorType.LIST_SELECTION;
            }
        }
        return IToolOptions.EditorType.STRING;
    }

    public List<String> getOptionEditorArgs(String optionName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        Option option = this.options.get(optionName);
        Range range = option.getRange();
        if (optionName.equals("resource")) {
            return null;
        }
        if (optionName.equals("useProfile")) {
            return Arrays.asList("file", "absolute_paths");
        }
        if (optionName.equals("target")) {
            return this.distribution.getAvailableTargets();
        }
        if (range instanceof StringRangeFile) {
            return Arrays.asList("file");
        }
        if (range instanceof StringRangeDirectory) {
            return Arrays.asList("directory");
        }
        if (range instanceof ListRange) {
            boolean isFile = false;
            boolean isDirectory = false;
            for (Range subRange : range) {
                if (subRange instanceof StringRangeFile) {
                    isFile = true;
                    continue;
                }
                if (!(subRange instanceof StringRangeDirectory)) continue;
                isDirectory = true;
            }
            ArrayList<String> listRangeArgs = new ArrayList<String>();
            if (isFile) {
                listRangeArgs.add("file");
            }
            if (isDirectory) {
                listRangeArgs.add("directory");
            }
            return listRangeArgs;
        }
        if (range instanceof StringRangeFromList) {
            ArrayList<String> listSelectionRangeArgs = new ArrayList<String>();
            if (range instanceof StringRangeSomeFromList) {
                listSelectionRangeArgs.add("multi");
            }
            listSelectionRangeArgs.addAll(((StringRangeFromList)range).getAcceptableValues());
            return listSelectionRangeArgs;
        }
        return null;
    }

    public void init(AbstractJamaicaDistribution abstractDist, ToolType tool) {
        if (!(abstractDist instanceof JamaicaVMDistribution)) {
            throw new IllegalArgumentException("Unsupported distribution type: " + abstractDist);
        }
        this.distribution = (JamaicaVMDistribution)abstractDist;
        if (!(ToolType.JAMAICA.equals((Object)tool) || ToolType.JAMAICAH.equals((Object)tool) || ToolType.THREADMONITOR.equals((Object)tool))) {
            throw new IllegalArgumentException(String.valueOf(Messages.BoxiOptions_Unsupported_tool_type) + ": " + tool);
        }
        String mainBin = String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "bin" + File.separator;
        String targetClasses = String.valueOf(this.distribution.getClassesDirectory(this.distribution.getHostTarget())) + File.separator;
        switch (tool) {
            case JAMAICA: {
                this.toolPath = String.valueOf(mainBin) + "jamaica_bin";
                break;
            }
            case JAMAICAH: {
                this.toolPath = String.valueOf(mainBin) + "jamaicah_bin";
                break;
            }
            case THREADMONITOR: {
                this.toolPath = String.valueOf(targetClasses) + "ThreadMonitor.jar";
            }
        }
        String string = this.toolPath = new File(this.toolPath).isFile() ? this.toolPath : null;
        if (ToolType.JAMAICA.equals((Object)tool) || ToolType.JAMAICAH.equals((Object)tool)) {
            this.toolClasspath = LauncherPlugin.normalize(String.valueOf(targetClasses) + "JamaicaTask.jar");
        } else if (ToolType.THREADMONITOR.equals((Object)tool)) {
            this.toolClasspath = this.toolPath;
        }
        String toolXml = null;
        if (tool == ToolType.JAMAICA) {
            toolXml = "jamaicaoptions.xml";
        } else if (tool == ToolType.JAMAICAH) {
            toolXml = "jamaicahoptions.xml";
        }
        if (toolXml != null) {
            File f = new File(String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "etc" + File.separator + toolXml);
            BoxiParser bp = new BoxiParser(f);
            try {
                this.options = bp.getOptions();
            }
            catch (Exception e) {
                LauncherPlugin.log(e);
            }
        }
        if (this.options != null) {
            this.groups = new ArrayList<String>();
            for (Option curOption : this.options.values()) {
                String group = curOption.getGroup();
                if (this.groups.contains(group)) continue;
                this.groups.add(group);
            }
            this.defaultValues = new LinkedHashMap<String, Properties>();
            if (tool == ToolType.JAMAICA) {
                for (String curTarget : this.distribution.getAvailableTargets()) {
                    Properties curTargetProperties = new Properties();
                    try {
                        FileInputStream fis = new FileInputStream(String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "target" + File.separator + curTarget + File.separator + "etc" + File.separator + "jamaica.conf");
                        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                        String line = null;
                        do {
                            if ((line = br.readLine()) == null || line.startsWith("#")) continue;
                            int dot = line.indexOf(46);
                            int equal = line.indexOf(61) + 1;
                            if (dot <= 0 || equal <= 0 || dot >= equal) continue;
                            curTargetProperties.put(line.substring(0, dot).trim(), line.substring(equal).trim());
                        } while (line != null);
                    }
                    catch (Exception e) {
                        LauncherPlugin.log(e);
                    }
                    this.defaultValues.put(curTarget, curTargetProperties);
                }
            } else if (tool == ToolType.JAMAICAH) {
                Properties jamaicahProperties = new Properties();
                try {
                    jamaicahProperties.load(new FileInputStream(String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "etc" + File.separator + "jamaicah.conf"));
                }
                catch (Exception e) {
                    LauncherPlugin.log(e);
                }
                this.defaultValues.put(this.distribution.getHostTarget(), jamaicahProperties);
            }
        }
    }

    public List<String> validate(String optionName, PossiblyEscapedString value) {
        ArrayList<String> retval = new ArrayList<String>();
        if (!this.options.containsKey(optionName)) {
            retval.add(Messages.BoxiOptions_Unknown_option);
        } else if ("target".equals(optionName)) {
            if (!this.distribution.getAvailableTargets().contains(value.getString())) {
                retval.add("Platform '" + value.getString() + "' is not supported by this JamaicaVM distribution!");
            }
        } else {
            String validationError = null;
            try {
                validationError = this.options.get(optionName).getRange().acceptsError(value.getString());
            }
            catch (Exception e) {
                LauncherPlugin.log(e);
                validationError = e instanceof StringIndexOutOfBoundsException && value.getString().isEmpty() ? "Missing value" : "Validation failed: " + e.getMessage();
            }
            if (validationError != null) {
                retval.add(validationError);
            }
        }
        return retval;
    }

    public String getToolClasspath() {
        return this.toolClasspath;
    }

    public boolean isAppendable(String optionName) {
        return false;
    }

    public String getToolPath() {
        return this.toolPath;
    }

    public PossiblyEscapedString join(List<PossiblyEscapedString> items, List<String> separators) {
        StringBuffer joinedString = new StringBuffer();
        int i = 0;
        while (i < items.size()) {
            joinedString.append(this.escape(this.unescape(items.get(i)), separators).getString());
            if (i < items.size() - 1) {
                joinedString.append(separators.get(0));
            }
            ++i;
        }
        return PossiblyEscapedString.escaped((String)joinedString.toString());
    }

    public String unescape(PossiblyEscapedString item) {
        String retval = null;
        if (item != null) {
            retval = item.getString();
        }
        return retval;
    }

    public PossiblyEscapedString escape(String item, List<String> separators) {
        if (item == null) {
            return null;
        }
        if (separators == null || separators.isEmpty()) {
            return PossiblyEscapedString.plain((String)item);
        }
        StringBuffer escapedItem = new StringBuffer(item);
        for (String sep : separators) {
            int sepPos = -1;
            int startPos = 0;
            while ((sepPos = escapedItem.indexOf(sep, startPos)) > -1) {
                if (!this.isEscaped(PossiblyEscapedString.escaped((String)escapedItem.toString()), sepPos, sepPos + sep.length())) {
                    int lc = 0;
                    int j = 0;
                    while (j < sepPos) {
                        if (escapedItem.charAt(j) == '\"') {
                            ++lc;
                        }
                        ++j;
                    }
                    if (lc % 2 == 0) {
                        escapedItem.insert(sepPos, '\"');
                        ++sepPos;
                    }
                    escapedItem.insert(sepPos + sep.length(), '\"');
                }
                startPos = sepPos + sep.length();
            }
        }
        return PossiblyEscapedString.escaped((String)escapedItem.toString());
    }

    public boolean isEscaped(PossiblyEscapedString item, int start, int end) {
        boolean retval = false;
        if (item.isEscaped()) {
            int lcount = 0;
            int i = 0;
            while (i < start) {
                if (item.getString().charAt(i) == '\"') {
                    ++lcount;
                }
                ++i;
            }
            if (lcount % 2 == 1) {
                int rcount = 0;
                int i2 = end;
                while (i2 < item.getString().length()) {
                    if (item.getString().charAt(i2) == '\"') {
                        ++rcount;
                        break;
                    }
                    ++i2;
                }
                if (rcount > 0) {
                    retval = true;
                }
            }
        }
        return retval;
    }
}

