/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors.se;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.AbstractSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.UnknownOptionException;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class StringListSettingEditor
extends AbstractSettingEditor {
    private TableViewer itemTableViewer;
    private Table itemTable;
    private ArrayList<String> items;
    private boolean isFile;
    private boolean isDirectory;
    private boolean absolutePaths;
    private boolean isClasspath;
    private Text inputField;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Button arrowButton;
    private Menu arrowButtonMenu;
    private String separators;
    private String editCandidate;
    private final ToolChunk.UIValidator resourceValidator = new ToolChunk.UIValidator(){

        public String validateForUI(String optionValue) {
            String[] resTokens;
            String result = null;
            String baseDirPath = StringListSettingEditor.this.model.getManager().getProjectFile().getBasedirPath();
            String seps = StringListSettingEditor.this.model.getToolOptions().getSeparators(StringListSettingEditor.this.associatedOption);
            String[] stringArray = resTokens = optionValue.split("[" + Pattern.quote(seps) + "]");
            int n = resTokens.length;
            int n2 = 0;
            while (n2 < n) {
                String resToken = stringArray[n2];
                if (resToken != null && !resToken.isEmpty()) {
                    IPath resourcePath = new Path(resToken).makeRelative();
                    String cpVal = StringListSettingEditor.this.model.getOptionValueResolved("classpath");
                    String[] cpTokens = cpVal.split("[" + Pattern.quote(seps) + "]");
                    boolean matchedClasspath = false;
                    int i = 0;
                    while (i < cpTokens.length && !matchedClasspath) {
                        if (cpTokens[i] != null && !cpTokens[i].isEmpty()) {
                            Path classPath = new Path(cpTokens[i]);
                            if (!classPath.isAbsolute()) {
                                classPath = new Path(String.valueOf(baseDirPath) + File.separator + classPath);
                            }
                            if (classPath.toFile().isDirectory()) {
                                if (new Path(classPath + File.separator + resourcePath).toFile().isFile()) {
                                    matchedClasspath = true;
                                }
                            } else if (classPath.toFile().isFile()) {
                                try {
                                    ZipFile zipFile = new ZipFile(classPath.toFile());
                                    ZipEntry zipEntry = zipFile.getEntry(resourcePath.toString());
                                    if (zipEntry != null) {
                                        matchedClasspath = true;
                                    }
                                    zipFile.close();
                                }
                                catch (ZipException zipFile) {
                                }
                                catch (IOException ioe) {
                                    AntEditorPlugin.log(ioe);
                                }
                            }
                        }
                        ++i;
                    }
                    if (!matchedClasspath) {
                        if (result == null) {
                            result = "";
                        }
                        if (!result.isEmpty()) {
                            result = result.concat(", ");
                        }
                        result = result.concat("'" + resourcePath.toString() + "'");
                    }
                }
                ++n2;
            }
            if (result != null) {
                result = "The following files are not in the Builder classpath: " + result;
            }
            return result;
        }
    };
    private final KeyListener sLSEKeyListener = new KeyListener(){
        private boolean enterFlag = false;

        public void keyPressed(KeyEvent ke) {
            if (ke.getSource() == StringListSettingEditor.this.inputField && ke.keyCode == 13) {
                StringListSettingEditor.this.handleAddOrEdit();
                this.enterFlag = true;
            } else if (ke.getSource() == StringListSettingEditor.this.itemTable && ke.keyCode == 127) {
                StringListSettingEditor.this.removeSelectedItems();
            } else if (ke.keyCode == 27) {
                StringListSettingEditor.this.leaveEditMode();
            }
        }

        public void keyReleased(KeyEvent ke) {
            if (ke.getSource() == StringListSettingEditor.this.inputField && ke.keyCode == 13) {
                if (!this.enterFlag) {
                    StringListSettingEditor.this.handleAddOrEdit();
                }
                this.enterFlag = false;
            }
        }
    };
    private final SelectionAdapter upDownListener = new SelectionAdapter(){
        static final int UP = -1;
        static final int DOWN = 1;

        private void swap(int delta) {
            ISelection sel = StringListSettingEditor.this.itemTableViewer.getSelection();
            if (sel.isEmpty() || !(sel instanceof IStructuredSelection) || delta == 0) {
                return;
            }
            IStructuredSelection iss = (IStructuredSelection)sel;
            List selectedItems = iss.toList();
            if (delta > 0) {
                Collections.reverse(selectedItems);
            }
            for (Object o : selectedItems) {
                String s = (String)o;
                if (!StringListSettingEditor.this.items.contains(s)) continue;
                int idx = StringListSettingEditor.this.items.indexOf(s);
                if ((delta >= 0 || idx == 0) && (delta <= 0 || idx == StringListSettingEditor.this.items.size() - 1)) break;
                Collections.swap(StringListSettingEditor.this.items, idx, idx + delta);
            }
            StringListSettingEditor.this.modelChanged();
        }

        public void widgetSelected(SelectionEvent se) {
            if (se.getSource() == StringListSettingEditor.this.upButton) {
                this.swap(-1);
            } else if (se.getSource() == StringListSettingEditor.this.downButton) {
                this.swap(1);
            }
            StringListSettingEditor.this.leaveEditMode();
        }
    };

    public StringListSettingEditor(String optionName, ToolChunk chunk) {
        super(optionName, chunk);
        if (optionName.equals("resource")) {
            try {
                chunk.addUIValidator(optionName, this.resourceValidator);
            }
            catch (UnknownOptionException uoe) {
                AntEditorPlugin.log(uoe);
            }
        }
    }

    protected void createInputArea(Composite parent, FormToolkit toolkit) {
        GridLayout gridLay = new GridLayout(3, false);
        gridLay.verticalSpacing = 10;
        gridLay.marginHeight = 10;
        gridLay.marginWidth = 10;
        parent.setLayout((Layout)gridLay);
        List args = this.model.getToolOptions().getOptionEditorArgs(this.associatedOption);
        this.isFile = args != null && args.contains("file");
        this.isDirectory = args != null && args.contains("directory");
        this.absolutePaths = args != null && args.contains("absolute_paths");
        this.isClasspath = this.associatedOption.equals("classpath");
        this.separators = this.model.getToolOptions().getSeparators(this.associatedOption);
        this.items = new ArrayList();
        this.itemTableViewer = new TableViewer(parent);
        this.itemTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.itemTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.itemTableViewer.setInput(this.items);
        this.itemTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = StringListSettingEditor.this.itemTableViewer.getSelection();
                if (sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
                    StringListSettingEditor.this.leaveEditMode();
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)sel;
                List selectedItems = iss.toList();
                if (selectedItems.size() > 1) {
                    StringListSettingEditor.this.leaveEditMode();
                    return;
                }
                StringListSettingEditor.this.editCandidate = (String)selectedItems.get(0);
                StringListSettingEditor.this.addButton.setText(Messages.StringListSettingEditor_Edit);
                StringListSettingEditor.this.addButton.setToolTipText(Messages.StringListSettingEditor_Edits_the_currently_selected_entry__Press___ESC___to_abort_editing);
                StringListSettingEditor.this.inputField.setText(StringListSettingEditor.this.editCandidate);
                StringListSettingEditor.this.inputField.setFocus();
                StringListSettingEditor.this.inputField.setSelection(StringListSettingEditor.this.editCandidate.length());
            }
        });
        this.itemTable = this.itemTableViewer.getTable();
        this.itemTable.setFont(this.groupFont);
        this.itemTable.addKeyListener(this.sLSEKeyListener);
        GridData tablelayout = GridDataFactory.fillDefaults().grab(true, false).span(2, 4).hint(400, 150).create();
        this.itemTable.setLayoutData((Object)tablelayout);
        toolkit.adapt((Composite)this.itemTable);
        this.removeButton = new Button(parent, 0);
        this.removeButton.setText(Messages.StringListSettingEditor_Remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                StringListSettingEditor.this.removeSelectedItems();
                StringListSettingEditor.this.leaveEditMode();
            }
        });
        this.removeButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.removeButton.setToolTipText(Messages.StringListSettingEditor_Removes_the_selected_items);
        this.removeButton.setFont(this.groupFont);
        this.upButton = new Button(parent, 0);
        this.upButton.setText(Messages.StringListSettingEditor_Up);
        this.upButton.addSelectionListener((SelectionListener)this.upDownListener);
        this.upButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.upButton.setToolTipText(Messages.StringListSettingEditor_Moves_the_selected_items_one_position_up);
        this.upButton.setFont(this.groupFont);
        this.downButton = new Button(parent, 0);
        this.downButton.setText(Messages.StringListSettingEditor_Down);
        this.downButton.addSelectionListener((SelectionListener)this.upDownListener);
        this.downButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.downButton.setToolTipText(Messages.StringListSettingEditor_Moves_the_selected_items_one_position_down);
        this.downButton.setFont(this.groupFont);
        new Label(parent, 0);
        this.inputField = toolkit.createText(parent, "", 2052);
        this.inputField.addKeyListener(this.sLSEKeyListener);
        this.inputField.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.inputField.setFont(this.groupFont);
        this.addButton = new Button(parent, 0);
        this.addButton.setText(Messages.StringListSettingEditor_Add);
        this.addButton.setFont(this.groupFont);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                StringListSettingEditor.this.handleAddOrEdit();
            }
        });
        this.addButton.setToolTipText(Messages.StringListSettingEditor_Adds_this_item_to_the_list);
        if (this.isFile || this.isDirectory || this.isClasspath) {
            this.addButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            this.arrowButton = new Button(parent, 1028);
            this.arrowButton.setFont(this.groupFont);
            this.arrowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    if (StringListSettingEditor.this.arrowButtonMenu != null) {
                        StringListSettingEditor.this.arrowButtonMenu.setVisible(true);
                    }
                }
            });
            this.arrowButton.setToolTipText(Messages.StringListSettingEditor_Opens_a_menu_where_you_can_choose_to_open_a_dialog_to_browse_the_filesystem);
            this.arrowButtonMenu = new Menu((Control)this.arrowButton);
            if (this.associatedOption.equals("resource")) {
                MenuItem subMenu = new MenuItem(this.arrowButtonMenu, 0);
                subMenu.setText(Messages.StringListSettingEditor_Sub);
                subMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        InputDialog id = new InputDialog(AntEditorPlugin.getShell(), Messages.StringListSettingEditor_substituor_title, Messages.StringListSettingEditor_substitution_text, StringListSettingEditor.this.inputField.getSelectionText(), null);
                        if (id.open() == 0) {
                            String substitute = id.getValue();
                            int i = 0;
                            while (i < StringListSettingEditor.this.items.size()) {
                                if (((String)StringListSettingEditor.this.items.get(i)).startsWith(substitute)) {
                                    StringListSettingEditor.this.items.set(i, ((String)StringListSettingEditor.this.items.get(i)).substring(substitute.length()));
                                }
                                ++i;
                            }
                            StringListSettingEditor.this.modelChanged();
                        }
                    }
                });
            }
            if (this.isFile) {
                MenuItem openFileDialog = new MenuItem(this.arrowButtonMenu, 0);
                openFileDialog.setText(Messages.StringListSettingEditor_Add_file______);
                openFileDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        String baseDirPath = StringListSettingEditor.this.model.getManager().getProjectFile().getBasedirPath();
                        FileDialog fd = new FileDialog(AntEditorPlugin.getShell(), 4098);
                        fd.setFilterPath(baseDirPath);
                        String result = fd.open();
                        if (result != null) {
                            String[] stringArray = fd.getFileNames();
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String fileName = stringArray[n2];
                                fileName = String.valueOf(fd.getFilterPath()) + File.separator + fileName;
                                if (StringListSettingEditor.this.associatedOption.equals("resource")) {
                                    if (new Path(fileName = StringListSettingEditor.this.makeRelativeToClasspath(fileName)).isAbsolute()) {
                                        fileName = LauncherPlugin.normalize((String)fileName, (String)baseDirPath);
                                    }
                                } else {
                                    fileName = StringListSettingEditor.this.absolutePaths ? LauncherPlugin.normalize((String)fileName) : LauncherPlugin.normalize((String)fileName, (String)baseDirPath);
                                }
                                StringListSettingEditor.this.addItem(fileName);
                                ++n2;
                            }
                        }
                    }
                });
            }
            if (this.isDirectory) {
                MenuItem openDirectoryDialog = new MenuItem(this.arrowButtonMenu, 0);
                openDirectoryDialog.setText(Messages.StringListSettingEditor_Add_directory______);
                openDirectoryDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        DirectoryDialog dd = new DirectoryDialog(AntEditorPlugin.getShell());
                        dd.setFilterPath(StringListSettingEditor.this.model.getManager().getProjectFile().getBasedirPath());
                        String directory = dd.open();
                        if (directory != null) {
                            StringListSettingEditor.this.addItem(StringListSettingEditor.this.absolutePaths ? LauncherPlugin.normalize((String)directory) : LauncherPlugin.normalize((String)directory, (String)AntEditorPlugin.resolve(StringListSettingEditor.this.model.getManager().getProjectFile().getFile().getProject().getLocation())));
                        }
                    }
                });
                if (this.isClasspath) {
                    MenuItem doClasspathSync = new MenuItem(this.arrowButtonMenu, 0);
                    doClasspathSync.setText(Messages.StringListSettingEditor_Synchronize_with_the_project_classpath);
                    doClasspathSync.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent se) {
                            if (MessageDialog.openQuestion((Shell)AntEditorPlugin.getShell(), (String)Messages.StringListSettingEditor_Replace_classpath__, (String)Messages.StringListSettingEditor_Do_you_want_to_replace_the_current_classpath_with_the_project_classpath__)) {
                                AntEditorPlugin.StringClasspathDescriber scd = AntEditorPlugin.getClasspath(StringListSettingEditor.this.model.getManager().getProjectFile().getFile().getProject().getName());
                                ArrayList<String> cpItems = new ArrayList<String>();
                                cpItems.add(scd.outputLocation);
                                cpItems.addAll(scd.libraryLocations);
                                cpItems.addAll(scd.sourceLocations);
                                StringListSettingEditor.this.setValue(AntEditorPlugin.join(cpItems.toArray(), StringListSettingEditor.this.separators));
                            }
                        }
                    });
                }
            }
            this.arrowButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        } else {
            this.addButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        }
        this.invalidDecorator = new ControlDecoration((Control)this.itemTableViewer.getTable(), 0x1004000, (Composite)this.optionControls);
    }

    public void updateUI() {
        super.updateUI();
        boolean state = this.getState();
        this.itemTable.setEnabled(state);
        this.inputField.setEnabled(state);
        this.removeButton.setEnabled(state);
        this.upButton.setEnabled(state);
        this.downButton.setEnabled(state);
        this.addButton.setEnabled(state);
        if (this.arrowButton != null) {
            this.arrowButton.setEnabled(state);
        }
        String[] tokens = this.getValue().split("[" + Pattern.quote(this.separators) + "]");
        ArrayList<String> newItems = new ArrayList<String>(tokens.length);
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token != null && !token.isEmpty()) {
                newItems.add(token);
            }
            ++n2;
        }
        this.items.clear();
        this.items.addAll(newItems);
        this.itemTableViewer.refresh();
    }

    private void modelChanged() {
        this.setValue(AntEditorPlugin.join(this.items.toArray(new String[0]), this.separators));
    }

    private void addItem(String item) {
        if (item != null && !item.trim().isEmpty()) {
            String[] tokens;
            String[] stringArray = tokens = item.split("[" + Pattern.quote(this.separators) + "]");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (token != null && !token.isEmpty()) {
                    this.items.add(token);
                }
                ++n2;
            }
            this.modelChanged();
        }
    }

    private void replaceItem(String oldItem, String newItem) {
        if (newItem != null && newItem.trim().length() != 0 && this.items.contains(oldItem)) {
            this.items.set(this.items.indexOf(oldItem), newItem);
            this.modelChanged();
        }
    }

    private void removeSelectedItems() {
        ISelection s = this.itemTableViewer.getSelection();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)s;
            this.items.removeAll(iss.toList());
            this.modelChanged();
        }
    }

    private void leaveEditMode() {
        this.editCandidate = null;
        this.inputField.setText("");
        this.addButton.setText(Messages.StringListSettingEditor_Add);
        this.addButton.setToolTipText(Messages.StringListSettingEditor_Adds_this_item_to_the_list);
    }

    private void handleAddOrEdit() {
        if (this.editCandidate != null) {
            this.replaceItem(this.editCandidate, this.inputField.getText());
            this.leaveEditMode();
        } else {
            this.addItem(this.inputField.getText());
        }
        this.inputField.setText("");
    }

    private String makeRelativeToClasspath(String absPath) {
        Path result = new Path(absPath);
        String cpVal = this.model.getOptionValueResolved("classpath");
        String seps = this.model.getToolOptions().getSeparators(this.associatedOption);
        String baseDirPath = this.model.getManager().getProjectFile().getBasedirPath();
        String[] tokens = cpVal.split("[" + Pattern.quote(seps) + "]");
        boolean matchedClasspath = false;
        int i = 0;
        while (i < tokens.length && !matchedClasspath) {
            if (tokens[i] != null && !tokens[i].isEmpty()) {
                Path classPath = new Path(tokens[i]);
                if (!classPath.isAbsolute()) {
                    classPath = new Path(String.valueOf(baseDirPath) + File.separator + classPath);
                }
                if (classPath.toFile().isDirectory() && classPath.isPrefixOf((IPath)result)) {
                    matchedClasspath = true;
                    result = result.makeRelativeTo((IPath)classPath);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public void grabFocus() {
        super.grabFocus();
        this.inputField.setFocus();
    }
}

