/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.wizards;

import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.wizards.GeneralSettingsWizardPage;
import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.core.ToolType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractJamaicaBuildFileBuilder {
    private int indentLevel;
    private StringBuilder buffer = new StringBuilder();
    protected GeneralSettingsWizardPage page;

    protected AbstractJamaicaBuildFileBuilder() {
    }

    public abstract String buildJamaicaBuildFileScript();

    protected void increaseIndent() {
        ++this.indentLevel;
    }

    protected void decreaseIndent() {
        this.indentLevel = Math.max(0, this.indentLevel - 1);
    }

    protected void addHeader() {
        this.app("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
    }

    protected void addCopyright(String description) {
        this.app("<!-- aicas GmbH, Karlsruhe -->");
        this.app("<!-- " + description + " -->");
    }

    protected void addComment(String comment) {
        this.app("<!-- " + comment + " -->");
    }

    protected void startProject(String name, String basedir, String defaultTarget) {
        this.app("<project" + (basedir == null ? "" : " basedir=\"" + basedir + "\"") + (defaultTarget == null ? "" : " default=\"" + defaultTarget + "\"") + " " + "name" + "=\"" + name + "\">");
    }

    protected void addTaskdef(String taskName, String className, String classpath) {
        this.app(MessageFormat.format("<taskdef classname=\"{1}\" classpath=\"{2}\" name=\"{0}\"/>", taskName, className, classpath));
    }

    protected void addProperty(String name, String value) {
        this.app(MessageFormat.format("<property name=\"{0}\" value=\"{1}\"/>", name, value));
    }

    protected void addEnvProperty(String envPrefix) {
        this.app(MessageFormat.format("<property environment=\"{0}\"/>", envPrefix));
    }

    protected void addJamaicaCondition(String envPrefix) {
        this.app(MessageFormat.format("<condition property=\"jamaica\" value=\"$'{'{0}.JAMAICA'}'\">", envPrefix));
        this.increaseIndent();
        this.app(MessageFormat.format("<isset property=\"{0}.JAMAICA\"/>", envPrefix));
        this.decreaseIndent();
        this.app("</condition>");
    }

    protected void addJamaicaFail() {
        this.app("<fail message=\"Please set the JAMAICA environment variable to a Jamaica installation!\" unless=\"jamaica\"/>");
    }

    protected void addTool(ToolType toolType, String antTargetName, String depends, String unless, String jamaica, String additionalAttribs, String executable, boolean isHostTarget, Map<String, String> options) {
        this.app("<target" + (depends == null ? "" : " depends=\"" + depends + "\"") + " " + "name" + "=\"" + antTargetName + "\"" + (unless == null ? "" : " unless=\"" + unless + "\"") + ">");
        this.increaseIndent();
        String toolName = toolType.tagname((AbstractJamaicaDistribution)this.page.getDistribution());
        this.app(MessageFormat.format("<{0} jamaica=\"{1}\"{2}>", toolName, jamaica, additionalAttribs == null ? "" : String.valueOf(' ') + additionalAttribs));
        this.increaseIndent();
        int majorVersion = this.page.getDistribution().getVersionMajor();
        int minorVersion = this.page.getDistribution().getVersionMinor();
        String formatString = "";
        formatString = majorVersion == 6 && minorVersion >= 4 || majorVersion > 6 ? "<option append=\"{1}\" enabled=\"true\" name=\"{0}\" value=\"{2}\"/>" : (majorVersion == 6 && minorVersion >= 0 ? "<{0} append=\"{1}\" enabled=\"true\" value=\"{2}\"/>" : "<{0} enabled=\"true\" value=\"{1}\"/>");
        for (String optionName : options.keySet()) {
            if (majorVersion >= 6) {
                boolean appendValue = this.page.getDistribution().getToolOptions(toolType).isAppendable(optionName);
                this.app(MessageFormat.format(formatString, optionName, appendValue, options.get(optionName).replaceAll("\"", "&quot;")));
                continue;
            }
            this.app(MessageFormat.format(formatString, optionName, options.get(optionName).replaceAll("\"", "&quot;")));
        }
        this.decreaseIndent();
        this.app(MessageFormat.format("</{0}>", toolName));
        if (executable != null) {
            this.addPlainLine("<echo>");
            this.increaseIndent();
            this.addPlainLine(Messages.ToolChunk_The_executable_has_been_created_successfully__);
            this.increaseIndent();
            this.addPlainLine(ToolChunk.getWritableString(executable));
            this.decreaseIndent();
            if (isHostTarget) {
                this.addPlainLine(Messages.ToolChunk_You_can_launch_it_using_the___Overview___page_in_this_editor__);
            } else {
                this.addPlainLine(Messages.ToolChunk_Please_transfer_it_to_your_target_device_manually__);
            }
            this.decreaseIndent();
            this.addPlainLine("</echo>");
        }
        this.decreaseIndent();
        this.app("</target>");
    }

    protected void addEmptyLine() {
        this.app("");
    }

    protected void addPlainLine(String plainLine) {
        this.app(plainLine);
    }

    protected void endProject() {
        this.app("</project>");
    }

    public InputStream getResult() {
        return new ByteArrayInputStream(this.buffer.toString().getBytes());
    }

    private void app(String s) {
        String whitespace = "";
        int i = 0;
        while (i < this.indentLevel) {
            whitespace = String.valueOf(whitespace) + "  ";
            ++i;
        }
        this.buffer.append(String.valueOf(whitespace) + s.trim() + "\n");
    }
}

