/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.Tag;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;
import org.w3c.dom.Node;

public class VersionTag
extends Tag {
    private Version fileVersion;
    public static final String VERSION_TAG_KEYWORD = "JAMAICA_ANT_EDITOR_VERSION";
    public static final String VERSION_TAG_REGEX = "(JAMAICA_)?ANT_EDITOR_VERSION";
    public static final Pattern VERSION_TAG_PATTERN = Pattern.compile("(JAMAICA_)?ANT_EDITOR_VERSION=(\\d+\\.\\d+\\.\\d+(\\.\\w+)?)");

    public VersionTag(Node node) throws ModelException {
        super(node, null, null);
        Matcher matcher = VERSION_TAG_PATTERN.matcher(this.getNode().getNodeValue());
        if (matcher.find()) {
            Version pluginVersion = AntEditorPlugin.getDefault().getAntEditorVersion();
            this.fileVersion = Version.parseVersion((String)matcher.group(2));
            if (pluginVersion != null && pluginVersion.compareTo((Object)this.fileVersion) < 0) {
                throw new ModelException(Messages.VersionTag_This_buildfile_has_been_created_with_a_newer_version_of_this_plug__in___);
            }
        }
    }

    public Version getVersion() {
        return this.fileVersion;
    }
}

