/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.InteractiveTargetChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.OptionValidator;
import com.aicas.jamaica.eclipse.ant_editor.model.ProblemManager;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefTag;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunkManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolEnv;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolEnvProp;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolOption;
import com.aicas.jamaica.eclipse.ant_editor.model.UnknownOptionException;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolChunk
extends InteractiveTargetChunk
implements IModelPartChangedListener {
    private TaskdefTag taskdef;
    Map<String, ToolOption> options;
    Map<String, ToolEnv> envs;
    Map<String, ToolEnvProp> envprops;
    private static List<String> nonOptionList = Arrays.asList("env", "envpropertyset");
    private Element toolTag;
    private Element echoTag;
    private IPath pathOfMainClass = Path.EMPTY;
    private Map<String, OptionValidator> optionValidators;

    public ToolChunk(Node targetNode, Element toolTag, ToolChunkManager manager) throws ModelException {
        super(targetNode, manager);
        this.toolTag = toolTag;
        this.options = new LinkedHashMap<String, ToolOption>();
        this.envs = new LinkedHashMap<String, ToolEnv>();
        this.envprops = new LinkedHashMap<String, ToolEnvProp>();
        this.optionValidators = new HashMap<String, OptionValidator>();
        this.getManager().addListener(this);
        this.taskdef = (TaskdefTag)this.getManager().getProjectFile().getTaskdefManager().getTag(toolTag.getTagName());
        this.options.clear();
        this.envs.clear();
        this.envprops.clear();
        if (this.taskdef == null) {
            throw new ModelException(Messages.ToolChunk_No_Ant_task_specified);
        }
        this.setListenerNotificationState(false);
        NodeList childNodes = toolTag.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                ToolOption newOption;
                Element childTag = (Element)childNode;
                String childTagName = childTag.getTagName();
                if (childTagName.toLowerCase().equals("option")) {
                    newOption = new ToolOption(this, childTag);
                    this.options.put(newOption.getName(), newOption);
                } else if (childTagName.toLowerCase().equals("env")) {
                    ToolEnv newEnv = new ToolEnv(this, childTag);
                    this.envs.put(newEnv.getKey(), newEnv);
                } else if (childTagName.toLowerCase().equals("envpropertyset")) {
                    ToolEnvProp newEnvProp = new ToolEnvProp(this, childTag);
                    for (String prefix : newEnvProp.getPrefixes()) {
                        this.envprops.put(prefix, newEnvProp);
                    }
                } else if (!nonOptionList.contains(childTagName)) {
                    newOption = new ToolOption(this, childTag);
                    this.options.put(childTagName, newOption);
                }
            }
            ++i;
        }
        Node sib = toolTag;
        while ((sib = sib.getNextSibling()) != null) {
            if (sib.getNodeType() != 1 || !sib.getNodeName().equals("echo")) continue;
            this.echoTag = (Element)sib;
            break;
        }
        this.setPathOfMainClass();
        this.setListenerNotificationState(true);
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.READ_COMPLETE, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK, this.getName()));
    }

    private void setPathOfMainClass() {
        String mainClass = this.getOptionValueResolved("main");
        if (mainClass != null && !mainClass.isEmpty()) {
            String mainSourceFile = mainClass.replace('.', '/').concat(".java");
            Path mainSourcePath = new Path(mainSourceFile);
            IJavaProject javaProject = this.getManager().getProjectFile().getProject();
            if (javaProject != null) {
                try {
                    IJavaElement mainClassJavaElement = javaProject.findElement((IPath)mainSourcePath);
                    if (mainClassJavaElement != null) {
                        this.pathOfMainClass = mainClassJavaElement.getPath();
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
    }

    public IPath getPathOfMainClass() {
        return this.pathOfMainClass;
    }

    public void setEnv(String key, String value) {
        ToolEnv oldEnv;
        if (key == null || key.isEmpty()) {
            return;
        }
        if (value == null) {
            value = "";
        }
        boolean envIsNew = (oldEnv = this.envs.get(key)) == null;
        boolean envHasChanged = false;
        ToolEnv newEnv = null;
        Element newEnvEle = this.getManager().getProjectFile().getDocument().createElement("env");
        newEnvEle.setAttribute("key", key);
        newEnvEle.setAttribute("value", value);
        newEnv = new ToolEnv(this, newEnvEle);
        boolean bl = envHasChanged = !envIsNew && !oldEnv.equals(newEnv);
        if (envIsNew || envHasChanged) {
            newEnv.addToTree();
            this.envs.put(key, newEnv);
            this.fireModelPartChanged(new ModelPartChangedEvent(this, envIsNew ? ModelPartChangedEvent.ActionType.ADDED : ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_ENV, key));
        }
    }

    public void setEnvProp(String prefix) {
        boolean envPropIsNew;
        if (prefix == null || prefix.isEmpty()) {
            return;
        }
        ToolEnvProp oldEnvProp = this.envprops.get(prefix);
        boolean bl = envPropIsNew = oldEnvProp == null;
        if (envPropIsNew) {
            if (this.envprops.isEmpty()) {
                Element newEle = this.getManager().getProjectFile().getDocument().createElement("envpropertyset");
                ToolEnvProp newEnvProp = new ToolEnvProp(this, newEle);
                newEnvProp.addPrefix(prefix);
                newEnvProp.addToTree();
                this.envprops.put(prefix, newEnvProp);
            } else {
                ToolEnvProp envProp = this.envprops.values().toArray(new ToolEnvProp[0])[0];
                envProp.addPrefix(prefix);
                this.envprops.put(prefix, envProp);
            }
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.ADDED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_ENVPROP, prefix));
        }
    }

    public void setOption(String name, String newValue) {
        if (this.options.containsKey(name)) {
            this.setOption(name, newValue, this.options.get(name).getState());
        } else {
            this.setOption(name, newValue, true);
        }
    }

    public void setOption(String name, String newValue, boolean newState) {
        if (this.options.containsKey(name)) {
            this.setOption(name, newValue, newState, this.options.get(name).hasAppendSyntax());
        } else if (this.getToolOptions().isAppendable(name)) {
            this.setOption(name, newValue, newState, true);
        } else {
            this.setOption(name, newValue, newState, false);
        }
    }

    public void setOption(String name, String newValue, boolean newState, boolean append) {
        Element newOptEle;
        ToolOption oldOption;
        OptionValidator optValid;
        if (newValue == null) {
            newValue = "";
        }
        if (!this.optionValidators.containsKey(name) && (optValid = OptionValidator.getValidator(name, this)) != null) {
            try {
                this.addOptionValidator(name, optValid);
            }
            catch (UnknownOptionException e) {
                AntEditorPlugin.log(e);
            }
        }
        boolean optionIsNew = (oldOption = this.options.get(name)) == null;
        boolean optionHasChanged = false;
        if (oldOption != null && !oldOption.isInitialized()) {
            this.validateOption(oldOption);
        }
        ToolOption newOption = null;
        int jamMajVer = -1;
        int jamMinVer = -1;
        if (this.getTaskdef().isBound()) {
            jamMajVer = this.getTaskdef().getDistribution().getVersionMajor();
            jamMinVer = this.getTaskdef().getDistribution().getVersionMinor();
        }
        if (jamMajVer > 6 || jamMajVer == 6 && jamMinVer >= 4) {
            newOptEle = this.getManager().getProjectFile().getDocument().createElement("option");
            newOptEle.setAttribute("name", name);
        } else {
            if (nonOptionList.contains(name)) {
                return;
            }
            newOptEle = this.getManager().getProjectFile().getDocument().createElement(name);
        }
        newOptEle.setAttribute("value", newValue);
        newOptEle.setAttribute("enabled", Boolean.toString(newState));
        if (jamMajVer >= 6) {
            newOptEle.setAttribute("append", Boolean.toString(append));
        }
        newOption = new ToolOption(this, newOptEle);
        this.validateOption(newOption);
        boolean bl = optionHasChanged = !optionIsNew && !oldOption.equals(newOption);
        if (optionIsNew || optionHasChanged) {
            newOption.addToTree();
            this.options.put(name, newOption);
            this.getManager().getProjectFile().getPropertiesManager().findAndSetNewProperties(newValue);
            if (name.equals("main") || name.equals("destination") || name.equals("target")) {
                this.updateEchoMessage();
                if (name.equals("main")) {
                    this.setPathOfMainClass();
                }
            }
            if (name.equals("target") || name.equals("classpath")) {
                this.revalidate();
            }
            this.fireModelPartChanged(new ModelPartChangedEvent(this, optionIsNew ? ModelPartChangedEvent.ActionType.ADDED : ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION, name));
        }
    }

    private boolean validateOption(ToolOption option) {
        ProblemManager probMan = this.getManager().getProjectFile().getProblemManager();
        IToolOptions jamaicaOptions = this.taskdef.getToolOptions();
        ToolOption oldOption = this.options.get(option.getName());
        ProblemManager.Problem oldProblem = null;
        if (oldOption != null) {
            oldProblem = oldOption.getProblem();
        }
        if (jamaicaOptions == null) {
            option.setValid(false);
            ProblemManager.Problem newProblem = probMan.reportProblem(String.valueOf(this.getName()) + '/', MessageFormat.format(Messages.ToolChunk_Cannot_validate_options_for_Ant_task___1___, this.taskdef.getName()), 1, oldProblem);
            option.setProblem(newProblem);
        } else {
            String optionName = option.getName();
            if (!jamaicaOptions.getAvailableOptions().contains(optionName)) {
                option.setValid(false);
                ProblemManager.Problem newProblem = probMan.reportProblem(String.valueOf(this.getName()) + '/' + optionName, MessageFormat.format(Messages.ToolChunk_Option___1___is_unknown_for___2___in___3__, optionName, this.taskdef.getToolType().toolname(), this.taskdef.getDistribution()), 1, oldProblem);
                option.setProblem(newProblem);
            } else {
                String optionValueResolved;
                String optionValueRaw = option.getValue();
                try {
                    optionValueResolved = this.getManager().getProjectFile().getPropertiesManager().resolveStringWithProperties(optionValueRaw);
                }
                catch (ModelException me) {
                    optionValueResolved = optionValueRaw;
                }
                String validationError = null;
                List seArgs = jamaicaOptions.getOptionEditorArgs(optionName);
                if (seArgs == null) {
                    seArgs = Collections.EMPTY_LIST;
                }
                if (jamaicaOptions.isAppendable(optionName) && seArgs.contains("file")) {
                    String[] tokens;
                    String basedir = this.getManager().getProjectFile().getBasedirPath();
                    String seps = jamaicaOptions.getSeparators(optionName);
                    StringBuilder newString = new StringBuilder();
                    String[] stringArray = tokens = optionValueResolved.split("[" + Pattern.quote(seps) + "]");
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String token = stringArray[n2];
                        if (token != null && !token.isEmpty()) {
                            if (newString.length() > 0) {
                                newString.append(seps.charAt(0));
                            }
                            if (!new File(token).isAbsolute()) {
                                token = String.valueOf(basedir) + File.separator + token;
                            }
                            newString.append(token);
                        }
                        ++n2;
                    }
                    validationError = jamaicaOptions.validate(optionName, newString.toString());
                } else {
                    validationError = jamaicaOptions.validate(optionName, optionValueResolved);
                }
                if (validationError == null && this.optionValidators.containsKey(optionName)) {
                    validationError = this.optionValidators.get(optionName).validate(optionValueResolved);
                }
                if (validationError != null) {
                    option.setValid(false);
                    ProblemManager.Problem newProblem = probMan.reportProblem(String.valueOf(this.getName()) + '/' + optionName, validationError, 1, oldProblem);
                    option.setProblem(newProblem);
                } else {
                    option.setValid(true);
                    if (oldProblem != null) {
                        probMan.problemSolved(oldProblem);
                    }
                }
            }
        }
        return option.isValid();
    }

    public boolean hasAppendSyntax(String name) {
        if (!this.options.containsKey(name)) {
            return false;
        }
        return this.options.get(name).hasAppendSyntax();
    }

    public void setAppendSyntax(String name, boolean appendSyntax) {
        if (this.options.containsKey(name)) {
            boolean hadAppendSyntax = this.options.get(name).hasAppendSyntax();
            this.options.get(name).setAppendSyntax(appendSyntax);
            if (hadAppendSyntax != appendSyntax) {
                this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION, name));
            }
        }
    }

    public boolean removeEnv(String key) {
        if (!this.envs.containsKey(key)) {
            return false;
        }
        ToolEnv env = this.envs.remove(key);
        if (env.isChildOfTree()) {
            env.removeFromTree();
        }
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_ENV, key));
        return true;
    }

    public boolean removeEnvProp(String prefix) {
        ToolEnvProp envProp;
        boolean retval = false;
        if (this.envprops.containsKey(prefix) && (envProp = this.envprops.remove(prefix)) != null) {
            envProp.removePrefix(prefix);
            if (envProp.getPrefixes().isEmpty()) {
                envProp.removeFromTree();
            }
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_ENVPROP, prefix));
            retval = true;
        }
        return retval;
    }

    public boolean removeOption(String name) {
        if (!this.options.containsKey(name)) {
            return false;
        }
        ToolOption option = this.options.remove(name);
        if (option.isChildOfTree()) {
            option.removeFromTree();
        }
        if (option.getProblem() != null) {
            this.getManager().getProjectFile().getProblemManager().problemSolved(option.getProblem());
        }
        if (name.equals("main") || name.equals("destination") || name.equals("target")) {
            this.updateEchoMessage();
        }
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION, name));
        return true;
    }

    public String getOptionValueResolved(String name) {
        String value = this.getOptionValue(name);
        try {
            value = this.getManager().getProjectFile().getPropertiesManager().resolveStringWithProperties(value);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return value;
    }

    public String getOptionValue(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name).getValue();
        }
        return null;
    }

    public String getEnvValue(String name) {
        if (this.envs.containsKey(name)) {
            return this.envs.get(name).getValue();
        }
        return null;
    }

    public String getTargetValue() {
        String target = null;
        target = this.getOptionValueResolved("target");
        if (this.isBound() && (target == null || !this.getOptionState("target"))) {
            target = this.getDistribution().getHostTarget();
        }
        return target;
    }

    public boolean getOptionState(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name).getState();
        }
        return false;
    }

    public boolean isValidOption(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name).isValid();
        }
        return false;
    }

    public String getOptionLastError(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name).getProblem() == null ? null : this.options.get(name).getProblem().getMessage();
        }
        return null;
    }

    private void addOptionValidator(String name, OptionValidator oval) throws UnknownOptionException {
        if (!this.taskdef.getToolOptions().getAvailableOptions().contains(name)) {
            throw new UnknownOptionException(MessageFormat.format(Messages.ToolChunk_Option___1___is_not_configured, name));
        }
        this.optionValidators.put(name, oval);
    }

    public List<String> getConfiguredOptions() {
        return new ArrayList<String>(this.options.keySet());
    }

    public List<String> getConfiguredEnvs() {
        return new ArrayList<String>(this.envs.keySet());
    }

    public List<String> getConfiguredEnvProps() {
        return new ArrayList<String>(this.envprops.keySet());
    }

    void setTaskdef(TaskdefTag taskdef) {
        this.taskdef = taskdef;
    }

    TaskdefTag getTaskdef() {
        return this.taskdef;
    }

    public String getTaskdefName() {
        return this.taskdef.getName();
    }

    public void setTaskdefName(String name) throws ModelException {
        TaskdefTag newTaskdef = (TaskdefTag)this.getManager().getProjectFile().getTaskdefManager().getTag(name);
        if (newTaskdef == null) {
            throw new ModelException(String.valueOf(Messages.ToolChunk_Unknown_Ant_task___) + name);
        }
        this.taskdef = newTaskdef;
        Document projectDoc = this.getManager().getProjectFile().getDocument();
        if (!projectDoc.equals(this.toolTag.getOwnerDocument())) {
            this.toolTag = (Element)projectDoc.adoptNode(this.toolTag);
        }
        projectDoc.renameNode(this.toolTag, null, name);
        this.updateEchoMessage();
        this.revalidate();
    }

    void revalidate() {
        boolean changed = false;
        if (!this.getJamaicaAttr().isEmpty()) {
            String curJamAttrValue = this.getJamaicaAttr();
            String taskdefJamDir = "";
            JamaicaVMDistribution dist = this.getTaskdef().getDistribution();
            if (this.getTaskdef().isBound()) {
                taskdefJamDir = dist.getInstallDirectory();
            }
            if (!(taskdefJamDir.isEmpty() || curJamAttrValue.equals(taskdefJamDir) || curJamAttrValue.equals("${jamaica}"))) {
                this.setJamaicaAttr(taskdefJamDir);
                changed = true;
            }
        }
        for (Map.Entry<String, ToolOption> entry : this.options.entrySet()) {
            ToolOption option = entry.getValue();
            this.setOption(option.getName(), option.getValue());
        }
        if (changed) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK, this.getName()));
        }
    }

    public IToolOptions getToolOptions() {
        return this.taskdef.getToolOptions();
    }

    public Node getToolNode() {
        return this.toolTag;
    }

    public ToolType getToolType() {
        return this.taskdef.getToolType();
    }

    public boolean isBound() {
        return this.taskdef.isBound();
    }

    public boolean buildsForHost() {
        boolean result = false;
        if (this.isBound()) {
            result = this.getDistribution().getHostTarget().equals(this.getTargetValue());
        }
        return result;
    }

    public JamaicaVMDistribution getDistribution() {
        return this.taskdef.getDistribution();
    }

    public String calcExecutableName() {
        if (!ToolType.isJamaica((ToolType)this.getToolType())) {
            return null;
        }
        String destination = null;
        String main = null;
        destination = this.getOptionValueResolved("destination");
        if (destination != null && this.getOptionState("destination")) {
            String exeExt = AntEditorPlugin.getExeExtension();
            if (!destination.endsWith(exeExt)) {
                destination = String.valueOf(destination) + exeExt;
            }
            return destination;
        }
        main = this.getOptionValueResolved("main");
        if (main != null && this.getOptionState("main")) {
            if (this.isBound() && (this.getDistribution().getVersionMajor() == 6 && this.getDistribution().getVersionMinor() >= 3 || this.getDistribution().getVersionMajor() > 6)) {
                main = AntEditorPlugin.getSimpleClassName(main);
            }
            return String.valueOf(main) + AntEditorPlugin.getExeExtension();
        }
        return null;
    }

    public String calcExecutablePath() {
        String execPath = null;
        String execName = this.calcExecutableName();
        if (execName != null) {
            File execFile = new File(execName);
            execPath = !execFile.isAbsolute() ? LauncherPlugin.normalize((String)(String.valueOf(this.getManager().getProjectFile().getBasedirPath()) + File.separator + execName)) : LauncherPlugin.normalize((String)execName);
        }
        return execPath;
    }

    public String getJamaicaAttr() {
        return ((Element)this.getToolNode()).getAttribute("jamaica");
    }

    public void setJamaicaAttr(String jamaicaAttr) {
        if (((Element)this.getToolNode()).hasAttribute("jamaica")) {
            this.toolTag.setAttribute("jamaica", jamaicaAttr);
        }
    }

    public String getEchoMessage() {
        String echoMsg = null;
        if (this.echoTag != null) {
            echoMsg = this.echoTag.getTextContent();
        }
        return echoMsg;
    }

    public void setEchoMessage(String echoMsg) {
        if (this.echoTag != null) {
            this.echoTag.setTextContent(echoMsg);
        } else {
            Element newEchoTag = this.getManager().getProjectFile().getDocument().createElement("echo");
            newEchoTag.setTextContent(echoMsg);
            this.getNode().appendChild(newEchoTag);
            this.echoTag = newEchoTag;
        }
    }

    public static String createEchoMessage(String execPath, boolean isHost) {
        String newLine = "\n";
        String echoStr = String.valueOf(newLine) + "      ";
        echoStr = String.valueOf(echoStr) + Messages.ToolChunk_The_executable_has_been_created_successfully__;
        echoStr = String.valueOf(echoStr) + newLine + "        ";
        echoStr = String.valueOf(echoStr) + execPath;
        echoStr = String.valueOf(echoStr) + newLine + "      ";
        echoStr = isHost ? String.valueOf(echoStr) + Messages.ToolChunk_You_can_launch_it_using_the___Overview___page_in_this_editor__ : String.valueOf(echoStr) + Messages.ToolChunk_Please_transfer_it_to_your_target_device_manually__;
        echoStr = String.valueOf(echoStr) + newLine + "    ";
        return echoStr;
    }

    public void updateEchoMessage() {
        if (this.echoTag != null) {
            String echoStr = ToolChunk.createEchoMessage(this.calcExecutablePath(), this.buildsForHost());
            this.setEchoMessage(echoStr);
        }
    }

    public void promoteSettingEditorDirty(String optionName) {
        ModelPartChangedEvent mpce = new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION_DIRTY, optionName);
        this.fireModelPartChanged(mpce);
    }

    @Override
    public void modelPartChanged(ModelPartChangedEvent mpce) {
        if (mpce.getPart() == ModelPartChangedEvent.ModelPartType.TASKDEF && mpce.getAction() != ModelPartChangedEvent.ActionType.REMOVED && this.taskdef.getName().equals(mpce.getElementName())) {
            try {
                this.setTaskdefName(mpce.getElementName());
            }
            catch (ModelException modelException) {}
        } else if (mpce.getPart() == ModelPartChangedEvent.ModelPartType.ANT_PROPERTY && (mpce.getAction() == ModelPartChangedEvent.ActionType.ADDED || mpce.getAction() == ModelPartChangedEvent.ActionType.CHANGED)) {
            this.revalidate();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getManager().removeListener(this);
    }
}

