/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.core.ToolType;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class OptionValidator {
    public abstract String validate(String var1);

    public static OptionValidator getValidator(final String optname, final ToolChunk tchunk) {
        ToolType tooltype = tchunk.getTaskdef().getToolType();
        if (tooltype.equals((Object)ToolType.JAMAICA) || tooltype.equals((Object)ToolType.JAMAICA_INTERNAL)) {
            if (optname.equals("agentlib")) {
                return new OptionValidator(){
                    private final String AGENT_AND_TRANSPORT_DEFINITION = "BuiltInAgent=transport=dt_socket";
                    private final Pattern OPT_VALIDATION_REGEX = Pattern.compile("BuiltInAgent=transport=dt_socket,server=([yn]),suspend=([yn]),address=([\\p{Alnum}\\.-]+:|.{0})([0-9]{1,5})");

                    public String validate(String value) {
                        return this.OPT_VALIDATION_REGEX.matcher(value).matches() ? null : MessageFormat.format(Messages.OptionValidator_Value___1___does_not_match_the_required_regular_expression, value);
                    }
                };
            }
            if (optname.equals("resource")) {
                return new OptionValidator(){

                    public String validate(String optionValue) {
                        String[] resTokens;
                        String result = null;
                        String baseDirPath = tchunk.getManager().getProjectFile().getBasedirPath();
                        String seps = tchunk.getToolOptions().getSeparators(optname);
                        String[] stringArray = resTokens = optionValue.split("[" + Pattern.quote(seps) + "]");
                        int n = resTokens.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String resToken = stringArray[n2];
                            if (resToken != null && !resToken.isEmpty()) {
                                IPath resourcePath = new Path(resToken).makeRelative();
                                String cpVal = tchunk.getOptionValueResolved("classpath");
                                String[] cpTokens = cpVal.split("[" + Pattern.quote(seps) + "]");
                                boolean matchedClasspath = false;
                                int i = 0;
                                while (i < cpTokens.length && !matchedClasspath) {
                                    if (cpTokens[i] != null && !cpTokens[i].isEmpty()) {
                                        Path classPath = new Path(cpTokens[i]);
                                        if (!classPath.isAbsolute()) {
                                            classPath = new Path(String.valueOf(baseDirPath) + File.separator + classPath);
                                        }
                                        if (classPath.toFile().isDirectory()) {
                                            if (new Path(classPath + File.separator + resourcePath).toFile().isFile()) {
                                                matchedClasspath = true;
                                            }
                                        } else if (classPath.toFile().isFile()) {
                                            try {
                                                ZipFile zipFile = new ZipFile(classPath.toFile());
                                                ZipEntry zipEntry = zipFile.getEntry(resourcePath.toString());
                                                if (zipEntry != null) {
                                                    matchedClasspath = true;
                                                }
                                                zipFile.close();
                                            }
                                            catch (ZipException zipFile) {
                                            }
                                            catch (IOException ioe) {
                                                AntEditorPlugin.log(ioe);
                                            }
                                        }
                                    }
                                    ++i;
                                }
                                if (!matchedClasspath) {
                                    if (result == null) {
                                        result = "";
                                    }
                                    if (!result.isEmpty()) {
                                        result = result.concat(", ");
                                    }
                                    result = result.concat("'" + resourcePath.toString() + "'");
                                }
                            }
                            ++n2;
                        }
                        if (result != null) {
                            result = "The following files are not in the Builder classpath: " + result;
                        }
                        return result;
                    }
                };
            }
            return null;
        }
        return null;
    }
}

