/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.ExecChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecChunkManager
extends ModelPartManager<ExecChunk> {
    public ExecChunkManager(ProjectFile projectFile) {
        super(projectFile);
    }

    public static String getExeAvailPropString(String toolTargetName) {
        return "jamaica.executable_of_" + toolTargetName + "_available";
    }

    @Override
    public ExecChunk getTag(String name) {
        return (ExecChunk)super.getTag(name);
    }

    public void addExecChunk(String name, String depends, String executableName, List<String> args) throws ModelException {
        this.removeExecChunk(name);
        Element newExecTarget = this.getProjectFile().getDocument().createElement("target");
        newExecTarget.setAttribute("name", name);
        newExecTarget.setAttribute("depends", depends);
        Element newExecTag = this.getProjectFile().getDocument().createElement("exec");
        newExecTag.setAttribute("executable", executableName);
        newExecTag.setAttribute("resolveexecutable", "true");
        newExecTarget.appendChild(newExecTag);
        ExecChunk newChunk = new ExecChunk((Node)newExecTarget, newExecTag, this);
        newChunk.setArgs(args);
        this.setTag(name, newChunk);
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.ADDED, ModelPartChangedEvent.ModelPartType.EXEC_CHUNK, name));
    }

    public void addExecChunkForToolTarget(String name, String depends, List<String> args, String toolTargetName) throws ModelException {
        this.removeExecChunk(name);
        Element newExecTarget = this.getProjectFile().getDocument().createElement("target");
        newExecTarget.setAttribute("name", name);
        newExecTarget.setAttribute("depends", depends);
        Element newAvailTag = this.getProjectFile().getDocument().createElement("available");
        newAvailTag.setAttribute("property", ExecChunkManager.getExeAvailPropString(toolTargetName));
        newAvailTag.setAttribute("file", this.getProjectFile().getToolChunkManager().getTag(toolTargetName).calcExecutableName());
        newExecTarget.appendChild(newAvailTag);
        Element newAntcallTag = this.getProjectFile().getDocument().createElement("antcall");
        newAntcallTag.setAttribute("target", toolTargetName);
        newExecTarget.appendChild(newAntcallTag);
        Element newExecTag = this.getProjectFile().getDocument().createElement("exec");
        newExecTag.setAttribute("executable", this.getProjectFile().getToolChunkManager().getTag(toolTargetName).calcExecutableName());
        newExecTag.setAttribute("resolveexecutable", "true");
        newExecTarget.appendChild(newExecTag);
        ExecChunk newChunk = new ExecChunk((Node)newExecTarget, newExecTag, this);
        newChunk.setArgs(args);
        this.setTag(name, newChunk);
        this.getProjectFile().getToolChunkManager().getTag(toolTargetName).setUnless(ExecChunkManager.getExeAvailPropString(toolTargetName));
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.ADDED, ModelPartChangedEvent.ModelPartType.EXEC_CHUNK, name));
    }

    public void removeExecChunk(String name) {
        if (this.removeChunk(name)) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.EXEC_CHUNK, name));
        }
    }
}

