/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.vm;

import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.vm.LaunchingMessages;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JamaicaVMLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    public static final String VM_TYPE_ATTRIBUTE = "com.aicas.jamaica.eclipse.launcher.vm.VM_TYPE";
    public static final String VM_BINARY_NAME_ATTRIBUTE = "com.aicas.jamaica.eclipse.launcher.vm.VM_BINARY_NAME";
    private Text vmAlternateText;
    private String dialogMode = "run";
    private Map<AbstractJamaicaDistribution.VMType, Button> shownVMs = new HashMap<AbstractJamaicaDistribution.VMType, Button>();
    private final SelectionListener selectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent se) {
            Button b;
            if (se.getSource() instanceof Button && (b = (Button)se.getSource()).getText().equals(AbstractJamaicaDistribution.VMType.ALTERNATE.getDescription())) {
                JamaicaVMLaunchConfigurationTab.this.vmAlternateText.setEnabled(b.getSelection());
            }
            JamaicaVMLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        if (this.getLaunchConfigurationDialog() != null) {
            this.dialogMode = this.getLaunchConfigurationDialog().getMode();
        }
        Composite composite = new Composite(parent, parent.getStyle());
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Group group = new Group(composite, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        group.setLayout((Layout)groupLayout);
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        group.setText(LaunchingMessages.JamaicaVMLaunchConfigurationTab_executableGroup_name);
        AbstractJamaicaDistribution.VMType[] vMTypeArray = AbstractJamaicaDistribution.VMType.values();
        int n = vMTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button vmRadioButton;
            AbstractJamaicaDistribution.VMType curVmType = vMTypeArray[n2];
            if (curVmType.name().startsWith("VM") && this.vmFitsLaunchDialogMode(curVmType)) {
                layoutData = new GridData(1);
                layoutData.horizontalSpan = 2;
                vmRadioButton = new Button((Composite)group, 16);
                vmRadioButton.setText(curVmType.getDescription());
                vmRadioButton.setToolTipText(curVmType.getTooltipText());
                vmRadioButton.addSelectionListener(this.selectionAdapter);
                vmRadioButton.setLayoutData((Object)layoutData);
                this.shownVMs.put(curVmType, vmRadioButton);
            } else if (curVmType.name().equals("ALTERNATE")) {
                layoutData = new GridData(1);
                layoutData.horizontalSpan = 1;
                vmRadioButton = new Button((Composite)group, 16);
                vmRadioButton.setText(curVmType.getDescription());
                vmRadioButton.setToolTipText(curVmType.getTooltipText());
                vmRadioButton.addSelectionListener(this.selectionAdapter);
                vmRadioButton.setLayoutData((Object)layoutData);
                this.shownVMs.put(curVmType, vmRadioButton);
                layoutData = new GridData(768);
                this.vmAlternateText = new Text((Composite)group, 2052);
                this.vmAlternateText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        JamaicaVMLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                    }
                });
                this.vmAlternateText.setLayoutData((Object)layoutData);
            }
            ++n2;
        }
        this.setControl((Control)group);
    }

    private boolean vmFitsLaunchDialogMode(AbstractJamaicaDistribution.VMType type) {
        return this.dialogMode.equals("run") && !type.name().contains("DEBUG") || this.dialogMode.equals("debug") && type.name().contains("DEBUG");
    }

    private JamaicaVMDistribution getDistribution(ILaunchConfiguration launchConfig) {
        JamaicaVMDistribution dist = null;
        try {
            File installLocation;
            String jreContainer = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
            if (jreContainer != null && (installLocation = JavaRuntime.getVMInstall((IPath)new Path(jreContainer)).getInstallLocation()) != null) {
                dist = JamaicaVMDistribution.findOrSetup(LauncherPlugin.normalize(installLocation.getAbsolutePath()));
            }
        }
        catch (CoreException ce) {
            LauncherPlugin.log(ce);
        }
        return dist;
    }

    private String getAlternateVMBinaryName(ILaunchConfiguration configuration) {
        String binName = null;
        try {
            Map attributeMap = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
            if (attributeMap != null && attributeMap.get(VM_BINARY_NAME_ATTRIBUTE) != null) {
                binName = (String)attributeMap.get(VM_BINARY_NAME_ATTRIBUTE);
            }
        }
        catch (CoreException ce) {
            LauncherPlugin.log(ce);
        }
        return binName;
    }

    private AbstractJamaicaDistribution.VMType getVMType(ILaunchConfiguration configuration) {
        AbstractJamaicaDistribution.VMType type = AbstractJamaicaDistribution.VMType.VM_DEFAULT;
        try {
            Map attributeMap = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
            if (attributeMap != null && attributeMap.get(VM_TYPE_ATTRIBUTE) != null) {
                type = AbstractJamaicaDistribution.VMType.valueOf((String)((String)attributeMap.get(VM_TYPE_ATTRIBUTE)));
            }
        }
        catch (CoreException ce) {
            LauncherPlugin.log(ce);
        }
        return type;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        JamaicaVMDistribution dist = this.getDistribution(launchConfig);
        if (dist == null) {
            this.setErrorMessage(LaunchingMessages.JamaicaVMLaunchConfigurationTab_Associated_Jamaica_distribution_is_unavailable__);
            return false;
        }
        String vmExePath = null;
        AbstractJamaicaDistribution.VMType vmtype = this.getVMType(launchConfig);
        if (!vmtype.equals((Object)AbstractJamaicaDistribution.VMType.ALTERNATE)) {
            vmExePath = dist.getVM(vmtype);
        } else {
            String binPath = LauncherPlugin.normalize(String.valueOf(dist.getTargetBinDirectory(dist.getHostTarget())) + "/" + this.vmAlternateText.getText());
            File vmFile = new File(binPath);
            if (vmFile.isFile()) {
                vmExePath = vmFile.getAbsolutePath();
            }
        }
        if (vmExePath == null) {
            this.setErrorMessage(LaunchingMessages.JamaicaVMLaunchConfigurationTab_The_VM_is_not_available_in_the_selected_Jamaica_distribution__);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getName() {
        return LaunchingMessages.common_JamaicaVM;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        AbstractJamaicaDistribution.VMType defaultVmType = this.getVMType(configuration);
        this.updateLaunchConfigurationDialog();
        JamaicaVMDistribution dist = this.getDistribution(configuration);
        if (dist != null) {
            Map.Entry[] vmEntries;
            Map.Entry[] entryArray = vmEntries = this.shownVMs.entrySet().toArray(new Map.Entry[0]);
            int n = vmEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String binPath;
                String altBinaryName;
                Map.Entry entry = entryArray[n2];
                AbstractJamaicaDistribution.VMType curType = (AbstractJamaicaDistribution.VMType)entry.getKey();
                String curVMPath = null;
                boolean vmBinaryAvailable = false;
                curVMPath = !curType.equals((Object)AbstractJamaicaDistribution.VMType.ALTERNATE) ? dist.getVM(curType) : ((altBinaryName = this.getAlternateVMBinaryName(configuration)) == null || altBinaryName.isEmpty() ? (this.dialogMode.equals("debug") ? dist.getVM(AbstractJamaicaDistribution.VMType.VM_DEBUG_INTERFACE) : dist.getVM(AbstractJamaicaDistribution.VMType.VM_DEFAULT)) : (binPath = LauncherPlugin.normalize(String.valueOf(dist.getTargetBinDirectory(dist.getHostTarget())) + "/" + altBinaryName)));
                boolean bl = vmBinaryAvailable = curVMPath != null;
                if (vmBinaryAvailable) {
                    String vmBinaryName = curVMPath.substring(curVMPath.lastIndexOf("/") + 1);
                    if (!curType.equals((Object)AbstractJamaicaDistribution.VMType.ALTERNATE)) {
                        ((Button)entry.getValue()).setText(String.valueOf(((Button)entry.getValue()).getText()) + " (" + vmBinaryName + ")");
                    } else {
                        this.vmAlternateText.setText(vmBinaryName);
                    }
                }
                if (!curType.equals((Object)AbstractJamaicaDistribution.VMType.ALTERNATE) && !vmBinaryAvailable) {
                    Button radiobutton = this.shownVMs.get(curType);
                    Composite buttonParent = radiobutton.getParent();
                    radiobutton.setVisible(false);
                    radiobutton.dispose();
                    this.shownVMs.remove(curType);
                    buttonParent.redraw();
                }
                if (defaultVmType.equals((Object)curType) && vmBinaryAvailable) {
                    this.shownVMs.get(curType).setSelection(true);
                }
                ++n2;
            }
            this.vmAlternateText.setEnabled(this.shownVMs.get(AbstractJamaicaDistribution.VMType.ALTERNATE).getSelection());
        }
        this.updateLaunchConfigurationDialog();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        HashMap<String, String> attributeMap = new HashMap<String, String>(1);
        AbstractJamaicaDistribution.VMType vmtype = this.dialogMode.equals("debug") ? AbstractJamaicaDistribution.VMType.VM_DEBUG_INTERFACE : AbstractJamaicaDistribution.VMType.VM_DEFAULT;
        for (Map.Entry<AbstractJamaicaDistribution.VMType, Button> entry : this.shownVMs.entrySet()) {
            if (!entry.getValue().getSelection()) continue;
            vmtype = entry.getKey();
        }
        attributeMap.put(VM_TYPE_ATTRIBUTE, vmtype.name());
        if (vmtype.equals((Object)AbstractJamaicaDistribution.VMType.ALTERNATE)) {
            attributeMap.put(VM_BINARY_NAME_ATTRIBUTE, this.vmAlternateText.getText());
        }
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, attributeMap);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        HashMap<String, String> attributeMap = new HashMap<String, String>(1);
        if (this.dialogMode.equals("debug")) {
            attributeMap.put(VM_TYPE_ATTRIBUTE, AbstractJamaicaDistribution.VMType.VM_DEBUG_INTERFACE.name());
        } else {
            attributeMap.put(VM_TYPE_ATTRIBUTE, AbstractJamaicaDistribution.VMType.VM_DEFAULT.name());
        }
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, attributeMap);
    }
}

