/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.dialog;

import com.aicas.jamaica.eclipse.launcher.dialog.DialogMessages;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class JamaicaVMDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private Object lock = new Object();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MessageFormat.format("{0}...", configuration.getName()), 3);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            monitor.subTask(DialogMessages.JamaicaVMDelegate_verifying_launch_attributes);
            String mainTypeName = this.verifyMainTypeName(configuration);
            IVMRunner runner = this.getVMRunner(configuration, mode);
            File workingDir = this.verifyWorkingDirectory(configuration);
            String workingDirName = null;
            if (workingDir != null) {
                workingDirName = workingDir.getAbsolutePath();
            }
            String[] nativeEnvironment = this.getEnvironment(configuration);
            String[] mapEnvironment = null;
            String[] finalEnvironment = null;
            Map envmap = configuration.getAttribute("com.aicas.jamaica.eclipse.launcher.jamaicavm_map", null);
            if (envmap != null) {
                Set entrySet = envmap.entrySet();
                Iterator iter = entrySet.iterator();
                while (iter.hasNext()) {
                    if (!((String)iter.next().getValue()).equals("")) continue;
                    iter.remove();
                }
            }
            mapEnvironment = new String[envmap.entrySet().size()];
            int i = 0;
            for (Map.Entry entry : envmap.entrySet()) {
                mapEnvironment[i] = entry.toString();
                ++i;
            }
            if (nativeEnvironment != null && mapEnvironment != null) {
                finalEnvironment = new String[mapEnvironment.length + nativeEnvironment.length];
                System.arraycopy(nativeEnvironment, 0, finalEnvironment, 0, nativeEnvironment.length);
                System.arraycopy(mapEnvironment, 0, finalEnvironment, nativeEnvironment.length, mapEnvironment.length);
            } else if (mapEnvironment != null && nativeEnvironment == null) {
                finalEnvironment = new String[mapEnvironment.length];
                System.arraycopy(mapEnvironment, 0, finalEnvironment, 0, mapEnvironment.length);
            } else if (mapEnvironment == null && nativeEnvironment != null) {
                finalEnvironment = new String[nativeEnvironment.length];
                System.arraycopy(nativeEnvironment, 0, finalEnvironment, 0, nativeEnvironment.length);
            }
            String pgmArgs = this.getProgramArguments(configuration);
            String vmArgs = this.getVMArguments(configuration);
            ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
            Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
            String[] classpath = this.getClasspath(configuration);
            VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainTypeName, classpath);
            runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
            runConfig.setEnvironment(finalEnvironment);
            runConfig.setVMArguments(execArgs.getVMArgumentsArray());
            runConfig.setWorkingDirectory(workingDirName);
            runConfig.setVMSpecificAttributesMap(vmAttributesMap);
            runConfig.setBootClassPath(this.getBootpath(configuration));
            if (monitor.isCanceled()) {
                return;
            }
            this.prepareStopInMain(configuration);
            monitor.worked(1);
            monitor.subTask(DialogMessages.JamaicaVMDelegate_creating_source_locator);
            this.setDefaultSourceLocator(launch, configuration);
            monitor.worked(1);
            runner.run(runConfig, launch, monitor);
            if (monitor.isCanceled()) {
                return;
            }
        }
        finally {
            monitor.done();
        }
    }
}

