/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.DOMUtils;
import com.aicas.jamaica.eclipse.ant_editor.model.ProblemManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ToolOption {
    private final ToolChunk toolChunk;
    public static final String ATTR_ENABLED = "enabled";
    public static final String ATTR_APPEND = "append";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_NAME = "name";
    private Element optionElement;
    private boolean valid;
    private ProblemManager.Problem problem;

    public ToolOption(ToolChunk toolChunk, Element optElement) {
        this.toolChunk = toolChunk;
        this.optionElement = optElement;
    }

    public String getValue() {
        return this.optionElement.getAttribute(ATTR_VALUE);
    }

    public void setValue(String value) {
        this.optionElement.setAttribute(ATTR_VALUE, value);
    }

    public boolean getState() {
        boolean res = this.optionElement.getAttribute(ATTR_ENABLED).isEmpty() ? true : Boolean.parseBoolean(this.optionElement.getAttribute(ATTR_ENABLED));
        return res;
    }

    public void setState(boolean state) {
        this.optionElement.setAttribute(ATTR_ENABLED, Boolean.toString(state));
    }

    public boolean hasAppendSyntax() {
        return Boolean.parseBoolean(this.optionElement.getAttribute(ATTR_APPEND));
    }

    public void setAppendSyntax(boolean appendSyntax) {
        this.optionElement.setAttribute(ATTR_APPEND, Boolean.toString(appendSyntax));
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isInitialized() {
        return this.valid || this.problem != null;
    }

    public boolean isChildOfTree() {
        Node parent = this.optionElement.getParentNode();
        return this.toolChunk.getToolNode().isSameNode(parent);
    }

    public boolean addToTree() {
        boolean res = false;
        Node parent = this.optionElement.getParentNode();
        if (parent == null) {
            String optName;
            if (!this.optionElement.getOwnerDocument().equals(this.toolChunk.getToolNode().getOwnerDocument())) {
                this.optionElement = (Element)this.toolChunk.getToolNode().getOwnerDocument().adoptNode(this.optionElement);
            }
            if (this.toolChunk.options.containsKey(optName = this.getName())) {
                Element oldOpt = this.toolChunk.options.get(optName).getElement();
                oldOpt.getParentNode().replaceChild(this.optionElement, oldOpt);
                res = true;
            } else {
                res = DOMUtils.appendNode(this.toolChunk.getToolNode(), this.optionElement);
            }
        }
        return res;
    }

    public boolean removeFromTree() {
        return DOMUtils.removeNode(this.optionElement);
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public ProblemManager.Problem getProblem() {
        return this.problem;
    }

    public void setProblem(ProblemManager.Problem problem) {
        this.problem = problem;
    }

    public String getName() {
        String optionName = "";
        optionName = this.getElement().getTagName().toLowerCase().equals("option") ? this.getElement().getAttribute(ATTR_NAME) : this.getElement().getTagName();
        return optionName;
    }

    public Element getElement() {
        return this.optionElement;
    }

    public String toString() {
        return "Option:name=" + this.getName() + ":value=" + this.getValue() + ":state=" + this.getState() + ":append=" + this.hasAppendSyntax() + ":valid=" + this.isValid() + ":problem=" + this.getProblem();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getValue() == null ? 0 : this.getValue().hashCode());
        result = 31 * result + (this.getState() ? 1231 : 1237);
        result = 31 * result + (this.hasAppendSyntax() ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolOption)) {
            return false;
        }
        ToolOption other = (ToolOption)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.optionElement.getTagName().equals(other.optionElement.getTagName())) {
            return false;
        }
        if (!this.getValue().equals(other.getValue())) {
            return false;
        }
        if (this.optionElement.hasAttribute(ATTR_ENABLED) != other.optionElement.hasAttribute(ATTR_ENABLED)) {
            return false;
        }
        if (this.getState() != other.getState()) {
            return false;
        }
        if (this.optionElement.hasAttribute(ATTR_APPEND) != other.optionElement.hasAttribute(ATTR_APPEND)) {
            return false;
        }
        if (this.hasAppendSyntax() != other.hasAppendSyntax()) {
            return false;
        }
        return this.isValid() == other.isValid();
    }
}

