/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors.se;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.AbstractSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.ui.CheckboxListViewer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ListSelectionSettingEditor
extends AbstractSettingEditor {
    private StructuredViewer valueViewer;
    private List<String> selectableValues;
    private boolean isMulti;
    private String separators;

    public ListSelectionSettingEditor(String optionName, ToolChunk chunk) {
        super(optionName, chunk);
    }

    protected void createInputArea(Composite parent, FormToolkit toolkit) {
        GridLayout gridLay = new GridLayout(1, false);
        gridLay.verticalSpacing = 10;
        gridLay.marginHeight = 10;
        gridLay.marginWidth = 10;
        parent.setLayout((Layout)gridLay);
        GridData boxGridData = GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(450, -1).create();
        List args = this.model.getToolOptions().getOptionEditorArgs(this.associatedOption);
        this.isMulti = args.contains("multi");
        this.separators = this.model.getToolOptions().getSeparators(this.associatedOption);
        List list = this.selectableValues = this.isMulti ? args.subList(1, args.size()) : args;
        if (this.isMulti) {
            boxGridData.heightHint = 140;
            this.valueViewer = new CheckboxListViewer(parent);
            this.valueViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selectedItems = (StructuredSelection)ListSelectionSettingEditor.this.valueViewer.getSelection();
                    if (selectedItems.isEmpty()) {
                        ListSelectionSettingEditor.this.setValue("none");
                    } else {
                        ListSelectionSettingEditor.this.setValue(AntEditorPlugin.join(selectedItems.toArray(), ListSelectionSettingEditor.this.separators));
                    }
                }
            });
        } else {
            boxGridData.verticalAlignment = 128;
            this.valueViewer = new ComboViewer(parent, 12);
            this.valueViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    String newValue = (String)((IStructuredSelection)ListSelectionSettingEditor.this.valueViewer.getSelection()).getFirstElement();
                    if (newValue == null) {
                        newValue = ((ComboViewer)ListSelectionSettingEditor.this.valueViewer).getCombo().getText();
                    }
                    ListSelectionSettingEditor.this.setValue(newValue);
                }
            });
        }
        this.valueViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.valueViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.valueViewer.setInput(this.selectableValues);
        this.valueViewer.getControl().setLayoutData((Object)boxGridData);
        this.valueViewer.getControl().setFont(this.groupFont);
        this.invalidDecorator = new ControlDecoration(this.valueViewer.getControl(), 0x1004000, (Composite)this.optionControls);
    }

    public void updateUI() {
        super.updateUI();
        List args = this.model.getToolOptions().getOptionEditorArgs(this.associatedOption);
        this.separators = this.model.getToolOptions().getSeparators(this.associatedOption);
        List<String> oldSelectableValues = this.selectableValues;
        if (args != null) {
            this.isMulti = args.contains("multi");
            this.selectableValues = this.isMulti ? args.subList(1, args.size()) : args;
        } else {
            this.selectableValues = Collections.emptyList();
        }
        if (!oldSelectableValues.equals(this.selectableValues)) {
            Control focusControl = this.valueViewer.getControl().getDisplay().getFocusControl();
            this.valueViewer.setInput(this.selectableValues);
            focusControl.forceFocus();
        }
        this.valueViewer.getControl().setEnabled(this.getState());
        String optionValue = this.getValueResolved();
        if (this.isMulti) {
            if (optionValue.equals("all")) {
                this.valueViewer.setSelection((ISelection)new StructuredSelection(this.selectableValues));
            } else if (optionValue.equals("none")) {
                this.valueViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                String[] tokens;
                ArrayList<String> checkedElements = new ArrayList<String>();
                String[] stringArray = tokens = optionValue.split(this.separators);
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    if (this.selectableValues.contains(token)) {
                        checkedElements.add(token);
                    }
                    ++n2;
                }
                this.valueViewer.setSelection((ISelection)new StructuredSelection(checkedElements));
            }
        } else if (this.selectableValues.contains(optionValue)) {
            this.valueViewer.setSelection((ISelection)new StructuredSelection((Object)optionValue));
        } else {
            this.valueViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public void grabFocus() {
        super.grabFocus();
        this.valueViewer.getControl().setFocus();
    }
}

